/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class LoginRedirectFilter
implements Filter {
    String loginUrl;
    private static final Logger log = LoggerFactory.getLogger(LoginRedirectFilter.class);

    public void init(FilterConfig config) throws ServletException {
        this.loginUrl = config.getInitParameter("LOGIN_URL");
        log.info((Object)("Filter configuration: loginUrl=" + this.loginUrl));
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        boolean isLoginInProgress = this.isLoginInProgress(httpRequest);
        if (isLoginInProgress) {
            String urlToRedirect = this.getLoginRedirectURL(httpRequest);
            urlToRedirect = httpResponse.encodeRedirectURL(urlToRedirect);
            httpResponse.sendRedirect(urlToRedirect);
            return;
        }
        chain.doFilter(request, response);
    }

    protected String getLoginRedirectURL(HttpServletRequest httpRequest) {
        return this.loginUrl;
    }

    private boolean isLoginInProgress(HttpServletRequest request) {
        String action = request.getRequestURI();
        return action != null && action.equals(request.getContextPath() + "/sso");
    }
}

