/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.cas;

import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.gatein.sso.agent.GenericAgent;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas20ProxyTicketValidator;

public class CASAgent
extends GenericAgent {
    private static Logger log = Logger.getLogger(CASAgent.class);
    private static CASAgent singleton;
    private String casServerUrl;
    private boolean renewTicket;
    private String casServiceUrl;

    private CASAgent(String casServerUrl, String casServiceUrl) {
        this.casServerUrl = casServerUrl;
        this.casServiceUrl = casServiceUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CASAgent getInstance(String casServerUrl, String casServiceUrl) {
        if (singleton != null) return singleton;
        Class<CASAgent> clazz = CASAgent.class;
        synchronized (CASAgent.class) {
            if (singleton != null) return singleton;
            singleton = new CASAgent(casServerUrl, casServiceUrl);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return singleton;
        }
    }

    public boolean isRenewTicket() {
        return this.renewTicket;
    }

    public void setRenewTicket(boolean renewTicket) {
        this.renewTicket = renewTicket;
    }

    public void validateTicket(HttpServletRequest httpRequest, String ticket) throws Exception {
        Cas20ProxyTicketValidator ticketValidator = new Cas20ProxyTicketValidator(this.casServerUrl);
        ticketValidator.setRenew(this.renewTicket);
        Assertion assertion = ticketValidator.validate(ticket, this.casServiceUrl);
        log.debug((Object)"------------------------------------------------------------------------------------");
        log.debug((Object)("Service: " + this.casServiceUrl));
        log.debug((Object)("Principal: " + assertion.getPrincipal().getName()));
        log.debug((Object)"------------------------------------------------------------------------------------");
        String principal = assertion.getPrincipal().getName();
        this.saveSSOCredentials(principal, httpRequest);
    }
}

