/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.sso.agent.cas.CASAgent;
import org.gatein.sso.agent.josso.JOSSOAgent;
import org.gatein.sso.agent.opensso.OpenSSOAgent;

public class InitiateLoginFilter
implements Filter {
    private static Logger log = LoggerFactory.getLogger(InitiateLoginFilter.class);
    private static final int DEFAULT_MAX_NUMBER_OF_LOGIN_ERRORS = 3;
    private String ssoServerUrl;
    private String ssoCookieName;
    private boolean casRenewTicket;
    private String casServiceUrl;
    private String loginUrl;
    private int maxNumberOfLoginErrors;

    public void init(FilterConfig filterConfig) throws ServletException {
        String maxNumberOfLoginErrorsConfig;
        String casServiceUrlConfig;
        this.ssoServerUrl = filterConfig.getInitParameter("ssoServerUrl");
        this.ssoCookieName = filterConfig.getInitParameter("ssoCookieName");
        this.loginUrl = filterConfig.getInitParameter("loginUrl");
        String casRenewTicketConfig = filterConfig.getInitParameter("casRenewTicket");
        if (casRenewTicketConfig != null) {
            this.casRenewTicket = Boolean.parseBoolean(casRenewTicketConfig);
        }
        if ((casServiceUrlConfig = filterConfig.getInitParameter("casServiceUrl")) != null && casServiceUrlConfig.trim().length() > 0) {
            this.casServiceUrl = casServiceUrlConfig;
        }
        this.maxNumberOfLoginErrors = (maxNumberOfLoginErrorsConfig = filterConfig.getInitParameter("maxNumberOfLoginErrors")) == null ? 3 : Integer.parseInt(maxNumberOfLoginErrorsConfig);
        log.info((Object)("InitiateLoginFilter configuration: ssoServerUrl=" + this.ssoServerUrl + ", ssoCookieName=" + this.ssoCookieName + ", loginUrl=" + this.loginUrl + ", casRenewTicket=" + this.casRenewTicket + ", casServiceUrl=" + this.casServiceUrl + ", maxNumberOfLoginErrors=" + this.maxNumberOfLoginErrors));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse resp = (HttpServletResponse)response;
            this.processSSOToken(req, resp);
            if (resp.isCommitted()) {
                return;
            }
            String portalContext = req.getContextPath();
            if (req.getAttribute("abort") != null) {
                String ssoRedirect = portalContext + "/sso";
                resp.sendRedirect(ssoRedirect);
                return;
            }
            resp.sendRedirect(this.loginUrl);
            return;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
    }

    private void processSSOToken(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        String ticket = httpRequest.getParameter("ticket");
        String jossoAssertion = httpRequest.getParameter("josso_assertion_id");
        if (ticket != null && ticket.trim().length() > 0) {
            CASAgent casagent = CASAgent.getInstance(this.ssoServerUrl, this.casServiceUrl);
            casagent.setRenewTicket(this.casRenewTicket);
            casagent.validateTicket(httpRequest, ticket);
        } else if (jossoAssertion != null && jossoAssertion.trim().length() > 0) {
            JOSSOAgent.getInstance().validateTicket(httpRequest, httpResponse);
        } else {
            try {
                OpenSSOAgent.getInstance(this.ssoServerUrl, this.ssoCookieName).validateTicket(httpRequest, httpResponse);
            }
            catch (IllegalStateException ilse) {
                int currentNumberOfErrors = this.getCountOfUnsuccessfulAttempts(httpRequest);
                log.warn((Object)("Count of login errors: " + currentNumberOfErrors));
                if (currentNumberOfErrors >= this.maxNumberOfLoginErrors) {
                    log.warn((Object)"Max. number of login errors reached. Rethrowing exception");
                    throw ilse;
                }
                httpRequest.setAttribute("abort", (Object)Boolean.TRUE);
            }
        }
    }

    private int getCountOfUnsuccessfulAttempts(HttpServletRequest httpRequest) {
        Integer currentNumberOfErrors = (Integer)httpRequest.getSession().getAttribute("InitiateLoginFilter.currentNumberOfErrors");
        if (currentNumberOfErrors == null) {
            currentNumberOfErrors = 0;
        }
        currentNumberOfErrors = currentNumberOfErrors + 1;
        httpRequest.getSession().setAttribute("InitiateLoginFilter.currentNumberOfErrors", (Object)currentNumberOfErrors);
        return currentNumberOfErrors;
    }
}

