/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.opensso;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.sso.agent.GenericAgent;
import org.gatein.sso.agent.opensso.CDMessageContext;
import org.gatein.sso.agent.opensso.CDMessageParser;

public class OpenSSOAgent
extends GenericAgent {
    public static final String IN_RESPONSE_TO_ATTR = "OpenSSOAgent.InResponseTo";
    private static Logger log = LoggerFactory.getLogger(OpenSSOAgent.class);
    private static OpenSSOAgent singleton;
    private String cookieName;
    private String serverUrl;
    private CDMessageParser cdcMessageParser = new CDMessageParser();

    private OpenSSOAgent(String serverUrl, String cookieName) {
        this.serverUrl = serverUrl;
        this.cookieName = cookieName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OpenSSOAgent getInstance(String serverUrl, String cookieName) {
        if (singleton != null) return singleton;
        Class<OpenSSOAgent> clazz = OpenSSOAgent.class;
        synchronized (OpenSSOAgent.class) {
            if (singleton != null) return singleton;
            singleton = new OpenSSOAgent(serverUrl, cookieName);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return singleton;
        }
    }

    public void validateTicket(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        if (this.tryMessageFromCDC(httpRequest, httpResponse)) {
            return;
        }
        String token = null;
        Cookie[] cookies = httpRequest.getCookies();
        if (cookies == null) {
            return;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(this.cookieName)) continue;
            token = cookie.getValue();
            break;
        }
        if (token == null) {
            this.throwIllegalStateException("No SSO Tokens Found");
        }
        if (token != null) {
            String subject;
            boolean isValid = this.isTokenValid(token);
            if (!isValid) {
                this.throwIllegalStateException("OpenSSO Token is not valid!!");
            }
            if ((subject = this.getSubject(token)) != null) {
                this.saveSSOCredentials(subject, httpRequest);
            }
        }
    }

    protected boolean tryMessageFromCDC(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        String encodedCDCMessage = httpRequest.getParameter("LARES");
        if (encodedCDCMessage == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Message from CDC not found in this HttpServletRequest");
            }
            return false;
        }
        CDMessageContext messageContext = this.cdcMessageParser.parseMessage(encodedCDCMessage);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Successfully parsed messageContext " + messageContext));
        }
        this.validateCDMessageContext(httpRequest, messageContext);
        String ssoToken = messageContext.getSsoToken();
        Cookie cookie = new Cookie(this.cookieName, "\"" + ssoToken + "\"");
        cookie.setPath(httpRequest.getContextPath());
        httpResponse.addCookie(cookie);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Cookie " + this.cookieName + " with value " + ssoToken + " added to HttpResponse"));
        }
        String urlToRedirect = httpResponse.encodeRedirectURL(httpRequest.getRequestURI());
        httpResponse.sendRedirect(urlToRedirect);
        return true;
    }

    protected void validateCDMessageContext(HttpServletRequest httpRequest, CDMessageContext context) {
        if (!context.getSuccess().booleanValue()) {
            this.throwIllegalStateException("CDMessageContext contains success=false. Check SAML message from CDCServlet");
        }
        Integer inResponseToFromCDC = context.getInResponseTo();
        Integer inResponseToFromSession = (Integer)httpRequest.getSession().getAttribute(IN_RESPONSE_TO_ATTR);
        if (inResponseToFromSession == null || inResponseToFromCDC == null || !inResponseToFromCDC.equals(inResponseToFromSession)) {
            this.throwIllegalStateException("inResponseTo from CDC message is " + inResponseToFromCDC + ", inResponseTo from Http session is " + inResponseToFromSession + ". Both should have same value");
        }
        if (context.getSsoToken() == null) {
            this.throwIllegalStateException("No token found in CDMessageContext. Check SAML message from CDCServlet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTokenValid(String token) throws Exception {
        HttpClient client = new HttpClient();
        PostMethod post = null;
        try {
            String url = this.serverUrl + "/identity/isTokenValid";
            post = new PostMethod(url);
            post.addParameter("tokenid", token);
            int status = client.executeMethod((HttpMethod)post);
            String response = post.getResponseBodyAsString();
            log.debug((Object)"-------------------------------------------------------");
            log.debug((Object)("Status: " + status));
            log.debug((Object)("Response: " + response));
            log.debug((Object)"-------------------------------------------------------");
            if (response.contains(Boolean.TRUE.toString())) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSubject(String token) throws Exception {
        HttpClient client = new HttpClient();
        PostMethod post = null;
        try {
            String uid = null;
            String url = this.serverUrl + "/identity/attributes";
            post = new PostMethod(url);
            post.addParameter("subjectid", token);
            post.addParameter("attributes_names", "uid");
            int status = client.executeMethod((HttpMethod)post);
            String response = post.getResponseBodyAsString();
            log.debug((Object)"--------------------------------------------------------");
            log.debug((Object)("Status: " + status));
            log.debug((Object)response);
            log.debug((Object)"--------------------------------------------------------");
            if (response != null) {
                Properties properties = this.loadAttributes(response);
                uid = properties.getProperty("uid");
            }
            String string = uid;
            return string;
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadAttributes(String response) throws Exception {
        InputStream is = null;
        try {
            Properties properties = new Properties();
            String[] tokens = response.split(System.getProperty("line.separator"));
            String name = null;
            for (String token : tokens) {
                if (token.startsWith("userdetails.attribute.name")) {
                    name = token.substring(token.indexOf("=") + 1);
                    continue;
                }
                if (!token.startsWith("userdetails.attribute.value")) continue;
                String value = token.substring(token.indexOf("=") + 1);
                if (name != null) {
                    properties.setProperty(name, value);
                }
                name = null;
            }
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private void throwIllegalStateException(String message) {
        log.warn((Object)message);
        IllegalStateException ise = new IllegalStateException(message);
        throw ise;
    }
}

