/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.saml;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.wci.impl.DefaultServletContainerFactory;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.saml.v2.protocol.LogoutRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.picketlink.identity.federation.web.core.HTTPContext;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2LogOutHandler;

public class PortalSAML2LogOutHandler
extends SAML2LogOutHandler {
    private static Logger log = LoggerFactory.getLogger(PortalSAML2LogOutHandler.class);

    public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (!(request.getSAML2Object() instanceof LogoutRequestType)) {
            return;
        }
        HTTPContext httpContext = (HTTPContext)request.getContext();
        HttpServletRequest servletRequest = httpContext.getRequest();
        HttpServletResponse servletResponse = httpContext.getResponse();
        Session catalinaSession = this.getCatalinaSession(servletRequest);
        super.handleRequestType(request, response);
        if (!catalinaSession.isValid()) {
            this.portalLogout(servletRequest, servletResponse);
        }
    }

    public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (request.getSAML2Object() instanceof ResponseType) {
            return;
        }
        if (!(request.getSAML2Object() instanceof StatusResponseType)) {
            return;
        }
        HTTPContext httpContext = (HTTPContext)request.getContext();
        HttpServletRequest servletRequest = httpContext.getRequest();
        HttpServletResponse servletResponse = httpContext.getResponse();
        Session catalinaSession = this.getCatalinaSession(servletRequest);
        super.handleStatusResponseType(request, response);
        if (!catalinaSession.isValid()) {
            this.portalLogout(servletRequest, servletResponse);
        }
    }

    protected void portalLogout(HttpServletRequest request, HttpServletResponse response) {
        block2: {
            request.getSession(true);
            try {
                DefaultServletContainerFactory.getInstance().getServletContainer().logout(request, response);
            }
            catch (Exception e) {
                String message = "Session has been invalidated but WCI logout failed.";
                log.warn((Object)message);
                if (!log.isTraceEnabled()) break block2;
                log.trace((Object)message, (Throwable)e);
            }
        }
    }

    private Session getCatalinaSession(HttpServletRequest servletRequest) {
        if (!(servletRequest instanceof Request)) {
            throw new IllegalStateException("servletRequest is of class " + servletRequest.getClass() + ", which is not instanceof " + Request.class);
        }
        Request catalinaRequest = (Request)servletRequest;
        return catalinaRequest.getSessionInternal(false);
    }
}

