/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.filter;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public abstract class AbstractLogoutFilter
implements Filter {
    protected String logoutUrl;
    private static final String fileEncoding = System.getProperty("file.encoding");
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void init(FilterConfig config) throws ServletException {
        this.logoutUrl = config.getInitParameter("LOGOUT_URL");
        this.log.info((Object)("Reading filter configuration: logoutUrl=" + this.logoutUrl));
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        boolean isLogoutInProgress = this.isLogoutInProgress(httpRequest);
        if (isLogoutInProgress) {
            if (httpRequest.getSession().getAttribute("SSO_LOGOUT_FLAG") == null) {
                httpRequest.getSession().setAttribute("SSO_LOGOUT_FLAG", (Object)Boolean.TRUE);
                String redirectUrl = this.getRedirectUrl(httpRequest);
                redirectUrl = httpResponse.encodeRedirectURL(redirectUrl);
                httpResponse.sendRedirect(redirectUrl);
                return;
            }
            httpRequest.getSession().removeAttribute("SSO_LOGOUT_FLAG");
        }
        chain.doFilter(request, response);
    }

    private boolean isLogoutInProgress(HttpServletRequest request) throws UnsupportedEncodingException {
        String action;
        if (fileEncoding != null) {
            request.setCharacterEncoding(fileEncoding);
        }
        return (action = request.getParameter("portal:action")) != null && action.equals("Logout");
    }

    protected abstract String getRedirectUrl(HttpServletRequest var1);
}

