/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.sso.agent.cas.CASAgent;
import org.gatein.sso.agent.filter.api.AbstractSSOInterceptor;
import org.gatein.sso.agent.josso.JOSSOAgent;
import org.gatein.sso.agent.opensso.OpenSSOAgent;

public class InitiateLoginFilter
extends AbstractSSOInterceptor {
    private static Logger log = LoggerFactory.getLogger(InitiateLoginFilter.class);
    private static final int DEFAULT_MAX_NUMBER_OF_LOGIN_ERRORS = 3;
    private String ssoServerUrl;
    private String ssoCookieName;
    private boolean casRenewTicket;
    private String casServiceUrl;
    private String loginUrl;
    private int maxNumberOfLoginErrors;
    private boolean attachUsernamePasswordToLoginURL;
    private CASAgent casAgent;
    private JOSSOAgent jossoAgent;
    private OpenSSOAgent openSSOAgent;

    @Override
    protected void initImpl() {
        String maxNumberOfLoginErrorsConfig;
        String casServiceUrlConfig;
        this.ssoServerUrl = this.getInitParameter("ssoServerUrl");
        this.ssoCookieName = this.getInitParameter("ssoCookieName");
        this.loginUrl = this.getInitParameter("loginUrl");
        String casRenewTicketConfig = this.getInitParameter("casRenewTicket");
        if (casRenewTicketConfig != null) {
            this.casRenewTicket = Boolean.parseBoolean(casRenewTicketConfig);
        }
        if ((casServiceUrlConfig = this.getInitParameter("casServiceUrl")) != null && casServiceUrlConfig.trim().length() > 0) {
            this.casServiceUrl = casServiceUrlConfig;
        }
        this.maxNumberOfLoginErrors = (maxNumberOfLoginErrorsConfig = this.getInitParameter("maxNumberOfLoginErrors")) == null ? 3 : Integer.parseInt(maxNumberOfLoginErrorsConfig);
        String attachUsernamePasswordToLoginURLConfig = this.getInitParameter("attachUsernamePasswordToLoginURL");
        this.attachUsernamePasswordToLoginURL = attachUsernamePasswordToLoginURLConfig == null ? true : Boolean.parseBoolean(attachUsernamePasswordToLoginURLConfig);
        log.info((Object)("InitiateLoginFilter configuration: ssoServerUrl=" + this.ssoServerUrl + ", ssoCookieName=" + this.ssoCookieName + ", loginUrl=" + this.loginUrl + ", casRenewTicket=" + this.casRenewTicket + ", casServiceUrl=" + this.casServiceUrl + ", maxNumberOfLoginErrors=" + this.maxNumberOfLoginErrors + ", attachUsernamePasswordToLoginURL=" + this.attachUsernamePasswordToLoginURL));
    }

    protected CASAgent getCasAgent() {
        if (this.casAgent == null) {
            CASAgent casAgent = (CASAgent)this.getExoContainer().getComponentInstanceOfType(CASAgent.class);
            if (casAgent == null) {
                throw new IllegalStateException("CASAgent component not provided in PortalContainer");
            }
            casAgent.setCasServerUrl(this.ssoServerUrl);
            casAgent.setCasServiceUrl(this.casServiceUrl);
            casAgent.setRenewTicket(this.casRenewTicket);
            this.casAgent = casAgent;
        }
        return this.casAgent;
    }

    protected JOSSOAgent getJOSSOAgent() {
        if (this.jossoAgent == null) {
            JOSSOAgent jossoAgent = (JOSSOAgent)this.getExoContainer().getComponentInstanceOfType(JOSSOAgent.class);
            if (jossoAgent == null) {
                throw new IllegalStateException("JOSSOAgent component not provided in PortalContainer");
            }
            this.jossoAgent = jossoAgent;
        }
        return this.jossoAgent;
    }

    protected OpenSSOAgent getOpenSSOAgent() {
        if (this.openSSOAgent == null) {
            OpenSSOAgent openssoAgent = (OpenSSOAgent)this.getExoContainer().getComponentInstanceOfType(OpenSSOAgent.class);
            if (openssoAgent == null) {
                throw new IllegalStateException("OpenSSOAgent component not provided in PortalContainer");
            }
            openssoAgent.setServerUrl(this.ssoServerUrl);
            openssoAgent.setCookieName(this.ssoCookieName);
            this.openSSOAgent = openssoAgent;
        }
        return this.openSSOAgent;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse resp = (HttpServletResponse)response;
            this.processSSOToken(req, resp);
            if (resp.isCommitted()) {
                return;
            }
            String portalContext = req.getContextPath();
            if (req.getAttribute("abort") != null) {
                String ssoRedirect = portalContext + "/sso";
                resp.sendRedirect(ssoRedirect);
                return;
            }
            String loginRedirectURL = resp.encodeRedirectURL(this.getLoginRedirectUrl(req));
            resp.sendRedirect(loginRedirectURL);
            return;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
    }

    private void processSSOToken(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        String ticket = httpRequest.getParameter("ticket");
        String jossoAssertion = httpRequest.getParameter("josso_assertion_id");
        if (ticket != null && ticket.trim().length() > 0) {
            this.getCasAgent().validateTicket(httpRequest, ticket);
        } else if (jossoAssertion != null && jossoAssertion.trim().length() > 0) {
            this.getJOSSOAgent().validateTicket(httpRequest, httpResponse);
        } else {
            try {
                this.getOpenSSOAgent().validateTicket(httpRequest, httpResponse);
            }
            catch (IllegalStateException ilse) {
                int currentNumberOfErrors = this.getCountOfUnsuccessfulAttempts(httpRequest);
                log.warn((Object)("Count of login errors: " + currentNumberOfErrors));
                if (currentNumberOfErrors >= this.maxNumberOfLoginErrors) {
                    log.warn((Object)"Max. number of login errors reached. Rethrowing exception");
                    throw ilse;
                }
                httpRequest.setAttribute("abort", (Object)Boolean.TRUE);
            }
        }
    }

    private int getCountOfUnsuccessfulAttempts(HttpServletRequest httpRequest) {
        Integer currentNumberOfErrors = (Integer)httpRequest.getSession().getAttribute("InitiateLoginFilter.currentNumberOfErrors");
        if (currentNumberOfErrors == null) {
            currentNumberOfErrors = 0;
        }
        currentNumberOfErrors = currentNumberOfErrors + 1;
        httpRequest.getSession().setAttribute("InitiateLoginFilter.currentNumberOfErrors", (Object)currentNumberOfErrors);
        return currentNumberOfErrors;
    }

    protected String getLoginRedirectUrl(HttpServletRequest req) {
        StringBuilder url = new StringBuilder(this.loginUrl);
        if (this.attachUsernamePasswordToLoginURL) {
            String fakeUsername = req.getSession().getId() + "_" + String.valueOf(System.currentTimeMillis());
            url.append("?username=").append(fakeUsername).append("&password=").append(fakeUsername);
        }
        return url.toString();
    }
}

