/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.josso;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.servlet.http.HttpServletRequest;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.josso.agent.AbstractSSOAgent;
import org.josso.agent.Lookup;
import org.josso.agent.SSOPartnerAppConfig;
import org.josso.agent.http.HttpSSOAgent;

public class JOSSOUtils {
    private static Logger log = LoggerFactory.getLogger(JOSSOUtils.class);
    private static final String PROPERTY_AGENT_CONFIG_FILE = "gatein.sso.josso.agent.config.file";

    public static HttpSSOAgent lookupSSOAgent() throws Exception {
        Lookup lookup = Lookup.getInstance();
        String location = JOSSOUtils.getSystemProperty(PROPERTY_AGENT_CONFIG_FILE, "josso-agent-config.xml");
        log.info((Object)("Using JOSSO agent from location " + location));
        lookup.init(location);
        return (HttpSSOAgent)lookup.lookupSSOAgent();
    }

    public static String getPartnerAppId(AbstractSSOAgent jossoAgent, HttpServletRequest hreq) {
        String requester = null;
        SSOPartnerAppConfig partnerAppConfig = jossoAgent.getPartnerAppConfig(hreq.getServerName(), hreq.getContextPath());
        if (partnerAppConfig != null) {
            requester = partnerAppConfig.getId();
        }
        if (requester == null) {
            requester = hreq.getContextPath().substring(1);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Using partnerAppId " + requester));
        }
        return requester;
    }

    public static String getSystemProperty(final String key, final String defaultValue) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key, defaultValue);
            }
        });
    }
}

