/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.plugin;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RestCallbackCaller {
    private static final Log log = LogFactory.getLog(RestCallbackCaller.class);
    private final String protocol;
    private final String host;
    private final String port;
    private final String pathContext;
    private final boolean isPostHttpMethod;

    public RestCallbackCaller(String protocol, String host, String port, String pathContext, String httpMethod) {
        if (host == null || port == null || pathContext == null) {
            throw new IllegalArgumentException("Host, port and context are mandatory, but some of them is not available in configuration. host=" + host + ", port=" + port + ", context=" + pathContext);
        }
        this.host = host;
        this.port = port;
        this.pathContext = pathContext;
        if (httpMethod == null || "GET".equalsIgnoreCase(httpMethod)) {
            this.isPostHttpMethod = false;
        } else if ("POST".equalsIgnoreCase(httpMethod)) {
            this.isPostHttpMethod = true;
        } else {
            throw new IllegalArgumentException("Illegal httpMethod: " + httpMethod + ". Only GET or POST are allowed");
        }
        if (protocol == null) {
            protocol = "http";
        }
        this.protocol = protocol;
        log.info((Object)("RestCallbackCaller initialized: " + this));
    }

    public boolean executeRemoteCall(String username, String password) throws Exception {
        HttpClient client = new HttpClient();
        HttpMethod method = null;
        try {
            method = this.createHttpMethodForSend(username, password);
            int status = client.executeMethod(method);
            String response = method.getResponseBodyAsString();
            switch (status) {
                case 200: {
                    if (!response.equals(Boolean.TRUE.toString())) break;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("User " + username + " authenticated successfuly via Rest callback!"));
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            log.debug((Object)("User " + username + " not authenticated successfuly. HTTP status: " + status + ", HTTP response: " + response));
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            log.warn((Object)("Can't authenticate because of error: " + e.getMessage()));
            e.printStackTrace();
            throw e;
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private HttpMethod createHttpMethodForSend(String username, String password) {
        if (this.isPostHttpMethod) {
            StringBuilder builder = new StringBuilder(this.protocol).append("://");
            builder.append(this.host).append(":").append(this.port);
            builder.append("/rest/sso/authcallback/postauth/");
            String requestURL = builder.toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Rest callback URL: " + requestURL));
            }
            PostMethod postMethod = new PostMethod(requestURL);
            NameValuePair usernamePair = new NameValuePair("username", username);
            NameValuePair passwordPair = new NameValuePair("password", password);
            NameValuePair[] params = new NameValuePair[]{usernamePair, passwordPair};
            postMethod.setRequestBody(params);
            return postMethod;
        }
        StringBuilder builder = new StringBuilder(this.protocol).append("://");
        builder.append(this.host).append(":").append(this.port).append("/").append(this.pathContext).append("/rest/sso/authcallback/auth/").append(username).append("/").append(password);
        String requestURL = builder.toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Rest callback URL: " + requestURL));
        }
        return new GetMethod(requestURL);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("RestCallbackCaller [ protocol=").append(this.protocol).append(", host=").append(this.host).append(", port=").append(this.port).append(", pathContext=").append(this.pathContext).append(", isPostMethod=").append(this.isPostHttpMethod).append(" ]");
        return builder.toString();
    }
}

