/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.integration;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.container.web.AbstractFilter;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.sso.agent.filter.api.SSOInterceptor;
import org.gatein.sso.integration.SSOFilterIntegrator;
import org.gatein.sso.integration.SSOUtils;

public class SSODelegateFilter
extends AbstractFilter {
    private Map<SSOInterceptor, String> ssoInterceptors;
    private static final Logger log = LoggerFactory.getLogger(SSODelegateFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (SSOUtils.isSSOEnabled()) {
            SSOFilterChain ssoChain = new SSOFilterChain(chain, this.getInterceptors(), this);
            ssoChain.doFilter(request, response);
        } else {
            chain.doFilter(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<SSOInterceptor, String> getInterceptors() {
        if (this.ssoInterceptors == null) {
            SSODelegateFilter sSODelegateFilter = this;
            synchronized (sSODelegateFilter) {
                if (this.ssoInterceptors == null) {
                    SSOFilterIntegrator ssoFilterIntegrator = (SSOFilterIntegrator)this.getContainer().getComponentInstanceOfType(SSOFilterIntegrator.class);
                    this.ssoInterceptors = ssoFilterIntegrator.getSSOInterceptors();
                    log.info((Object)("Initialized SSO integrator with interceptors: " + this.ssoInterceptors));
                }
            }
        }
        return this.ssoInterceptors;
    }

    public void destroy() {
    }

    protected boolean isMappedTo(String filterMapping, String contextPath) {
        if ("/*".equals(filterMapping)) {
            return true;
        }
        return contextPath.startsWith(filterMapping);
    }

    public static class SSOFilterChain
    implements FilterChain {
        private final FilterChain containerChain;
        private final Iterator<Map.Entry<SSOInterceptor, String>> iterator;
        private final SSODelegateFilter ssoDelegateFilter;

        public SSOFilterChain(FilterChain containerChain, Map<SSOInterceptor, String> interceptors, SSODelegateFilter ssoDelegateFilter) {
            this.containerChain = containerChain;
            this.iterator = interceptors.entrySet().iterator();
            this.ssoDelegateFilter = ssoDelegateFilter;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            while (this.iterator.hasNext()) {
                Map.Entry<SSOInterceptor, String> current = this.iterator.next();
                HttpServletRequest hRequest = (HttpServletRequest)request;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Trying mapping " + current.getValue() + " of SSO interceptor " + current.getKey() + ". Request URI is " + hRequest.getRequestURI()));
                }
                if (!this.ssoDelegateFilter.isMappedTo(current.getValue(), hRequest.getServletPath())) continue;
                SSOInterceptor interceptor = current.getKey();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Going to invoke SSO interceptor " + interceptor));
                }
                interceptor.doFilter(request, response, (FilterChain)this);
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("No more SSO interceptors. Going to invoke container filter chain " + this.containerChain));
            }
            this.containerChain.doFilter(request, response);
        }
    }
}

