/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.josso.plugin;

import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.josso.auth.BindableCredentialStore;
import org.josso.auth.Credential;
import org.josso.auth.CredentialKey;
import org.josso.auth.CredentialProvider;
import org.josso.auth.exceptions.SSOAuthenticationException;
import org.josso.auth.scheme.AuthenticationScheme;
import org.josso.gateway.identity.exceptions.NoSuchUserException;
import org.josso.gateway.identity.exceptions.SSOIdentityException;
import org.josso.gateway.identity.service.BaseRole;
import org.josso.gateway.identity.service.BaseUser;
import org.josso.gateway.identity.service.BaseUserImpl;
import org.josso.gateway.identity.service.store.IdentityStore;
import org.josso.gateway.identity.service.store.UserKey;

public class GateinIdentityPlugin
implements BindableCredentialStore,
IdentityStore {
    private static Logger log = Logger.getLogger(GateinIdentityPlugin.class);
    private AuthenticationScheme authenticationScheme = null;
    private String gateInHost;
    private String gateInPort;
    private String gateInContext;

    public GateinIdentityPlugin() {
        InputStream is = null;
        try {
            Properties properties = new Properties();
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream("gatein.properties");
            properties.load(is);
            this.gateInHost = properties.getProperty("host");
            this.gateInPort = properties.getProperty("port");
            this.gateInContext = properties.getProperty("context");
            log.info((Object)"-------------------------------------------------------------------");
            log.info((Object)("GateIn Host: " + this.gateInHost));
            log.info((Object)"GateIn Identity Plugin successfully started........................");
            log.info((Object)"-------------------------------------------------------------------");
        }
        catch (Exception e) {
            this.authenticationScheme = null;
            log.error((Object)this, (Throwable)e);
            throw new RuntimeException("GateIn Identity Plugin registration failed....");
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public void setAuthenticationScheme(AuthenticationScheme authenticationScheme) {
        this.authenticationScheme = authenticationScheme;
    }

    public String getGateInHost() {
        return this.gateInHost;
    }

    public void setGateInHost(String gateInHost) {
        this.gateInHost = gateInHost;
    }

    public String getGateInPort() {
        return this.gateInPort;
    }

    public void setGateInPort(String gateInPort) {
        this.gateInPort = gateInPort;
    }

    public String getGateInContext() {
        return this.gateInContext;
    }

    public void setGateInContext(String gateInContext) {
        this.gateInContext = gateInContext;
    }

    public boolean userExists(UserKey userKey) throws SSOIdentityException {
        return true;
    }

    public BaseRole[] findRolesByUserKey(UserKey userKey) throws SSOIdentityException {
        return null;
    }

    public BaseUser loadUser(UserKey userKey) throws NoSuchUserException, SSOIdentityException {
        BaseUserImpl user = new BaseUserImpl();
        user.setName(userKey.toString());
        return user;
    }

    public Credential[] loadCredentials(CredentialKey credentialKey, CredentialProvider credentialProvider) throws SSOIdentityException {
        return null;
    }

    public Credential[] loadCredentials(CredentialKey credentialKey) throws SSOIdentityException {
        return null;
    }

    public boolean bind(String username, String password) throws SSOAuthenticationException {
        try {
            log.debug((Object)"Performing Authentication........................");
            log.debug((Object)("Username: " + username));
            log.debug((Object)("Password: " + password));
            StringBuilder urlBuffer = new StringBuilder();
            urlBuffer.append("http://" + this.gateInHost + ":" + this.gateInPort + "/" + this.gateInContext + "/rest/sso/authcallback/auth/" + username + "/" + password);
            boolean success = this.executeRemoteCall(urlBuffer.toString());
            return success;
        }
        catch (Exception e) {
            throw new SSOAuthenticationException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeRemoteCall(String authUrl) throws Exception {
        HttpClient client = new HttpClient();
        GetMethod method = null;
        try {
            method = new GetMethod(authUrl);
            int status = client.executeMethod((HttpMethod)method);
            String response = method.getResponseBodyAsString();
            switch (status) {
                case 200: {
                    if (!response.equals(Boolean.TRUE.toString())) break;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }
}

