/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.opensso.plugin;

import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.gatein.sso.opensso.plugin.GateInPrincipal;

public class AuthenticationPlugin
extends AMLoginModule {
    private String gateInHost;
    private String gateInPort;
    private String gateInContext;
    private String username;
    private String password;

    public String getGateInHost() {
        return this.gateInHost;
    }

    public void setGateInHost(String gateInHost) {
        this.gateInHost = gateInHost;
    }

    public String getGateInPort() {
        return this.gateInPort;
    }

    public void setGateInPort(String gateInPort) {
        this.gateInPort = gateInPort;
    }

    public String getGateInContext() {
        return this.gateInContext;
    }

    public void setGateInContext(String gateInContext) {
        this.gateInContext = gateInContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Subject subject, Map sharedState, Map options) {
        InputStream is = null;
        try {
            Properties properties = new Properties();
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream("gatein.properties");
            properties.load(is);
            this.gateInHost = properties.getProperty("host");
            this.gateInPort = properties.getProperty("port");
            this.gateInContext = properties.getProperty("context");
        }
        catch (IOException ioe) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public int process(Callback[] callbacks, int state) throws AuthLoginException {
        try {
            for (int i = 0; i < callbacks.length; ++i) {
                Callback callback = callbacks[i];
                if (callback instanceof NameCallback) {
                    this.username = ((NameCallback)callback).getName();
                    continue;
                }
                if (!(callback instanceof PasswordCallback)) continue;
                this.password = new String(((PasswordCallback)callback).getPassword());
            }
            StringBuilder urlBuffer = new StringBuilder();
            urlBuffer.append("http://" + this.gateInHost + ":" + this.gateInPort + "/" + this.gateInContext + "/rest/sso/authcallback/auth/" + this.username + "/" + this.password);
            boolean success = this.executeRemoteCall(urlBuffer.toString());
            if (!success) {
                throw new AuthLoginException("GateIn Login Callback Failed!!");
            }
            return -1;
        }
        catch (Throwable e) {
            throw new AuthLoginException(e);
        }
    }

    public Principal getPrincipal() {
        return new GateInPrincipal(this.username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeRemoteCall(String authUrl) throws Exception {
        HttpClient client = new HttpClient();
        GetMethod method = null;
        try {
            method = new GetMethod(authUrl);
            int status = client.executeMethod((HttpMethod)method);
            String response = method.getResponseBodyAsString();
            switch (status) {
                case 200: {
                    if (!response.equals(Boolean.TRUE.toString())) break;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }
}

