/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.tomcat;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.Wrapper;
import org.gatein.wci.command.CommandServlet;
import org.gatein.wci.spi.WebAppContext;
import org.w3c.dom.Document;

public class TC7WebAppContext
implements WebAppContext {
    private static final String GATEIN_SERVLET_NAME = "TomcatGateInServlet";
    private static final String GATEIN_SERVLET_PATH = "/tomcatgateinservlet";
    private Document descriptor;
    private ServletContext servletContext;
    private ClassLoader loader;
    private String contextPath;
    private final Context context;
    private Wrapper commandServlet;

    TC7WebAppContext(Context context) throws Exception {
        this.context = context;
        this.servletContext = context.getServletContext();
        this.loader = context.getLoader().getClassLoader();
        this.contextPath = context.getPath();
    }

    public void start() throws Exception {
        try {
            this.commandServlet = this.context.createWrapper();
            this.commandServlet.setName(GATEIN_SERVLET_NAME);
            this.commandServlet.setLoadOnStartup(0);
            this.commandServlet.setServletClass(CommandServlet.class.getName());
            this.context.addChild((Container)this.commandServlet);
            this.context.addServletMapping(GATEIN_SERVLET_PATH, GATEIN_SERVLET_NAME);
        }
        catch (Exception e) {
            this.cleanup();
            throw e;
        }
    }

    public void stop() {
        this.cleanup();
    }

    private void cleanup() {
        if (this.commandServlet != null) {
            try {
                this.context.removeServletMapping(GATEIN_SERVLET_PATH);
                this.context.removeChild((Container)this.commandServlet);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public boolean importFile(String parentDirRelativePath, String name, InputStream source, boolean overwrite) throws IOException {
        return false;
    }

    public boolean invalidateSession(String sessId) {
        Manager mgr = this.context.getManager();
        if (mgr != null) {
            try {
                Session sess = mgr.findSession(sessId);
                if (sess != null) {
                    sess.expire();
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }
}

