/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.endpoint;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.gatein.common.io.IOTools;
import org.gatein.common.text.FastURLDecoder;
import org.gatein.common.xml.XMLTools;
import org.gatein.wci.WebRequest;
import org.gatein.wci.WebResponse;
import org.gatein.wci.endpoint.EndPointRequest;
import org.gatein.wci.endpoint.EndPointResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class EndPointServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(EndPointServlet.class);
    private FastURLDecoder decoder = FastURLDecoder.getUTF8Instance();
    public static final int DEFAULT_SERVLET_MAPPING = 0;
    public static final int ROOT_PATH_MAPPING = 1;
    public static final int PATH_MAPPING = 2;
    private Integer mappingType;

    public void init() throws ServletException {
        byte[] bytes;
        XPathExpression expr;
        String servletName = this.getServletConfig().getServletName();
        ServletContext servletContext = this.getServletContext();
        String exprValue = "//servlet-mapping[servlet-name='" + servletName + "']/url-pattern";
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            expr = xpath.compile(exprValue);
        }
        catch (XPathExpressionException e) {
            throw new ServletException((Throwable)e);
        }
        log.debug((Object)("Going to look for the configuration of the end point servlet " + servletName));
        InputStream in = servletContext.getResourceAsStream("/WEB-INF/web.xml");
        try {
            bytes = IOTools.getBytes((InputStream)in);
            String descriptor = new String(bytes);
            log.debug((Object)("The a priori descriptor is " + descriptor));
        }
        catch (IOException e) {
            throw new ServletException("The end point servlet " + servletName + " is not able to load the web descriptor");
        }
        finally {
            IOTools.safeClose((Closeable)in);
        }
        try {
            Document doc = XMLTools.getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream(bytes));
            NodeList nodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element urlPatternElt = (Element)nodes.item(i);
                String urlPattern = XMLTools.asString((Element)urlPatternElt, (boolean)true);
                log.debug((Object)("Found url pattern " + urlPattern + " for end point servlet " + servletName));
                if (this.mappingType != null) {
                    throw new ServletException("The same end point servlet " + servletName + " is mapped several times and this is not allowed");
                }
                if (urlPattern.equals("/")) {
                    this.mappingType = 0;
                    continue;
                }
                if (urlPattern.equals("/*")) {
                    this.mappingType = 1;
                    continue;
                }
                if (urlPattern.startsWith("/") && urlPattern.endsWith("/*")) {
                    this.mappingType = 2;
                    continue;
                }
                throw new ServletException("The end point servlet " + servletName + " is mapped with a pattern value " + urlPattern);
            }
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
        catch (SAXException e) {
            throw new ServletException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new ServletException((Throwable)e);
        }
        catch (XPathExpressionException e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            IOTools.safeClose((Closeable)in);
        }
        if (this.mappingType == null) {
            throw new ServletException("The same end point servlet " + servletName + " was not able to detect its mapping");
        }
    }

    protected final void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String requestURI = req.getRequestURI();
        String servletPath = req.getServletPath();
        String contextPath = req.getContextPath();
        String webRequestPath = null;
        String webContextPath = null;
        switch (this.mappingType) {
            case 0: {
                webRequestPath = requestURI.substring(contextPath.length());
                webContextPath = requestURI.substring(0, contextPath.length());
                break;
            }
            case 1: {
                webRequestPath = requestURI.substring(contextPath.length());
                webContextPath = requestURI.substring(0, contextPath.length());
                break;
            }
            case 2: {
                webRequestPath = requestURI.substring(contextPath.length() + servletPath.length());
                webContextPath = requestURI.substring(0, contextPath.length() + servletPath.length());
                if (webRequestPath.length() != 0) break;
                webRequestPath = "/";
            }
        }
        webRequestPath = this.decoder.encode(webRequestPath);
        webContextPath = this.decoder.encode(webContextPath);
        EndPointRequest wreq = new EndPointRequest(req, webRequestPath, webContextPath, this.mappingType);
        EndPointResponse wresp = new EndPointResponse(wreq, resp);
        this.service(wreq, wresp);
    }

    protected abstract void service(WebRequest var1, WebResponse var2) throws ServletException, IOException;

    public Integer getMappingType() {
        return this.mappingType;
    }
}

