/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.impl.generic;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.wci.RequestDispatchCallback;
import org.gatein.wci.command.CommandDispatcher;
import org.gatein.wci.impl.DefaultServletContainerFactory;
import org.gatein.wci.impl.generic.GenericWebAppContext;
import org.gatein.wci.spi.ServletContainerContext;

public class GenericServletContainerContext
implements ServletContainerContext,
ServletContextListener {
    private static final Map<String, GenericWebAppContext> pendingContexts = Collections.synchronizedMap(new HashMap());
    private static GenericServletContainerContext instance;
    private ServletContainerContext.Registration registration;
    private final CommandDispatcher dispatcher = new CommandDispatcher("/gateinservlet");

    public static GenericServletContainerContext getInstance() {
        return instance;
    }

    public static void register(GenericWebAppContext webAppContext) {
        if (instance != null && GenericServletContainerContext.instance.registration != null) {
            GenericServletContainerContext.instance.registration.registerWebApp(webAppContext);
        } else {
            pendingContexts.put(webAppContext.getContextPath(), webAppContext);
        }
    }

    public static void unregister(String contextPath) {
        if (instance != null && GenericServletContainerContext.instance.registration != null) {
            GenericServletContainerContext.instance.registration.unregisterWebApp(contextPath);
        }
        if (pendingContexts.containsKey(contextPath)) {
            pendingContexts.remove(contextPath);
        }
    }

    public Object include(ServletContext targetServletContext, HttpServletRequest request, HttpServletResponse response, RequestDispatchCallback callback, Object handback) throws ServletException, IOException {
        return this.dispatcher.include(targetServletContext, request, response, callback, handback);
    }

    public void setCallback(ServletContainerContext.Registration registration) {
        this.registration = registration;
        for (GenericWebAppContext pendingContext : pendingContexts.values()) {
            registration.registerWebApp(pendingContext);
        }
    }

    public void unsetCallback(ServletContainerContext.Registration registration) {
        this.registration = null;
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        if (instance != null) {
            throw new IllegalStateException("Shared instance singleton already created");
        }
        instance = this;
        DefaultServletContainerFactory.registerContext(this);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }
}

