/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.impl.tomcat;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.gatein.wci.command.CommandServlet;
import org.gatein.wci.spi.WebAppContext;
import org.w3c.dom.Document;

public class TC6WebAppContext
implements WebAppContext {
    private Document descriptor;
    private ServletContext servletContext;
    private ClassLoader loader;
    private String contextPath;
    private final Context context;
    private Wrapper commandServlet;

    TC6WebAppContext(Context context) throws Exception {
        this.context = context;
        this.servletContext = context.getServletContext();
        this.loader = context.getLoader().getClassLoader();
        this.contextPath = context.getPath();
    }

    public void start() throws Exception {
        try {
            this.commandServlet = this.context.createWrapper();
            this.commandServlet.setName("TomcatGateInServlet");
            this.commandServlet.setLoadOnStartup(0);
            this.commandServlet.setServletClass(CommandServlet.class.getName());
            this.context.addChild((Container)this.commandServlet);
            this.context.addServletMapping("/tomcatgateinservlet", "TomcatGateInServlet");
        }
        catch (Exception e) {
            this.cleanup();
            throw e;
        }
    }

    public void stop() {
        this.cleanup();
    }

    private void cleanup() {
        if (this.commandServlet != null) {
            try {
                this.context.removeServletMapping("tomcatgateinservlet");
                this.context.removeChild((Container)this.commandServlet);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public boolean importFile(String parentDirRelativePath, String name, InputStream source, boolean overwrite) throws IOException {
        return false;
    }
}

