/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.common.NotYetImplemented;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.wci.RequestDispatchCallback;
import org.gatein.wci.ServletContainer;
import org.gatein.wci.WebApp;
import org.gatein.wci.WebAppEvent;
import org.gatein.wci.WebAppLifeCycleEvent;
import org.gatein.wci.WebAppListener;
import org.gatein.wci.WebExecutor;
import org.gatein.wci.spi.ServletContainerContext;
import org.gatein.wci.spi.WebAppContext;

public class DefaultServletContainer
implements ServletContainer {
    private static final Logger log = LoggerFactory.getLogger(ServletContainer.class);
    private final Object lock = new Object();
    private final ArrayList<WebAppListener> listeners = new ArrayList();
    private final Map<String, WebAppImpl> webAppMap = new HashMap<String, WebAppImpl>();
    private RegistrationImpl registration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ServletContainerContext context) {
        Object object = this.lock;
        synchronized (object) {
            if (context == null) {
                throw new IllegalArgumentException("No null context accepted");
            }
            if (this.registration == null) {
                this.registration = new RegistrationImpl(this, context);
                context.setCallback(this.registration);
            }
        }
    }

    public WebExecutor getExecutor(HttpServletRequest request, HttpServletResponse response) {
        throw new NotYetImplemented();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addWebAppListener(WebAppListener listener) {
        Object object = this.lock;
        synchronized (object) {
            if (listener == null) {
                throw new IllegalArgumentException();
            }
            if (this.listeners.contains(listener)) {
                return false;
            }
            this.listeners.add(listener);
            for (WebAppImpl response : this.webAppMap.values()) {
                WebApp webApp = response;
                WebAppLifeCycleEvent event = new WebAppLifeCycleEvent(webApp, 1);
                this.safeFireEvent(listener, event);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeWebAppListener(WebAppListener listener) {
        Object object = this.lock;
        synchronized (object) {
            if (listener == null) {
                throw new IllegalArgumentException();
            }
            if (this.listeners.remove(listener)) {
                for (WebAppImpl webApp : this.webAppMap.values()) {
                    WebAppLifeCycleEvent event = new WebAppLifeCycleEvent(webApp, 0);
                    this.safeFireEvent(listener, event);
                }
                return true;
            }
            return false;
        }
    }

    private void safeFireEvent(WebAppListener listener, WebAppEvent event) {
        try {
            listener.onEvent(event);
        }
        catch (Throwable t) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            t.printStackTrace();
        }
    }

    private void fireEvent(WebAppEvent event) {
        for (WebAppListener listener : this.listeners) {
            this.safeFireEvent(listener, event);
        }
    }

    public Object include(ServletContext targetServletContext, HttpServletRequest request, HttpServletResponse response, RequestDispatchCallback callback, Object handback) throws ServletException, IOException {
        RegistrationImpl registration = this.registration;
        if (registration == null) {
            throw new IllegalStateException("No SPI installed");
        }
        return registration.context.include(targetServletContext, request, response, callback, handback);
    }

    private static class WebAppImpl
    implements WebApp {
        final WebAppContext context;

        public WebAppImpl(WebAppContext context) {
            this.context = context;
        }

        public ServletContext getServletContext() {
            return this.context.getServletContext();
        }

        public ClassLoader getClassLoader() {
            return this.context.getClassLoader();
        }

        public String getContextPath() {
            return this.context.getContextPath();
        }

        public boolean importFile(String parentDirRelativePath, String name, InputStream source, boolean overwrite) throws IOException {
            return this.context.importFile(parentDirRelativePath, name, source, overwrite);
        }
    }

    private static class RegistrationImpl
    implements ServletContainerContext.Registration {
        private boolean disposed = false;
        private DefaultServletContainer container;
        private ServletContainerContext context;

        public RegistrationImpl(DefaultServletContainer container, ServletContainerContext context) {
            this.container = container;
            this.context = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean registerWebApp(WebAppContext webAppContext) {
            if (this.disposed) {
                throw new IllegalStateException("Disposed registration");
            }
            Object object = this.container.lock;
            synchronized (object) {
                if (webAppContext == null) {
                    throw new IllegalArgumentException("No null web app context accepted");
                }
                String key = webAppContext.getContextPath();
                if (this.container.webAppMap.containsKey(key)) {
                    log.debug((Object)("Web application " + key + " is already registered"));
                    return false;
                }
                try {
                    log.debug((Object)("Web application " + key + " registration"));
                    webAppContext.start();
                    WebAppImpl webApp = new WebAppImpl(webAppContext);
                    this.container.webAppMap.put(key, webApp);
                    this.container.fireEvent(new WebAppLifeCycleEvent(webApp, 1));
                    return true;
                }
                catch (Exception e) {
                    log.debug((Object)("Was not able to start web app context " + key));
                    e.printStackTrace();
                    return false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean unregisterWebApp(String webAppId) {
            if (this.disposed) {
                throw new IllegalStateException("Disposed registration");
            }
            Object object = this.container.lock;
            synchronized (object) {
                if (webAppId == null) {
                    throw new IllegalArgumentException("No null web app id accepted");
                }
                WebAppImpl webApp = (WebAppImpl)this.container.webAppMap.remove(webAppId);
                if (webApp != null) {
                    log.debug((Object)("Web application " + webAppId + " cleanup"));
                    this.container.fireEvent(new WebAppLifeCycleEvent(webApp, 0));
                    webApp.context.stop();
                    return true;
                }
                log.debug((Object)("Web application " + webAppId + " was not registered"));
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            if (this.disposed) {
                throw new IllegalStateException("Disposed registration");
            }
            Object object = this.container.lock;
            synchronized (object) {
                for (WebAppImpl webApp : this.container.webAppMap.values()) {
                    WebAppLifeCycleEvent event = new WebAppLifeCycleEvent(webApp, 0);
                    this.container.fireEvent(event);
                }
                this.container.webAppMap.clear();
                try {
                    this.context.unsetCallback(this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.context = null;
                this.disposed = true;
                this.container.registration = null;
            }
        }
    }
}

