/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.authentication;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.wci.authentication.AuthenticationResult;
import org.gatein.wci.authentication.GenericAuthenticationResult;
import org.gatein.wci.authentication.TicketService;
import org.gatein.wci.security.Credentials;

public class GenericAuthentication {
    public static final TicketService TICKET_SERVICE = new TicketService();
    private static final GenericAuthentication GENERIC_AUTHENTICATION = new GenericAuthentication();

    private GenericAuthentication() {
    }

    public AuthenticationResult login(String login, String password, HttpServletRequest request, HttpServletResponse response, long validityMillis) {
        String ticket = TICKET_SERVICE.createTicket(new Credentials(login, password), validityMillis);
        return new GenericAuthenticationResult(login, ticket);
    }

    public void logout(HttpServletRequest request, HttpServletResponse response) {
        request.getSession().invalidate();
    }

    public static GenericAuthentication getInstance() {
        return GENERIC_AUTHENTICATION;
    }
}

