/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.authentication;

import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.gatein.wci.authentication.AuthenticationException;
import org.gatein.wci.authentication.Ticket;
import org.gatein.wci.security.Credentials;

public class TicketService {
    public static final long DEFAULT_VALIDITY = 60000L;
    protected final ConcurrentHashMap<String, Ticket> tickets = new ConcurrentHashMap();
    protected final Random random = new Random();

    public String createTicket(Credentials credentials, long validityMillis) {
        if (validityMillis < 0L) {
            throw new IllegalArgumentException("validityMillis must be positive");
        }
        if (credentials == null) {
            throw new NullPointerException();
        }
        String tokenId = this.nextTicketId();
        long expirationTimeMillis = System.currentTimeMillis() + validityMillis;
        this.tickets.put(tokenId, new Ticket(expirationTimeMillis, credentials));
        return tokenId;
    }

    public Credentials validateTicket(String stringKey, boolean remove) {
        if (stringKey == null) {
            throw new IllegalArgumentException("stringKey is null");
        }
        Ticket ticket = remove ? this.tickets.remove(stringKey) : this.tickets.get(stringKey);
        if (ticket != null) {
            boolean valid;
            boolean bl = valid = ticket.getExpirationTimeMillis() > System.currentTimeMillis();
            if (valid) {
                return ticket.getPayload();
            }
            if (!remove) {
                this.tickets.remove(stringKey);
            }
            if (!valid) {
                throw new AuthenticationException("Ticket " + stringKey + " has expired");
            }
        }
        return null;
    }

    private String nextTicketId() {
        return "wci-ticket-" + this.random.nextInt();
    }
}

