/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.security;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.gatein.wci.authentication.GenericAuthentication;
import org.gatein.wci.security.Credentials;

public class WCILoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
    }

    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("Username"), new PasswordCallback("Password", false)};
        try {
            this.callbackHandler.handle(callbacks);
            String password = new String(((PasswordCallback)callbacks[1]).getPassword());
            Credentials credentials = GenericAuthentication.TICKET_SERVICE.validateTicket(password, true);
            this.sharedState.put("javax.security.auth.login.name", credentials.getUsername());
            this.sharedState.put("javax.security.auth.login.password", credentials.getPassword());
        }
        catch (Exception e) {
            LoginException le = new LoginException();
            le.initCause(e);
            throw le;
        }
        return true;
    }

    public boolean commit() throws LoginException {
        return true;
    }

    public boolean abort() throws LoginException {
        return true;
    }

    public boolean logout() throws LoginException {
        return true;
    }
}

