/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.gatein.wci.spi.ServletContainerContext;
import org.gatein.wci.spi.WebAppContext;

public class GateInServletRegistrations {
    private static final Map<String, WebAppContext> pendingContexts = Collections.synchronizedMap(new LinkedHashMap(16, 0.5f, false));
    private static HashMap<ServletContext, String> requestDispatchMap = new HashMap();
    private static ServletContainerContext servletContainerContext;

    public static void register(WebAppContext webAppContext, String dispatcherPath) {
        requestDispatchMap.put(webAppContext.getServletContext(), dispatcherPath);
        if (servletContainerContext != null) {
            servletContainerContext.registerWebApp(webAppContext, dispatcherPath);
        } else {
            pendingContexts.put(webAppContext.getContextPath(), webAppContext);
        }
    }

    public static void unregister(ServletContext servletContext) {
        requestDispatchMap.remove(servletContext);
        String contextPath = servletContext.getContextPath();
        if (servletContainerContext != null) {
            servletContainerContext.unregisterWebApp(servletContext);
        }
        if (pendingContexts.containsKey(contextPath)) {
            pendingContexts.remove(contextPath);
        }
    }

    public static void setServletContainerContext(ServletContainerContext context) {
        servletContainerContext = context;
        for (String contextPath : pendingContexts.keySet()) {
            WebAppContext webAppContext = pendingContexts.get(contextPath);
            String dispatcherPath = requestDispatchMap.get(webAppContext.getServletContext());
            servletContainerContext.registerWebApp(webAppContext, dispatcherPath);
        }
    }
}

