/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.authentication;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.wci.authentication.AuthenticationEventType;
import org.gatein.wci.spi.ServletContainerContext;

public class AuthenticationEvent {
    private final AuthenticationEventType type;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final String userName;
    private final ServletContainerContext containerContext;

    public AuthenticationEvent(AuthenticationEventType type, HttpServletRequest request, HttpServletResponse response, String userName, ServletContainerContext containerContext) {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (request == null) {
            throw new IllegalArgumentException("request is null");
        }
        if (response == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (containerContext == null) {
            throw new IllegalArgumentException("container is null");
        }
        this.type = type;
        this.request = request;
        this.response = response;
        this.userName = userName;
        this.containerContext = containerContext;
    }

    public AuthenticationEventType getType() {
        return this.type;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public String getUserName() {
        return this.userName;
    }

    public ServletContainerContext getContainerContext() {
        return this.containerContext;
    }

    public String toString() {
        return "AuthenticationEvent[type=" + this.type.name() + ",userName=" + this.userName + ",uri=" + this.request.getRequestURI() + "]";
    }
}

