/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.test.support;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.gatein.wsrp.test.support.MockHttpSession;

public class MockHttpServletRequest
implements InvocationHandler,
Serializable {
    private HttpSession session;
    private Map attrs;
    public static String scheme = "http";
    public static String serverName = "localhost";
    public static Integer serverPort = 8080;
    public static String hostURL = scheme + "://" + serverName + ":" + serverPort;

    private MockHttpServletRequest(HttpSession session) {
        this.session = session;
        this.attrs = new HashMap();
    }

    public static HttpServletRequest createMockRequest(HttpSession session) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (session == null) {
            session = MockHttpSession.createMockSession();
        }
        return (HttpServletRequest)Proxy.newProxyInstance(loader, new Class[]{HttpServletRequest.class}, (InvocationHandler)new MockHttpServletRequest(session));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("getSession".equals(methodName)) {
            return this.session;
        }
        if ("getHeader".equals(methodName)) {
            if ("User-Agent".equals(args[0])) {
                return "Mock Client User Agent";
            }
            return null;
        }
        if ("toString".equals(methodName)) {
            return "MockHttpServletRequest";
        }
        if ("getAttribute".equals(methodName)) {
            return this.attrs.get(args[0]);
        }
        if ("setAttribute".equals(methodName)) {
            String name = (String)args[0];
            Object value = args[1];
            if (value != null) {
                this.attrs.put(name, value);
            } else {
                this.attrs.remove(value);
            }
            return null;
        }
        if ("removeAttribute".equals(methodName)) {
            String name = (String)args[0];
            this.attrs.remove(name);
            return null;
        }
        if ("getScheme".equals(methodName)) {
            return scheme;
        }
        if ("getServerName".equals(methodName)) {
            return serverName;
        }
        if ("getServerPort".equals(methodName)) {
            return serverPort;
        }
        if ("getHeaderNames".equals(methodName)) {
            return new Enumeration<String>(){

                @Override
                public boolean hasMoreElements() {
                    return false;
                }

                @Override
                public String nextElement() {
                    return null;
                }
            };
        }
        if ("getCookies".equals(methodName)) {
            return new Cookie[0];
        }
        if ("getMethod".equals(methodName)) {
            return "GET";
        }
        if ("getContextPath".equals(methodName)) {
            return "/";
        }
        if ("getPathInfo".equals(methodName)) {
            return "/";
        }
        if ("getQueryString".equals(methodName)) {
            return "";
        }
        if ("getQueryURI".equals(methodName)) {
            return "";
        }
        if ("getRequestURI".equals(methodName)) {
            return "";
        }
        if ("getServletPath".equals(methodName)) {
            return "/";
        }
        if ("getAuthType".equals(methodName)) {
            return null;
        }
        if ("isSecure".equals(methodName)) {
            return false;
        }
        if ("getUserPrincipal".equals(methodName)) {
            return null;
        }
        if ("getRemoteUser".equals(methodName)) {
            return null;
        }
        throw new UnsupportedOperationException("MockHttpServletRequest does not support: " + method);
    }
}

