/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.admin.ui;

import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.wsrp.WSRPConsumer;
import org.gatein.wsrp.admin.ui.ManagedBean;
import org.gatein.wsrp.consumer.RefreshResult;
import org.gatein.wsrp.consumer.RegistrationInfo;
import org.gatein.wsrp.consumer.registry.ConsumerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerManagerBean
extends ManagedBean {
    private ConsumerRegistry registry;
    private String selectedId;
    private static final String NO_CONSUMER = "bean_consumermanager_no_consumer";
    private static final String INVALID_NEW_CONSUMER_NAME = "bean_consumermanager_invalid_new_consumer_name";
    private static final String REFRESH_BYPASSED = "bean_consumermanager_refresh_bypassed";
    private static final String REFRESH_SUCCESS = "bean_consumermanager_refresh_success";
    private static final String REFRESH_FAILURE = "bean_consumermanager_refresh_failure";
    private static final String REFRESH_EXCEPTION = "bean_consumermanager_refresh_exception";
    static final String CONFIGURE_CONSUMER = "configureConsumer";
    static final String CONSUMERS = "consumers";
    static final String EXPECTED_REG_INFO_KEY = "expectedRegistrationInfo";
    static final String REFRESH_MODIFY = "bean_consumermanager_refresh_modify";
    static final String REQUESTED_CONSUMER_ID = "id";
    static final String SESSION_CONSUMER_ID = "consumerId";
    private static final String MESSAGE_TARGET = "createConsumer:consumerName";

    public ConsumerRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(ConsumerRegistry registry) {
        this.registry = registry;
    }

    public void setSelectedId(String consumerId) {
        this.selectedId = consumerId;
    }

    public String getSelectedId() {
        return this.selectedId;
    }

    public WSRPConsumer getSelectedConsumer() {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)this.selectedId, (String)"consumer id", null);
        return this.registry.getConsumer(this.selectedId);
    }

    public boolean isConsumersEmpty() {
        return this.registry.getConfiguredConsumers().isEmpty();
    }

    public List<WSRPConsumer> getConsumers() {
        return this.registry.getConfiguredConsumers();
    }

    public String reload() {
        this.registry.reloadConsumers();
        return CONSUMERS;
    }

    public String activateConsumer() {
        if (this.refreshConsumerId() != null) {
            boolean activate = Boolean.valueOf(this.beanContext.getParameter("activate"));
            try {
                if (activate) {
                    WSRPConsumer consumer = this.getSelectedConsumer();
                    if (consumer.isRefreshNeeded()) {
                        RefreshResult result = this.internalRefresh(consumer);
                        if (result != null && !result.hasIssues()) {
                            this.registry.activateConsumerWith(this.selectedId);
                        }
                    } else {
                        this.registry.activateConsumerWith(this.selectedId);
                    }
                } else {
                    this.registry.deactivateConsumerWith(this.selectedId);
                }
            }
            catch (Exception e) {
                this.beanContext.createErrorMessageFrom(e);
            }
            return this.listConsumers();
        }
        this.noSelectedConsumerError();
        return this.listConsumers();
    }

    public String registerConsumer() {
        if (this.refreshConsumerId() != null) {
            boolean register = Boolean.valueOf(this.beanContext.getParameter("register"));
            try {
                this.registry.registerOrDeregisterConsumerWith(this.selectedId, register);
                this.setConsumerIdInSession(false);
                return CONFIGURE_CONSUMER;
            }
            catch (Exception e) {
                this.beanContext.createErrorMessageFrom(e);
                return null;
            }
        }
        this.noSelectedConsumerError();
        return null;
    }

    public String createConsumer() {
        this.selectedId = this.checkNameValidity(this.selectedId, MESSAGE_TARGET);
        if (this.selectedId != null) {
            try {
                this.registry.createConsumer(this.selectedId, null, null);
                this.setConsumerIdInSession(false);
                return CONFIGURE_CONSUMER;
            }
            catch (Exception e) {
                this.beanContext.createErrorMessageFrom(MESSAGE_TARGET, e);
                return null;
            }
        }
        return null;
    }

    public String destroyConsumer() {
        if (this.refreshConsumerId() != null) {
            try {
                this.registry.destroyConsumer(this.selectedId);
                return this.listConsumers();
            }
            catch (Exception e) {
                this.beanContext.createErrorMessageFrom(e);
                return null;
            }
        }
        this.noSelectedConsumerError();
        return null;
    }

    public String configureConsumer() {
        if (this.refreshConsumerId() != null) {
            this.setConsumerIdInSession(false);
            return CONFIGURE_CONSUMER;
        }
        this.noSelectedConsumerError();
        return null;
    }

    public String refreshConsumer() {
        if (this.refreshConsumerId() != null) {
            this.internalRefresh(this.getSelectedConsumer());
            return this.configureConsumer();
        }
        this.noSelectedConsumerError();
        return null;
    }

    private RefreshResult internalRefresh(WSRPConsumer consumer) {
        try {
            RefreshResult result = consumer.refresh(true);
            String statusMessage = this.getLocalizationKeyFrom(result);
            if (result.hasIssues()) {
                RegistrationInfo expected = new RegistrationInfo(consumer.getProducerInfo().getRegistrationInfo());
                expected.refresh(result.getServiceDescription(), consumer.getProducerId(), true, true, true);
                this.setExpectedRegistrationInfo(expected);
                this.beanContext.createErrorMessage(statusMessage, new Object[0]);
                this.registry.deactivateConsumerWith(consumer.getProducerId());
            } else {
                if (consumer.isActive()) {
                    this.registry.activateConsumerWith(consumer.getProducerId());
                } else {
                    this.registry.deactivateConsumerWith(consumer.getProducerId());
                }
                this.beanContext.createInfoMessage(statusMessage);
            }
            return result;
        }
        catch (PortletInvokerException e) {
            this.beanContext.createErrorMessageFrom((Exception)((Object)e));
            return null;
        }
    }

    private String getLocalizationKeyFrom(RefreshResult result) {
        RefreshResult.Status status = result.getStatus();
        if (RefreshResult.Status.BYPASSED.equals((Object)status)) {
            return REFRESH_BYPASSED;
        }
        if (RefreshResult.Status.SUCCESS.equals((Object)status)) {
            return REFRESH_SUCCESS;
        }
        if (RefreshResult.Status.FAILURE.equals((Object)status)) {
            return REFRESH_FAILURE;
        }
        if (RefreshResult.Status.MODIFY_REGISTRATION_REQUIRED.equals((Object)status)) {
            return REFRESH_MODIFY;
        }
        return REFRESH_EXCEPTION;
    }

    RefreshResult refresh(WSRPConsumer consumer) {
        RefreshResult result = this.internalRefresh(consumer);
        this.selectedId = consumer.getProducerId();
        this.setConsumerIdInSession(false);
        return result;
    }

    private void setExpectedRegistrationInfo(RegistrationInfo expected) {
        Map sessionMap = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        sessionMap.put(EXPECTED_REG_INFO_KEY, expected);
    }

    public String listConsumers() {
        this.setConsumerIdInSession(true);
        this.selectedId = null;
        return CONSUMERS;
    }

    public void selectConsumer(ActionEvent actionEvent) {
        this.refreshConsumerId();
        this.setConsumerIdInSession(false);
    }

    private String refreshConsumerId() {
        this.selectedId = this.beanContext.getParameter(REQUESTED_CONSUMER_ID);
        return this.selectedId;
    }

    private void setConsumerIdInSession(boolean remove) {
        Map sessionMap = this.beanContext.getSessionMap();
        String consumerBeanName = "consumer";
        sessionMap.remove(consumerBeanName);
        if (!remove) {
            sessionMap.put(SESSION_CONSUMER_ID, this.selectedId);
        } else {
            sessionMap.remove(SESSION_CONSUMER_ID);
        }
    }

    private void noSelectedConsumerError() {
        this.beanContext.createErrorMessage(NO_CONSUMER, new Object[0]);
    }

    protected String getObjectTypeName() {
        return "CONSUMER_TYPE";
    }

    public boolean isAlreadyExisting(String objectName) {
        return this.registry.getConsumer(objectName) != null;
    }
}

