/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.admin.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.gatein.wsrp.WSRPConsumer;
import org.gatein.wsrp.admin.ui.ConsumerManagerBean;
import org.gatein.wsrp.admin.ui.ManagedBean;
import org.gatein.wsrp.consumer.EndpointConfigurationInfo;
import org.gatein.wsrp.consumer.ProducerInfo;
import org.gatein.wsrp.consumer.RegistrationInfo;
import org.gatein.wsrp.consumer.RegistrationProperty;
import org.gatein.wsrp.consumer.registry.ConsumerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerBean
extends ManagedBean {
    private WSRPConsumer consumer;
    private ConsumerRegistry registry;
    private ConsumerManagerBean manager;
    private boolean modified;
    private String wsdl;
    private static final String CANNOT_FIND_CONSUMER = "bean_consumer_cannot_find_consumer";
    private static final String CANNOT_UPDATE_CONSUMER = "bean_consumer_cannot_update_consumer";
    private static final String CANNOT_REFRESH_CONSUMER = "bean_consumer_cannot_refresh_consumer";
    private static final String MODIFY_REG_SUCCESS = "bean_consumer_modify_reg_success";
    private static final String INVALID_MODIFY = "bean_consumer_invalid_modify";
    private static final String CANNOT_MODIFY_REG = "bean_consumer_cannot_modify_reg";
    private static final String CANNOT_ERASE_REG = "bean_consumer_cannot_erase_reg";
    private static final String MALFORMED_URL = "bean_consumer_malformed_url";
    private static final String UPDATE_SUCCESS = "bean_consumer_update_success";
    private static final String CONSUMER_TYPE = "CONSUMER_TYPE";

    public void setRegistry(ConsumerRegistry registry) {
        this.registry = registry;
    }

    public void setManager(ConsumerManagerBean manager) {
        this.manager = manager;
    }

    public boolean isModified() {
        return this.modified || this.getProducerInfo().isModifyRegistrationRequired() || this.isRegistrationLocallyModified();
    }

    public boolean isRefreshNeeded() {
        return this.consumer.isRefreshNeeded();
    }

    public String getId() {
        return this.consumer.getProducerId();
    }

    public void setId(String id) {
        if (this.consumer != null) {
            ProducerInfo info = this.getProducerInfo();
            String oldId = info.getId();
            if (this.isOldAndNewDifferent((Object)oldId, (Object)id) && (id = this.checkNameValidity(id, "edit-cons-form:id")) != null) {
                info.setId(id);
                this.getRegistry().updateProducerInfo(info);
                this.modified = true;
            }
        } else {
            this.consumer = this.getRegistry().getConsumer(id);
            if (this.consumer != null) {
                EndpointConfigurationInfo endpoint = this.getProducerInfo().getEndpointConfigurationInfo();
                this.wsdl = endpoint.getWsdlDefinitionURL();
            } else {
                this.beanContext.createErrorMessage(CANNOT_FIND_CONSUMER, new Object[]{id});
            }
        }
    }

    public Integer getCache() {
        return this.getProducerInfo().getExpirationCacheSeconds();
    }

    public void setCache(Integer cache) {
        this.getProducerInfo().setExpirationCacheSeconds((Integer)this.modifyIfNeeded((Object)this.getCache(), (Object)cache, "cache", false));
    }

    public Integer getTimeout() {
        return this.getProducerInfo().getEndpointConfigurationInfo().getWSOperationTimeOut();
    }

    public void setTimeout(Integer timeout) {
        this.getProducerInfo().getEndpointConfigurationInfo().setWSOperationTimeOut(((Integer)this.modifyIfNeeded((Object)this.getTimeout(), (Object)timeout, "timeout", false)).intValue());
    }

    public String getWsdl() {
        return this.wsdl;
    }

    public void setWsdl(String wsdlURL) {
        this.wsdl = (String)this.modifyIfNeeded((Object)this.wsdl, (Object)wsdlURL, "wsdl", true);
    }

    private void internalSetWsdl(String wsdlURL) {
        try {
            this.getProducerInfo().getEndpointConfigurationInfo().setWsdlDefinitionURL(wsdlURL);
        }
        catch (Exception e) {
            this.getRegistry().deactivateConsumerWith(this.getId());
            this.beanContext.createErrorMessageFrom("wsdl", e);
        }
    }

    public boolean isActive() {
        return this.consumer.isActive();
    }

    public boolean isRegistered() {
        return this.getProducerInfo().isRegistered();
    }

    public boolean isRegistrationRequired() {
        return this.getProducerInfo().isRegistrationRequired();
    }

    public boolean isRegistrationCheckNeeded() {
        ProducerInfo info = this.getProducerInfo();
        if (info.isRefreshNeeded(true)) {
            RegistrationInfo regInfo = info.getRegistrationInfo();
            if (regInfo == null) {
                return true;
            }
            Boolean consistent = regInfo.isConsistentWithProducerExpectations();
            return consistent == null || consistent == false;
        }
        return false;
    }

    public boolean isDisplayExpectedNeeded() {
        ProducerInfo producerInfo = this.getProducerInfo();
        return producerInfo.isModifyRegistrationRequired() && producerInfo.getRegistrationInfo() != producerInfo.getExpectedRegistrationInfo();
    }

    public boolean isRegistrationLocallyModified() {
        return this.isRegistered() && this.getProducerInfo().getRegistrationInfo().isModifiedSinceLastRefresh();
    }

    public boolean isRegistrationChecked() {
        return this.getProducerInfo().isRegistrationChecked();
    }

    public boolean isRegistrationValid() {
        if (this.isRegistrationChecked()) {
            return this.getProducerInfo().getRegistrationInfo().isRegistrationValid();
        }
        throw new IllegalStateException("Need to check the registration before determining if it's valid!");
    }

    public ProducerInfo getProducerInfo() {
        return this.consumer.getProducerInfo();
    }

    public boolean isLocalInfoPresent() {
        return this.getProducerInfo().hasLocalRegistrationInfo();
    }

    public boolean isRegistrationPropertiesExisting() {
        RegistrationInfo regInfo = this.getProducerInfo().getRegistrationInfo();
        return regInfo == null || regInfo.isRegistrationPropertiesExisting();
    }

    public boolean isExpectedRegistrationPropertiesExisting() {
        RegistrationInfo info = this.getExpectedRegistrationInfo();
        return info != null && info.isRegistrationPropertiesExisting();
    }

    private RegistrationInfo getExpectedRegistrationInfo() {
        return this.getProducerInfo().getExpectedRegistrationInfo();
    }

    public List<RegistrationProperty> getRegistrationProperties() {
        return this.getSortedProperties(this.getProducerInfo().getRegistrationInfo());
    }

    public List<RegistrationProperty> getExpectedRegistrationProperties() {
        return this.getSortedProperties(this.getExpectedRegistrationInfo());
    }

    private List<RegistrationProperty> getSortedProperties(RegistrationInfo registrationInfo) {
        if (registrationInfo != null) {
            LinkedList<RegistrationProperty> list = new LinkedList<RegistrationProperty>(registrationInfo.getRegistrationProperties().values());
            Collections.sort(list);
            return list;
        }
        return Collections.emptyList();
    }

    public String update() {
        return this.internalUpdate(true);
    }

    public String confirmEraseRegistration() {
        return "confirmEraseRegistration";
    }

    private String internalUpdate(boolean showMessage) {
        if (this.consumer != null) {
            if (this.isModified()) {
                try {
                    ProducerInfo prodInfo = this.getProducerInfo();
                    EndpointConfigurationInfo endpointInfo = prodInfo.getEndpointConfigurationInfo();
                    this.internalSetWsdl(this.wsdl);
                    this.saveToRegistry(prodInfo);
                }
                catch (Exception e) {
                    this.beanContext.createErrorMessageFrom(e);
                    return null;
                }
            }
            if (showMessage) {
                this.beanContext.createInfoMessage(UPDATE_SUCCESS);
            }
            return "configureConsumer";
        }
        this.beanContext.createErrorMessage(CANNOT_UPDATE_CONSUMER, new Object[0]);
        return null;
    }

    private void saveToRegistry(ProducerInfo prodInfo) {
        this.getRegistry().updateProducerInfo(prodInfo);
        this.modified = false;
    }

    public String refreshConsumer() {
        if (this.consumer != null) {
            String updateResult;
            if (this.isModified() && (updateResult = this.internalUpdate(false)) == null) {
                return null;
            }
            if (!this.isRegistrationLocallyModified()) {
                this.manager.refresh(this.consumer);
            } else {
                this.beanContext.createInfoMessage("bean_consumermanager_refresh_modify");
            }
            return "configureConsumer";
        }
        this.beanContext.createErrorMessage(CANNOT_REFRESH_CONSUMER, new Object[0]);
        return null;
    }

    public String modifyRegistration() {
        if (this.consumer != null) {
            ProducerInfo info = this.getProducerInfo();
            if (this.isModified()) {
                RegistrationInfo newReg = this.getExpectedRegistrationInfo();
                this.saveToRegistry(info);
                RegistrationInfo oldReg = this.getProducerInfo().getRegistrationInfo();
                if (newReg == null) {
                    newReg = new RegistrationInfo(oldReg);
                    if (!this.isRegistrationLocallyModified()) {
                        IllegalStateException e = new IllegalStateException("Registration not locally modified: there should be expected registration from producer!");
                        this.log.debug("Couldn't modify registration", (Throwable)e);
                        throw e;
                    }
                }
                try {
                    newReg.setModifiedSinceLastRefresh(true);
                    info.setRegistrationInfo(newReg);
                    info.modifyRegistration();
                    newReg.setModifiedSinceLastRefresh(false);
                    this.beanContext.createInfoMessage(MODIFY_REG_SUCCESS);
                }
                catch (Exception e) {
                    info.setRegistrationInfo(oldReg);
                    this.beanContext.createErrorMessageFrom(e);
                    return null;
                }
                this.refreshConsumer();
                return null;
            }
            this.beanContext.createErrorMessage(INVALID_MODIFY, new Object[0]);
        }
        this.beanContext.createErrorMessage(CANNOT_MODIFY_REG, new Object[0]);
        return null;
    }

    public String eraseLocalRegistration() {
        if (this.consumer != null) {
            this.getProducerInfo().eraseRegistrationInfo();
            return "configureConsumer";
        }
        this.beanContext.createErrorMessage(CANNOT_ERASE_REG, new Object[0]);
        return null;
    }

    private Object modifyIfNeeded(Object oldValue, Object newValue, String target, boolean checkURL) {
        if (this.isOldAndNewDifferent(oldValue, newValue)) {
            if (checkURL) {
                try {
                    new URL(newValue.toString());
                }
                catch (MalformedURLException e) {
                    this.beanContext.createTargetedErrorMessage(target, MALFORMED_URL, new Object[]{newValue, e.getLocalizedMessage()});
                }
            }
            oldValue = newValue;
            this.modified = true;
        }
        return oldValue;
    }

    protected String getObjectTypeName() {
        return CONSUMER_TYPE;
    }

    public boolean isAlreadyExisting(String objectName) {
        return this.getRegistry().getConsumer(objectName) != null;
    }

    public ConsumerRegistry getRegistry() {
        if (this.registry == null) {
            this.registry = (ConsumerRegistry)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ConsumerRegistry.class);
        }
        return this.registry;
    }
}

