/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.admin.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import org.gatein.registration.RegistrationPolicy;
import org.gatein.registration.policies.DefaultRegistrationPolicy;
import org.gatein.wsrp.admin.ui.ManagedBean;
import org.gatein.wsrp.admin.ui.ProducerBean;
import org.gatein.wsrp.producer.config.ProducerConfiguration;
import org.gatein.wsrp.producer.config.ProducerConfigurationService;
import org.gatein.wsrp.producer.config.ProducerRegistrationRequirements;
import org.gatein.wsrp.registration.RegistrationPropertyDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProducerBean
extends ManagedBean {
    private ProducerConfigurationService configurationService;
    private String policyClassName;
    private String validatorClassName;
    private static final String PROPERTY = "property";
    private static final String PRODUCER = "producer";
    private String selectedProp;

    public ProducerConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ProducerConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public ProducerConfiguration getConfiguration() {
        return this.getConfigurationService().getConfiguration();
    }

    public boolean isRegistrationRequiredForFullDescription() {
        return this.getRegRequirements().isRegistrationRequiredForFullDescription();
    }

    private ProducerRegistrationRequirements getRegRequirements() {
        return this.getConfiguration().getRegistrationRequirements();
    }

    public void setRegistrationRequiredForFullDescription(boolean requireRegForFullDescription) {
        this.getRegRequirements().setRegistrationRequiredForFullDescription(requireRegForFullDescription);
    }

    public boolean isRegistrationRequired() {
        return this.getRegRequirements().isRegistrationRequired();
    }

    public void setRegistrationRequired(boolean requireRegistration) {
        this.getRegRequirements().setRegistrationRequired(requireRegistration);
    }

    public String getRegistrationPolicyClassName() {
        RegistrationPolicy policy = this.getRegRequirements().getPolicy();
        if (policy != null) {
            return policy.getClass().getName();
        }
        return this.beanContext.getMessageFromBundle("bean_producer_regpolicy_unset", new Object[0]);
    }

    public void setRegistrationPolicyClassName(String className) {
        this.policyClassName = className;
    }

    public boolean isDefaultRegistrationPolicy() {
        return "org.gatein.registration.policies.DefaultRegistrationPolicy".equals(this.getRegistrationPolicyClassName());
    }

    public String getValidatorClassName() {
        if (this.isDefaultRegistrationPolicy()) {
            return ((DefaultRegistrationPolicy)this.getRegRequirements().getPolicy()).getValidator().getClass().getName();
        }
        throw new IllegalStateException("getValidatorClassName shouldn't be called if we're not using the default registration");
    }

    public void setValidatorClassName(String className) {
        this.validatorClassName = className;
    }

    public boolean isStrictMode() {
        return this.getConfiguration().isUsingStrictMode();
    }

    public void setStrictMode(boolean strictMode) {
        this.getConfiguration().setUsingStrictMode(strictMode);
    }

    public List<RegistrationPropertyDescription> getRegistrationProperties() {
        Map descriptions = this.getRegRequirements().getRegistrationProperties();
        1 descComparator = new /* Unavailable Anonymous Inner Class!! */;
        ArrayList<RegistrationPropertyDescription> result = new ArrayList<RegistrationPropertyDescription>(descriptions.values());
        Collections.sort(result, descComparator);
        return result;
    }

    public List<SelectItem> getSupportedPropertyTypes() {
        return Collections.singletonList(new SelectItem((Object)"xsd:string"));
    }

    public String getSelectedPropertyName() {
        return this.selectedProp;
    }

    public String save() {
        try {
            if (!"org.gatein.registration.policies.DefaultRegistrationPolicy".equals(this.policyClassName)) {
                this.getRegRequirements().reloadPolicyFrom(this.policyClassName, this.validatorClassName);
            }
            this.getConfigurationService().saveConfiguration();
            this.beanContext.createInfoMessage("bean_producer_save_success");
        }
        catch (Exception e) {
            this.log.debug("Couldn't save producer", (Throwable)e);
            this.beanContext.createErrorMessage("bean_producer_cannot_save", new Object[]{e.getLocalizedMessage()});
        }
        return PRODUCER;
    }

    public String reloadConfiguration() {
        try {
            this.getConfigurationService().reloadConfiguration();
            this.beanContext.createInfoMessage("bean_producer_cancel_success");
        }
        catch (Exception e) {
            this.log.debug("Couldn't reload producer configuration", (Throwable)e);
            this.beanContext.createErrorMessage("bean_producer_cannot_reload", new Object[]{e.getLocalizedMessage()});
        }
        return PRODUCER;
    }

    public String addRegistrationProperty() {
        this.getRegRequirements().addEmptyRegistrationProperty(PROPERTY + System.currentTimeMillis());
        return PRODUCER;
    }

    public String deleteRegistrationProperty() {
        this.getRegRequirements().removeRegistrationProperty(this.selectedProp);
        return PRODUCER;
    }

    public void requireRegistrationListener(ValueChangeEvent event) {
        this.setRegistrationRequired(((Boolean)event.getNewValue()).booleanValue());
        FacesContext.getCurrentInstance().renderResponse();
    }

    public void selectProperty(ActionEvent event) {
        this.selectedProp = this.beanContext.getParameter("propName");
    }

    protected String getObjectTypeName() {
        return null;
    }

    public boolean isAlreadyExisting(String objectName) {
        return false;
    }
}

