/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.admin.ui;

import com.google.common.base.Function;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.SortedMap;
import javax.faces.event.ActionEvent;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.wsrp.WSRPConsumer;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.admin.ui.ConsumerBean;
import org.gatein.wsrp.admin.ui.ConsumerManagerBean;
import org.gatein.wsrp.admin.ui.ManagedBean;
import org.gatein.wsrp.api.PortalStructureProvider;
import org.gatein.wsrp.consumer.EndpointConfigurationInfo;
import org.gatein.wsrp.consumer.ProducerInfo;
import org.gatein.wsrp.consumer.RegistrationInfo;
import org.gatein.wsrp.consumer.RegistrationProperty;
import org.gatein.wsrp.consumer.migration.ExportInfo;
import org.gatein.wsrp.consumer.migration.ImportInfo;
import org.gatein.wsrp.consumer.migration.MigrationService;
import org.gatein.wsrp.consumer.registry.ConsumerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerBean
extends ManagedBean {
    public static final SelectablePortletToHandleFunction SELECTABLE_TO_HANDLE = new SelectablePortletToHandleFunction(null);
    private WSRPConsumer consumer;
    private ConsumerRegistry registry;
    private ConsumerManagerBean manager;
    private boolean modified;
    private String wsdl;
    private static final String CANNOT_FIND_CONSUMER = "bean_consumer_cannot_find_consumer";
    private static final String CANNOT_UPDATE_CONSUMER = "bean_consumer_cannot_update_consumer";
    private static final String CANNOT_REFRESH_CONSUMER = "bean_consumer_cannot_refresh_consumer";
    private static final String MODIFY_REG_SUCCESS = "bean_consumer_modify_reg_success";
    private static final String INVALID_MODIFY = "bean_consumer_invalid_modify";
    private static final String CANNOT_MODIFY_REG = "bean_consumer_cannot_modify_reg";
    private static final String CANNOT_ERASE_REG = "bean_consumer_cannot_erase_reg";
    private static final String MALFORMED_URL = "bean_consumer_malformed_url";
    private static final String UPDATE_SUCCESS = "bean_consumer_update_success";
    private static final String CANNOT_EXPORT = "bean_consumer_cannot_export";
    private static final String IMPORT_SUCCESS = "bean_consumer_import_success";
    private static final String FAILED_PORTLETS = "bean_consumer_import_failed_portlets";
    private static final String CONSUMER_TYPE = "CONSUMER_TYPE";
    private DataModel portletHandles;
    private DataModel existingExports;
    private ExportInfoDisplay currentExport;

    public void setRegistry(ConsumerRegistry registry) {
        this.registry = registry;
    }

    public void setManager(ConsumerManagerBean manager) {
        this.manager = manager;
    }

    public boolean isModified() {
        return this.modified || this.getProducerInfo().isModifyRegistrationRequired() || this.isRegistrationLocallyModified();
    }

    public boolean isRefreshNeeded() {
        return this.consumer.isRefreshNeeded();
    }

    public String getId() {
        return this.consumer.getProducerId();
    }

    public void setId(String id) {
        if (this.consumer != null) {
            ProducerInfo info = this.getProducerInfo();
            String oldId = info.getId();
            if (this.isOldAndNewDifferent((Object)oldId, (Object)id) && (id = this.checkNameValidity(id, "edit-cons-form:id")) != null) {
                info.setId(id);
                this.getRegistry().updateProducerInfo(info);
                this.modified = true;
            }
        } else {
            this.consumer = this.getRegistry().getConsumer(id);
            if (this.consumer != null) {
                EndpointConfigurationInfo endpoint = this.getProducerInfo().getEndpointConfigurationInfo();
                this.wsdl = endpoint.getWsdlDefinitionURL();
            } else {
                this.beanContext.createErrorMessage(CANNOT_FIND_CONSUMER, new Object[]{id});
            }
        }
    }

    public Integer getCache() {
        return this.getProducerInfo().getExpirationCacheSeconds();
    }

    public void setCache(Integer cache) {
        this.getProducerInfo().setExpirationCacheSeconds((Integer)this.modifyIfNeeded((Object)this.getCache(), (Object)cache, "cache", false));
    }

    public Integer getTimeout() {
        return this.getProducerInfo().getEndpointConfigurationInfo().getWSOperationTimeOut();
    }

    public void setTimeout(Integer timeout) {
        this.getProducerInfo().getEndpointConfigurationInfo().setWSOperationTimeOut(((Integer)this.modifyIfNeeded((Object)this.getTimeout(), (Object)timeout, "timeout", false)).intValue());
    }

    public String getWsdl() {
        return this.wsdl;
    }

    public void setWsdl(String wsdlURL) {
        this.wsdl = (String)this.modifyIfNeeded((Object)this.wsdl, (Object)wsdlURL, "wsdl", true);
    }

    private void internalSetWsdl(String wsdlURL) {
        try {
            this.getProducerInfo().getEndpointConfigurationInfo().setWsdlDefinitionURL(wsdlURL);
        }
        catch (Exception e) {
            this.getRegistry().deactivateConsumerWith(this.getId());
            this.beanContext.createErrorMessageFrom("wsdl", e);
        }
    }

    public boolean isActive() {
        return this.consumer.isActive();
    }

    public boolean isRegistered() {
        return this.getProducerInfo().isRegistered();
    }

    public boolean isRegistrationRequired() {
        return this.getProducerInfo().isRegistrationRequired();
    }

    public boolean isRegistrationCheckNeeded() {
        ProducerInfo info = this.getProducerInfo();
        if (info.isRefreshNeeded(true)) {
            RegistrationInfo regInfo = info.getRegistrationInfo();
            if (regInfo == null) {
                return true;
            }
            Boolean consistent = regInfo.isConsistentWithProducerExpectations();
            return consistent == null || consistent == false;
        }
        return false;
    }

    public boolean isDisplayExpectedNeeded() {
        ProducerInfo producerInfo = this.getProducerInfo();
        return producerInfo.isModifyRegistrationRequired() && producerInfo.getRegistrationInfo() != producerInfo.getExpectedRegistrationInfo();
    }

    public boolean isRegistrationLocallyModified() {
        return this.isRegistered() && this.getProducerInfo().getRegistrationInfo().isModifiedSinceLastRefresh();
    }

    public boolean isRegistrationChecked() {
        return this.getProducerInfo().isRegistrationChecked();
    }

    public boolean isRegistrationValid() {
        if (this.isRegistrationChecked()) {
            return this.getProducerInfo().getRegistrationInfo().isRegistrationValid();
        }
        throw new IllegalStateException("Need to check the registration before determining if it's valid!");
    }

    public ProducerInfo getProducerInfo() {
        return this.consumer.getProducerInfo();
    }

    public boolean isLocalInfoPresent() {
        return this.getProducerInfo().hasLocalRegistrationInfo();
    }

    public boolean isRegistrationPropertiesExisting() {
        RegistrationInfo regInfo = this.getProducerInfo().getRegistrationInfo();
        return regInfo == null || regInfo.isRegistrationPropertiesExisting();
    }

    public boolean isExpectedRegistrationPropertiesExisting() {
        RegistrationInfo info = this.getExpectedRegistrationInfo();
        return info != null && info.isRegistrationPropertiesExisting();
    }

    private RegistrationInfo getExpectedRegistrationInfo() {
        return this.getProducerInfo().getExpectedRegistrationInfo();
    }

    public List<RegistrationProperty> getRegistrationProperties() {
        return this.getSortedProperties(this.getProducerInfo().getRegistrationInfo());
    }

    public List<RegistrationProperty> getExpectedRegistrationProperties() {
        return this.getSortedProperties(this.getExpectedRegistrationInfo());
    }

    private List<RegistrationProperty> getSortedProperties(RegistrationInfo registrationInfo) {
        if (registrationInfo != null) {
            LinkedList<RegistrationProperty> list = new LinkedList<RegistrationProperty>(registrationInfo.getRegistrationProperties().values());
            Collections.sort(list);
            return list;
        }
        return Collections.emptyList();
    }

    public String update() {
        return this.internalUpdate(true);
    }

    public String confirmEraseRegistration() {
        return "confirmEraseRegistration";
    }

    private String internalUpdate(boolean showMessage) {
        if (this.consumer != null) {
            if (this.isModified()) {
                try {
                    ProducerInfo prodInfo = this.getProducerInfo();
                    EndpointConfigurationInfo endpointInfo = prodInfo.getEndpointConfigurationInfo();
                    this.internalSetWsdl(this.wsdl);
                    this.saveToRegistry(prodInfo);
                }
                catch (Exception e) {
                    this.beanContext.createErrorMessageFrom(e);
                    return null;
                }
            }
            if (showMessage) {
                this.beanContext.createInfoMessage(UPDATE_SUCCESS);
            }
            return "configureConsumer";
        }
        this.beanContext.createErrorMessage(CANNOT_UPDATE_CONSUMER, new Object[0]);
        return null;
    }

    private void saveToRegistry(ProducerInfo prodInfo) {
        this.getRegistry().updateProducerInfo(prodInfo);
        this.modified = false;
    }

    public String refreshConsumer() {
        if (this.consumer != null) {
            String updateResult;
            if (this.isModified() && (updateResult = this.internalUpdate(false)) == null) {
                return null;
            }
            if (!this.isRegistrationLocallyModified()) {
                this.manager.refresh(this.consumer);
            } else {
                this.beanContext.createInfoMessage("bean_consumermanager_refresh_modify");
            }
            return "configureConsumer";
        }
        this.beanContext.createErrorMessage(CANNOT_REFRESH_CONSUMER, new Object[0]);
        return null;
    }

    public String modifyRegistration() {
        if (this.consumer != null) {
            ProducerInfo info = this.getProducerInfo();
            if (this.isModified()) {
                RegistrationInfo newReg = this.getExpectedRegistrationInfo();
                this.saveToRegistry(info);
                RegistrationInfo oldReg = this.getProducerInfo().getRegistrationInfo();
                if (newReg == null) {
                    newReg = new RegistrationInfo(oldReg);
                    if (!this.isRegistrationLocallyModified()) {
                        IllegalStateException e = new IllegalStateException("Registration not locally modified: there should be expected registration from producer!");
                        this.log.debug("Couldn't modify registration", (Throwable)e);
                        throw e;
                    }
                }
                try {
                    newReg.setModifiedSinceLastRefresh(true);
                    info.setRegistrationInfo(newReg);
                    info.modifyRegistration();
                    newReg.setModifiedSinceLastRefresh(false);
                    this.beanContext.createInfoMessage(MODIFY_REG_SUCCESS);
                }
                catch (Exception e) {
                    info.setRegistrationInfo(oldReg);
                    this.beanContext.createErrorMessageFrom(e);
                    return null;
                }
                this.refreshConsumer();
                return null;
            }
            this.beanContext.createErrorMessage(INVALID_MODIFY, new Object[0]);
        }
        this.beanContext.createErrorMessage(CANNOT_MODIFY_REG, new Object[0]);
        return null;
    }

    public String eraseLocalRegistration() {
        if (this.consumer != null) {
            this.getProducerInfo().eraseRegistrationInfo();
            return "configureConsumer";
        }
        this.beanContext.createErrorMessage(CANNOT_ERASE_REG, new Object[0]);
        return null;
    }

    private Object modifyIfNeeded(Object oldValue, Object newValue, String target, boolean checkURL) {
        if (this.isOldAndNewDifferent(oldValue, newValue)) {
            if (checkURL) {
                try {
                    new URL(newValue.toString());
                }
                catch (MalformedURLException e) {
                    this.beanContext.createTargetedErrorMessage(target, MALFORMED_URL, new Object[]{newValue, e.getLocalizedMessage()});
                }
            }
            oldValue = newValue;
            this.modified = true;
        }
        return oldValue;
    }

    protected String getObjectTypeName() {
        return CONSUMER_TYPE;
    }

    public boolean isAlreadyExisting(String objectName) {
        return this.getRegistry().getConsumer(objectName) != null;
    }

    public ConsumerRegistry getRegistry() {
        return this.registry;
    }

    public DataModel getPortlets() {
        try {
            if (this.portletHandles == null) {
                Collection portlets = this.consumer.getProducerInfo().getPortletMap().values();
                List selectableHandles = Collections.emptyList();
                if (ParameterValidation.existsAndIsNotEmpty(portlets)) {
                    selectableHandles = new ArrayList(portlets.size());
                    for (Portlet portlet : portlets) {
                        selectableHandles.add(new SelectablePortletHandle(portlet.getContext().getId(), this.consumer.getMigrationService().getStructureProvider()));
                    }
                }
                Collections.sort(selectableHandles);
                this.portletHandles = new ListDataModel(selectableHandles);
            }
            return this.portletHandles;
        }
        catch (PortletInvokerException e) {
            this.beanContext.createErrorMessageFrom((Exception)((Object)e));
            return null;
        }
    }

    public String exportPortlets() {
        if (this.consumer != null) {
            List handles = (List)this.portletHandles.getWrappedData();
            ArrayList<String> selectedHandles = new ArrayList<String>(handles.size());
            for (SelectablePortletHandle selectablePortletHandle : handles) {
                if (!selectablePortletHandle.isSelected()) continue;
                selectedHandles.add(selectablePortletHandle.getHandle());
            }
            try {
                this.currentExport = new ExportInfoDisplay(this.consumer.exportPortlets(selectedHandles), this.beanContext.getLocale(), this.consumer.getMigrationService().getStructureProvider());
            }
            catch (Exception e) {
                this.beanContext.createErrorMessageFrom(e);
                return null;
            }
            return "exportDetail";
        }
        this.beanContext.createErrorMessage(CANNOT_EXPORT, new Object[0]);
        return null;
    }

    public ExportInfoDisplay getCurrentExport() {
        return this.currentExport;
    }

    public DataModel getExistingExports() {
        if (this.existingExports == null) {
            Locale locale = this.beanContext.getLocale();
            MigrationService migrationService = this.consumer.getMigrationService();
            List availableExportInfos = migrationService.getAvailableExportInfos();
            ArrayList<ExportInfoDisplay> exportDisplays = new ArrayList<ExportInfoDisplay>(availableExportInfos.size());
            for (ExportInfo exportInfo : availableExportInfos) {
                exportDisplays.add(new ExportInfoDisplay(exportInfo, locale, migrationService.getStructureProvider()));
            }
            this.existingExports = new ListDataModel(exportDisplays);
        }
        return this.existingExports;
    }

    public String viewExport() {
        this.selectExport();
        return "exportDetail";
    }

    public String importPortlets() {
        List exportedPortlets = this.currentExport.getExportedPortlets();
        try {
            ArrayList<SelectablePortletHandle> portletsToImport = new ArrayList<SelectablePortletHandle>(exportedPortlets.size());
            for (SelectablePortletHandle exportedPortlet : exportedPortlets) {
                if (!exportedPortlet.isSelected()) continue;
                portletsToImport.add(exportedPortlet);
            }
            ImportInfo info = this.consumer.importPortlets(this.currentExport.getExport(), WSRPUtils.transform(portletsToImport, (Function)SELECTABLE_TO_HANDLE));
            PortalStructureProvider structureProvider = this.consumer.getMigrationService().getStructureProvider();
            int importCount = 0;
            for (SelectablePortletHandle importedPortlet : portletsToImport) {
                PortletContext portletContext = info.getPortletContextFor(importedPortlet.getHandle());
                if (portletContext == null) continue;
                structureProvider.assignPortletToWindow(portletContext, importedPortlet.getWindow(), importedPortlet.getPage());
                ++importCount;
            }
            this.beanContext.createLocalizedMessage("status", IMPORT_SUCCESS, this.beanContext.getInfoSeverity(), new Object[]{importCount});
            SortedMap errorCodesToFailedPortletHandlesMapping = info.getErrorCodesToFailedPortletHandlesMapping();
            if (!errorCodesToFailedPortletHandlesMapping.isEmpty()) {
                this.beanContext.createErrorMessage(FAILED_PORTLETS, new Object[]{errorCodesToFailedPortletHandlesMapping});
            }
            return "consumers";
        }
        catch (PortletInvokerException e) {
            this.beanContext.createErrorMessageFrom((Exception)((Object)e));
            return null;
        }
    }

    public String deleteExport() {
        ExportInfo export = this.currentExport.getExport();
        if (this.consumer.getMigrationService().remove(export) == export) {
            this.existingExports = null;
            this.currentExport = null;
        }
        return "exports";
    }

    public void selectExport(ActionEvent actionEvent) {
        this.selectExport();
    }

    public void selectExport() {
        this.currentExport = (ExportInfoDisplay)this.existingExports.getRowData();
    }

    public boolean isSupportsExport() {
        return this.consumer.isSupportsExport();
    }

    public boolean isAvailableExportInfosEmpty() {
        return this.consumer.getMigrationService().isAvailableExportInfosEmpty();
    }
}

