/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.admin.ui;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.gatein.common.util.ParameterValidation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public abstract class BeanContext {
    protected static final Logger log = Logger.getLogger(BeanContext.class);
    public static final String STATUS = "status";
    private static final String DEFAULT_RESOURCE_NAME = "Resource";
    private static final String UNEXPECTED_ERROR = "bean_support_unexpected_error";
    private static final String CAUSE = "bean_support_cause";
    private static final String CURRENT_PLACEHOLDER = "###";
    private String resourceName = "Resource";

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public abstract String getParameter(String var1);

    protected abstract void createMessage(String var1, String var2, Object var3, Object ... var4);

    protected abstract Object getErrorSeverity();

    protected abstract Object getInfoSeverity();

    protected abstract Locale getLocale();

    public void createErrorMessage(String localizedMessageId, Object ... params) {
        this.createLocalizedMessage("status", localizedMessageId, this.getErrorSeverity(), params);
    }

    public void createTargetedErrorMessage(String target, String localizedMessageId, Object ... params) {
        this.createLocalizedMessage(target, localizedMessageId, this.getErrorSeverity(), params);
    }

    protected void createLocalizedMessage(String target, String localizedMessageId, Object severity, Object ... params) {
        this.createMessage(target, this.getMessageFromBundle(localizedMessageId, params), severity, new Object[0]);
    }

    public String getMessageFromBundle(String localizedMessageId, Object ... params) {
        return BeanContext.getLocalizedMessage((String)localizedMessageId, (Locale)this.getLocale(), (String)this.resourceName, (Object[])params);
    }

    public static String getLocalizedMessage(String localizationKey, Locale locale, Object ... params) {
        return BeanContext.getLocalizedMessage((String)localizationKey, (Locale)locale, (String)"Resource", (Object[])params);
    }

    public static String getLocalizedMessage(String localizationKey, Locale locale, String resourceName, Object ... params) {
        String message;
        ResourceBundle rb = ResourceBundle.getBundle(resourceName, locale);
        try {
            message = rb.getString(localizationKey);
        }
        catch (MissingResourceException e) {
            log.info((Object)("Couldn't find localization message for key '" + localizationKey + "' in bundle " + resourceName + " for locale " + locale.getDisplayName()));
            return localizationKey;
        }
        return MessageFormat.format(message, params);
    }

    public void createErrorMessageFrom(Exception e) {
        this.createErrorMessageFrom("status", e);
    }

    public void createErrorMessageFrom(String target, Exception e) {
        String localizedMessage = this.getLocalizedMessageOrExceptionName((Throwable)e);
        this.createMessage(target, localizedMessage, this.getErrorSeverity(), new Object[]{e.getCause()});
    }

    private String getLocalizedMessageOrExceptionName(Throwable e) {
        String localizedMessage = e.getLocalizedMessage();
        if (localizedMessage == null) {
            localizedMessage = this.getMessageFromBundle("bean_support_unexpected_error", new Object[0]) + e.getClass().getName();
        }
        return localizedMessage;
    }

    protected void createInfoMessage(String target, String localizedMessageId) {
        this.createLocalizedMessage(target, localizedMessageId, this.getInfoSeverity(), new Object[0]);
    }

    public void createInfoMessage(String localizedMessageId) {
        this.createInfoMessage("status", localizedMessageId);
    }

    public void removeFromSession(String name, String ... otherNames) {
        Map sessionMap = this.getSessionMap();
        sessionMap.remove(name);
        if (otherNames != null) {
            for (String other : otherNames) {
                sessionMap.remove(other);
            }
        }
    }

    public abstract Map<String, Object> getSessionMap();

    public <T> T replaceInSession(String name, T newValue) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)name, (String)"name", (String)"replaceInSession");
        Map sessionMap = this.getSessionMap();
        if (newValue == null) {
            sessionMap.remove(name);
            return null;
        }
        this.getFromSession(name, newValue.getClass(), sessionMap, "Provided object: " + newValue + " is not compatible with previously assigned '" + name + "' object: " + "###");
        sessionMap.put(name, newValue);
        return newValue;
    }

    public <T> T getFromSession(String name, Class<T> expectedClass) {
        return (T)this.getFromSession(name, expectedClass, this.getSessionMap(), "Current object:### is not compatible with expected class " + expectedClass + " for '" + name + "'");
    }

    private <T> T getFromSession(String name, Class<T> expectedClass, Map<String, Object> sessionMap, String errorMessage) {
        Object result = sessionMap.get(name);
        if (result != null && !expectedClass.isAssignableFrom(result.getClass())) {
            throw new IllegalArgumentException(errorMessage.replace("###", result.toString()));
        }
        return expectedClass.cast(result);
    }
}

