/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.admin.ui;

import java.util.regex.Pattern;
import org.gatein.common.util.ParameterValidation;
import org.gatein.wsrp.admin.ui.BeanContext;
import org.gatein.wsrp.admin.ui.ManagedBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ManagedBean {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected BeanContext beanContext;
    private String cancelOutcome;
    public static final String INVALID_NAME = "INVALID_NAME_ERROR";
    public static final String INVALID_PATH = "INVALID_PATH_ERROR";
    public static final String DUPLICATE = "DUPLICATE_ERROR";
    private PropertyValidator validator = new DefaultPropertyValidator(this);

    protected void setValidator(PropertyValidator validator) {
        this.validator = validator;
    }

    public void setBeanContext(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    public void setCancelOutcome(String cancelOutcome) {
        this.cancelOutcome = cancelOutcome;
    }

    public String checkNameValidity(String name, String targetForErrorMessage) {
        return this.checkNameValidity(name, targetForErrorMessage, this.validator);
    }

    public String checkNameValidity(String name, String targetForErrorMessage, PropertyValidator validator) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)validator, (String)"PropertyValidator");
        String objectTypeName = validator.getObjectTypeName();
        if (ParameterValidation.isNullOrEmpty((String)name)) {
            this.beanContext.createTargetedErrorMessage(targetForErrorMessage, INVALID_NAME, new Object[]{name, this.getLocalizedType(objectTypeName)});
            return null;
        }
        String original = name;
        if ((name = validator.doSimpleChecks(name)) == null) {
            this.beanContext.createTargetedErrorMessage(targetForErrorMessage, INVALID_NAME, new Object[]{original, this.getLocalizedType(objectTypeName)});
            return null;
        }
        name = name.trim();
        if ((name = ParameterValidation.sanitizeFromPatternWithHandler((String)name, (Pattern)validator.getValidationPattern(), (ParameterValidation.ValidationErrorHandler)validator.getValidationErrorHandler(name, targetForErrorMessage))) == null) {
            return null;
        }
        if (validator.checkForDuplicates() && validator.isAlreadyExisting(name)) {
            this.getDuplicateErrorMessage(name, targetForErrorMessage, objectTypeName);
            return null;
        }
        return name;
    }

    protected void getDuplicateErrorMessage(String name, String targetForErrorMessage, String objectTypeName) {
        this.beanContext.createTargetedErrorMessage(targetForErrorMessage, DUPLICATE, new Object[]{name, this.getLocalizedType(objectTypeName)});
    }

    private String getLocalizedType(String objectTypeName) {
        return this.beanContext.getMessageFromBundle(objectTypeName, new Object[0]);
    }

    protected abstract String getObjectTypeName();

    public abstract boolean isAlreadyExisting(String var1);

    public boolean isOldAndNewDifferent(Object oldValue, Object newValue) {
        oldValue = this.normalizeStringIfNeeded(oldValue);
        newValue = this.normalizeStringIfNeeded(newValue);
        return oldValue != null && !oldValue.equals(newValue) || oldValue == null && newValue != null;
    }

    public Object normalizeStringIfNeeded(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            return stringValue.length() == 0 ? null : stringValue.trim();
        }
        return value;
    }

    public String cancel() {
        return this.cancelOutcome;
    }

    static /* synthetic */ String access$000(ManagedBean x0, String x1) {
        return x0.getLocalizedType(x1);
    }
}

