/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.admin.ui;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlDataTable;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import org.gatein.registration.RegistrationPolicy;
import org.gatein.registration.policies.DefaultRegistrationPolicy;
import org.gatein.registration.policies.RegistrationPolicyWrapper;
import org.gatein.wsrp.admin.ui.ManagedBean;
import org.gatein.wsrp.admin.ui.ProducerBean;
import org.gatein.wsrp.producer.config.ProducerConfiguration;
import org.gatein.wsrp.producer.config.ProducerConfigurationService;
import org.gatein.wsrp.producer.config.ProducerRegistrationRequirements;
import org.gatein.wsrp.registration.RegistrationPropertyDescription;

public class ProducerBean
extends ManagedBean
implements Serializable {
    private transient ProducerConfigurationService configurationService;
    private String policyClassName;
    private String validatorClassName;
    private static final String PROPERTY = "property";
    private static final String PRODUCER = "producer";
    private String selectedProp;
    private transient LocalProducerConfiguration localProducerConfiguration;

    public ProducerConfigurationService getConfigurationService() {
        if (this.configurationService == null) {
            this.configurationService = (ProducerConfigurationService)this.beanContext.findBean("ProducerConfigurationService", ProducerConfigurationService.class);
        }
        return this.configurationService;
    }

    public void setConfigurationService(ProducerConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public ProducerConfiguration getConfiguration() {
        return this.getConfigurationService().getConfiguration();
    }

    public boolean isRegistrationRequiredForFullDescription() {
        return this.getLocalConfiguration().isRegistrationRequiredForFullDescription();
    }

    public void setRegistrationRequiredForFullDescription(boolean requireRegForFullDescription) {
        this.getLocalConfiguration().setRegistrationRequiredForFullDescription(requireRegForFullDescription);
    }

    public boolean isRegistrationRequired() {
        return this.getLocalConfiguration().isRegistrationRequired();
    }

    public void setRegistrationRequired(boolean requireRegistration) {
        this.getLocalConfiguration().setRegistrationRequired(requireRegistration);
    }

    public String getRegistrationPolicyClassName() {
        RegistrationPolicy policy = this.getLocalConfiguration().getPolicy();
        if (policy != null) {
            return policy.getClassName();
        }
        return this.beanContext.getMessageFromBundle("bean_producer_regpolicy_unset", new Object[0]);
    }

    public void setRegistrationPolicyClassName(String className) {
        this.policyClassName = className;
    }

    public boolean isDefaultRegistrationPolicy() {
        return "org.gatein.registration.policies.DefaultRegistrationPolicy".equals(this.getRegistrationPolicyClassName());
    }

    public String getValidatorClassName() {
        if (this.isDefaultRegistrationPolicy()) {
            DefaultRegistrationPolicy policy = (DefaultRegistrationPolicy)RegistrationPolicyWrapper.unwrap((RegistrationPolicy)this.getLocalConfiguration().getPolicy());
            return policy.getValidator().getClass().getName();
        }
        throw new IllegalStateException("getValidatorClassName shouldn't be called if we're not using the default registration");
    }

    public void setValidatorClassName(String className) {
        this.validatorClassName = className;
    }

    public boolean isStrictMode() {
        return this.getLocalConfiguration().isUsingStrictMode();
    }

    public void setStrictMode(boolean strictMode) {
        this.getLocalConfiguration().setUsingStrictMode(strictMode);
    }

    public List<RegistrationPropertyDescription> getRegistrationProperties() {
        return this.getLocalConfiguration().getRegistrationProperties();
    }

    public List<SelectItem> getSupportedPropertyTypes() {
        return Collections.singletonList(new SelectItem((Object)"xsd:string"));
    }

    public String getSelectedPropertyName() {
        return this.selectedProp;
    }

    public String save() {
        try {
            ProducerConfiguration currentlyPersistedConfiguration = this.getConfiguration();
            LocalProducerConfiguration localConfiguration = this.getLocalConfiguration();
            ProducerRegistrationRequirements registrationRequirements = currentlyPersistedConfiguration.getRegistrationRequirements();
            registrationRequirements.setRegistrationRequiredForFullDescription(localConfiguration.isRegistrationRequiredForFullDescription());
            registrationRequirements.setRegistrationRequired(localConfiguration.isRegistrationRequired());
            registrationRequirements.reloadPolicyFrom(this.policyClassName, this.validatorClassName);
            registrationRequirements.setRegistrationProperties(localConfiguration.getRegistrationRequirements().getRegistrationProperties());
            currentlyPersistedConfiguration.setUsingStrictMode(localConfiguration.isUsingStrictMode());
            this.getConfigurationService().saveConfiguration();
            this.localProducerConfiguration = null;
            this.beanContext.createInfoMessage("bean_producer_save_success");
        }
        catch (Exception e) {
            this.log.debug("Couldn't save producer", (Throwable)e);
            this.beanContext.createErrorMessage("bean_producer_cannot_save", new Object[]{e.getLocalizedMessage()});
        }
        return PRODUCER;
    }

    public String reloadConfiguration() {
        try {
            this.getConfigurationService().reloadConfiguration();
            this.localProducerConfiguration = null;
            this.beanContext.createInfoMessage("bean_producer_cancel_success");
        }
        catch (Exception e) {
            this.log.debug("Couldn't reload producer configuration", (Throwable)e);
            this.beanContext.createErrorMessage("bean_producer_cannot_reload", new Object[]{e.getLocalizedMessage()});
        }
        return PRODUCER;
    }

    public String addRegistrationProperty() {
        this.getLocalConfiguration().addEmptyRegistrationProperty(PROPERTY + System.currentTimeMillis());
        return PRODUCER;
    }

    public String deleteRegistrationProperty() {
        this.getLocalConfiguration().removeRegistrationProperty(this.selectedProp);
        return PRODUCER;
    }

    public void requireRegistrationListener(ValueChangeEvent event) {
        this.setRegistrationRequired(((Boolean)event.getNewValue()).booleanValue());
        FacesContext.getCurrentInstance().renderResponse();
    }

    public void strictModeListener(ValueChangeEvent event) {
        this.setStrictMode(((Boolean)event.getNewValue()).booleanValue());
        FacesContext.getCurrentInstance().renderResponse();
    }

    public void requireRegistrationForFullDescListener(ValueChangeEvent event) {
        this.setRegistrationRequiredForFullDescription(((Boolean)event.getNewValue()).booleanValue());
        FacesContext.getCurrentInstance().renderResponse();
    }

    public void selectProperty(ActionEvent event) {
        HtmlDataTable table = this.getParentDataTable((UIComponent)event.getSource());
        RegistrationPropertyDescription prop = (RegistrationPropertyDescription)table.getRowData();
        this.selectedProp = prop.getNameAsString();
    }

    private HtmlDataTable getParentDataTable(UIComponent component) {
        if (component == null) {
            return null;
        }
        if (component instanceof HtmlDataTable) {
            return (HtmlDataTable)component;
        }
        return this.getParentDataTable(component.getParent());
    }

    protected String getObjectTypeName() {
        return null;
    }

    public boolean isAlreadyExisting(String objectName) {
        return false;
    }

    private LocalProducerConfiguration getLocalConfiguration() {
        if (this.localProducerConfiguration == null) {
            this.localProducerConfiguration = new LocalProducerConfiguration(null);
            ProducerConfiguration configuration = this.getConfiguration();
            this.localProducerConfiguration.initFrom(configuration.getRegistrationRequirements(), configuration.isUsingStrictMode());
        }
        return this.localProducerConfiguration;
    }

    public String getV1WSDL() {
        return this.beanContext.getServerAddress() + "/wsrp-producer/v1/MarkupService?wsdl";
    }

    public String getV2WSDL() {
        return this.beanContext.getServerAddress() + "/wsrp-producer/v2/MarkupService?wsdl";
    }
}

