/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.admin.ui;

import com.google.common.base.Function;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.xml.namespace.QName;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.wsrp.WSRPConsumer;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.admin.ui.ConsumerBean;
import org.gatein.wsrp.admin.ui.ConsumerManagerBean;
import org.gatein.wsrp.admin.ui.ManagedBean;
import org.gatein.wsrp.api.context.ConsumerStructureProvider;
import org.gatein.wsrp.consumer.EndpointConfigurationInfo;
import org.gatein.wsrp.consumer.ProducerInfo;
import org.gatein.wsrp.consumer.RegistrationInfo;
import org.gatein.wsrp.consumer.RegistrationProperty;
import org.gatein.wsrp.consumer.migration.ExportInfo;
import org.gatein.wsrp.consumer.migration.ImportInfo;
import org.gatein.wsrp.consumer.migration.MigrationService;
import org.gatein.wsrp.consumer.registry.ConsumerRegistry;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConsumerBean
extends ManagedBean
implements Serializable {
    public static final SelectablePortletToHandleFunction SELECTABLE_TO_HANDLE = new SelectablePortletToHandleFunction(null);
    private transient WSRPConsumer consumer;
    private transient ConsumerManagerBean manager;
    private boolean modified;
    private String wsdl;
    private String id;
    private static final String NULL_ID_CONSUMER = "bean_consumer_null_id";
    private static final String CANNOT_FIND_CONSUMER = "bean_consumer_cannot_find_consumer";
    private static final String CANNOT_UPDATE_CONSUMER = "bean_consumer_cannot_update_consumer";
    private static final String CANNOT_REFRESH_CONSUMER = "bean_consumer_cannot_refresh_consumer";
    private static final String MODIFY_REG_SUCCESS = "bean_consumer_modify_reg_success";
    private static final String INVALID_MODIFY = "bean_consumer_invalid_modify";
    private static final String CANNOT_MODIFY_REG = "bean_consumer_cannot_modify_reg";
    private static final String CANNOT_ERASE_REG = "bean_consumer_cannot_erase_reg";
    private static final String MALFORMED_URL = "bean_consumer_malformed_url";
    private static final String UPDATE_SUCCESS = "bean_consumer_update_success";
    private static final String CANNOT_EXPORT = "bean_consumer_cannot_export";
    private static final String IMPORT_SUCCESS = "bean_consumer_import_success";
    private static final String FAILED_PORTLETS = "bean_consumer_import_failed_portlets";
    private static final String CONSUMER_TYPE = "CONSUMER_TYPE";
    private transient DataModel portletHandles;
    private transient DataModel existingExports;
    private transient ExportInfoDisplay currentExport;

    private static void bypassAndRedisplay() {
        FacesContext.getCurrentInstance().renderResponse();
    }

    public void setManager(ConsumerManagerBean manager) {
        this.manager = manager;
    }

    public boolean isModified() {
        return this.modified || this.getProducerInfo().isModifyRegistrationRequired() || this.isRegistrationLocallyModified();
    }

    public boolean isRefreshNeeded() {
        return this.getConsumer().isRefreshNeeded();
    }

    public String getId() {
        return this.getConsumer().getProducerId();
    }

    public void setId(String id) {
        if (this.consumer != null) {
            ProducerInfo info = this.getProducerInfo();
            String oldId = info.getId();
            if (this.isOldAndNewDifferent((Object)oldId, (Object)id) && (id = this.checkNameValidity(id, "edit-cons-form:id")) != null) {
                info.setId(id);
                this.getRegistry().updateProducerInfo(info);
                this.modified = true;
                this.id = id;
            }
        } else {
            this.resolveConsumer(id);
        }
    }

    private void resolveConsumer(String id) {
        if (id == null) {
            id = this.getManager().getSelectedId();
        }
        if (id == null) {
            this.beanContext.createErrorMessage("bean_consumer_null_id", new Object[0]);
            ConsumerBean.bypassAndRedisplay();
        } else {
            this.consumer = this.getRegistry().getConsumer(id);
            if (this.consumer != null) {
                EndpointConfigurationInfo endpoint = this.getProducerInfo().getEndpointConfigurationInfo();
                this.wsdl = endpoint.getWsdlDefinitionURL();
                this.id = id;
            } else {
                this.beanContext.createErrorMessage("bean_consumer_cannot_find_consumer", new Object[]{id});
                ConsumerBean.bypassAndRedisplay();
            }
        }
    }

    public Integer getCache() {
        return this.getProducerInfo().getExpirationCacheSeconds();
    }

    public void setCache(Integer cache) {
        this.getProducerInfo().setExpirationCacheSeconds((Integer)this.modifyIfNeeded((Object)this.getCache(), (Object)cache, "cache", false));
    }

    public Integer getTimeout() {
        return this.getProducerInfo().getEndpointConfigurationInfo().getWSOperationTimeOut();
    }

    public void setTimeout(Integer timeout) {
        this.getProducerInfo().getEndpointConfigurationInfo().setWSOperationTimeOut(((Integer)this.modifyIfNeeded((Object)this.getTimeout(), (Object)timeout, "timeout", false)).intValue());
    }

    public String getWsdl() {
        return this.wsdl;
    }

    public void setWsdl(String wsdlURL) {
        this.wsdl = (String)this.modifyIfNeeded((Object)this.wsdl, (Object)wsdlURL, "wsdl", true);
    }

    private void internalSetWsdl(String wsdlURL) {
        try {
            this.getProducerInfo().getEndpointConfigurationInfo().setWsdlDefinitionURL(wsdlURL);
        }
        catch (Exception e) {
            this.getRegistry().deactivateConsumerWith(this.getId());
            this.beanContext.createErrorMessageFrom("wsdl", e);
        }
    }

    public boolean isActive() {
        return this.getConsumer().isActive();
    }

    public boolean isRegistered() {
        return this.getProducerInfo().isRegistered();
    }

    public boolean isRegistrationRequired() {
        return this.getProducerInfo().isRegistrationRequired();
    }

    public boolean isRegistrationCheckNeeded() {
        ProducerInfo info = this.getProducerInfo();
        if (info.isRefreshNeeded(true)) {
            RegistrationInfo regInfo = info.getRegistrationInfo();
            if (regInfo == null) {
                return true;
            }
            Boolean consistent = regInfo.isConsistentWithProducerExpectations();
            return consistent == null || consistent == false;
        }
        return false;
    }

    public boolean isDisplayExpectedNeeded() {
        ProducerInfo producerInfo = this.getProducerInfo();
        return producerInfo.isModifyRegistrationRequired() && producerInfo.getRegistrationInfo() != producerInfo.getExpectedRegistrationInfo();
    }

    public boolean isRegistrationLocallyModified() {
        return this.isRegistered() && this.getProducerInfo().getRegistrationInfo().isModifiedSinceLastRefresh();
    }

    public boolean isRegistrationChecked() {
        return this.getProducerInfo().isRegistrationChecked();
    }

    public boolean isRegistrationValid() {
        if (this.isRegistrationChecked()) {
            return this.getProducerInfo().getRegistrationInfo().isRegistrationValid();
        }
        throw new IllegalStateException("Need to check the registration before determining if it's valid!");
    }

    public ProducerInfo getProducerInfo() {
        return this.getConsumer().getProducerInfo();
    }

    public boolean isLocalInfoPresent() {
        return this.getProducerInfo().hasLocalRegistrationInfo();
    }

    public boolean isRegistrationPropertiesExisting() {
        RegistrationInfo regInfo = this.getProducerInfo().getRegistrationInfo();
        return regInfo == null || regInfo.isRegistrationPropertiesExisting();
    }

    public boolean isExpectedRegistrationPropertiesExisting() {
        RegistrationInfo info = this.getExpectedRegistrationInfo();
        return info != null && info.isRegistrationPropertiesExisting();
    }

    private RegistrationInfo getExpectedRegistrationInfo() {
        return this.getProducerInfo().getExpectedRegistrationInfo();
    }

    public List<RegistrationProperty> getRegistrationProperties() {
        return this.getSortedProperties(this.getProducerInfo().getRegistrationInfo());
    }

    public List<RegistrationProperty> getExpectedRegistrationProperties() {
        return this.getSortedProperties(this.getExpectedRegistrationInfo());
    }

    private List<RegistrationProperty> getSortedProperties(RegistrationInfo registrationInfo) {
        if (registrationInfo != null) {
            LinkedList<RegistrationProperty> list = new LinkedList<RegistrationProperty>(registrationInfo.getRegistrationProperties().values());
            Collections.sort(list);
            return list;
        }
        return Collections.emptyList();
    }

    public String update() {
        return this.internalUpdate(true);
    }

    public String confirmEraseRegistration() {
        return "confirmEraseRegistration";
    }

    private String internalUpdate(boolean showMessage) {
        if (this.getConsumer() != null) {
            if (this.isModified()) {
                try {
                    ProducerInfo prodInfo = this.getProducerInfo();
                    EndpointConfigurationInfo endpointInfo = prodInfo.getEndpointConfigurationInfo();
                    this.internalSetWsdl(this.wsdl);
                    this.saveToRegistry(prodInfo);
                }
                catch (Exception e) {
                    this.beanContext.createErrorMessageFrom(e);
                    return null;
                }
            }
            if (showMessage) {
                this.beanContext.createInfoMessage("bean_consumer_update_success");
            }
            return "configureConsumer";
        }
        this.beanContext.createErrorMessage("bean_consumer_cannot_update_consumer", new Object[0]);
        return null;
    }

    private void saveToRegistry(ProducerInfo prodInfo) {
        this.getRegistry().updateProducerInfo(prodInfo);
        this.modified = false;
    }

    public String refreshConsumer() {
        WSRPConsumer consumer = this.getConsumer();
        if (consumer != null) {
            String updateResult;
            if (this.isModified() && (updateResult = this.internalUpdate(false)) == null) {
                return null;
            }
            if (!this.isRegistrationLocallyModified()) {
                this.getManager().refresh(consumer);
            } else {
                this.beanContext.createInfoMessage("bean_consumermanager_refresh_modify");
            }
            return "configureConsumer";
        }
        this.beanContext.createErrorMessage("bean_consumer_cannot_refresh_consumer", new Object[0]);
        return null;
    }

    public String modifyRegistration() {
        if (this.getConsumer() != null) {
            ProducerInfo info = this.getProducerInfo();
            if (this.isModified()) {
                RegistrationInfo newReg = this.getExpectedRegistrationInfo();
                this.saveToRegistry(info);
                RegistrationInfo oldReg = this.getProducerInfo().getRegistrationInfo();
                if (newReg == null) {
                    newReg = new RegistrationInfo(oldReg);
                    if (!this.isRegistrationLocallyModified()) {
                        IllegalStateException e = new IllegalStateException("Registration not locally modified: there should be expected registration from producer!");
                        this.log.debug("Couldn't modify registration", (Throwable)e);
                        throw e;
                    }
                }
                try {
                    newReg.setModifiedSinceLastRefresh(true);
                    info.setRegistrationInfo(newReg);
                    info.modifyRegistration();
                    newReg.setModifiedSinceLastRefresh(false);
                    this.beanContext.createInfoMessage("bean_consumer_modify_reg_success");
                }
                catch (Exception e) {
                    info.setRegistrationInfo(oldReg);
                    this.beanContext.createErrorMessageFrom(e);
                    return null;
                }
                this.refreshConsumer();
                return null;
            }
            this.beanContext.createErrorMessage("bean_consumer_invalid_modify", new Object[0]);
        }
        this.beanContext.createErrorMessage("bean_consumer_cannot_modify_reg", new Object[0]);
        return null;
    }

    public String eraseLocalRegistration() {
        if (this.getConsumer() != null) {
            this.getProducerInfo().eraseRegistrationInfo();
            return "configureConsumer";
        }
        this.beanContext.createErrorMessage("bean_consumer_cannot_erase_reg", new Object[0]);
        return null;
    }

    private Object modifyIfNeeded(Object oldValue, Object newValue, String target, boolean checkURL) {
        if (this.isOldAndNewDifferent(oldValue, newValue)) {
            if (checkURL) {
                try {
                    new URL(newValue.toString());
                }
                catch (MalformedURLException e) {
                    this.beanContext.createTargetedErrorMessage(target, "bean_consumer_malformed_url", new Object[]{newValue, e.getLocalizedMessage()});
                }
            }
            oldValue = newValue;
            this.modified = true;
        }
        return oldValue;
    }

    protected String getObjectTypeName() {
        return "CONSUMER_TYPE";
    }

    public boolean isAlreadyExisting(String objectName) {
        return this.getRegistry().containsConsumer(objectName);
    }

    public ConsumerRegistry getRegistry() {
        return this.getManager().getRegistry();
    }

    public DataModel getPortlets() {
        try {
            if (this.portletHandles == null) {
                WSRPConsumer consumer = this.getConsumer();
                Collection portlets = consumer.getProducerInfo().getPortletMap().values();
                List selectableHandles = Collections.emptyList();
                if (ParameterValidation.existsAndIsNotEmpty(portlets)) {
                    selectableHandles = new ArrayList(portlets.size());
                    for (Portlet portlet : portlets) {
                        selectableHandles.add(new SelectablePortletHandle(portlet.getContext().getId(), consumer.getMigrationService().getStructureProvider()));
                    }
                }
                Collections.sort(selectableHandles);
                this.portletHandles = new ListDataModel(selectableHandles);
            }
            return this.portletHandles;
        }
        catch (PortletInvokerException e) {
            this.beanContext.createErrorMessageFrom((Exception)((Object)e));
            return null;
        }
    }

    public boolean isReadyForExport() {
        List handles = (List)this.getPortlets().getWrappedData();
        for (SelectablePortletHandle handle : handles) {
            if (!handle.isSelected()) continue;
            return true;
        }
        return false;
    }

    public String exportPortlets() {
        WSRPConsumer consumer = this.getConsumer();
        if (consumer != null) {
            List handles = (List)this.getPortlets().getWrappedData();
            ArrayList<String> selectedHandles = new ArrayList<String>(handles.size());
            for (SelectablePortletHandle selectablePortletHandle : handles) {
                if (!selectablePortletHandle.isSelected()) continue;
                selectedHandles.add(selectablePortletHandle.getHandle());
            }
            try {
                this.currentExport = new ExportInfoDisplay(consumer.exportPortlets(selectedHandles), this.beanContext.getLocale(), consumer.getMigrationService().getStructureProvider());
            }
            catch (Exception e) {
                this.beanContext.createErrorMessageFrom(e);
                return null;
            }
            return "exportDetail";
        }
        this.beanContext.createErrorMessage("bean_consumer_cannot_export", new Object[0]);
        return null;
    }

    public ExportInfoDisplay getCurrentExport() {
        return this.currentExport;
    }

    public DataModel getExistingExports() {
        if (this.existingExports == null) {
            Locale locale = this.beanContext.getLocale();
            MigrationService migrationService = this.getConsumer().getMigrationService();
            List availableExportInfos = migrationService.getAvailableExportInfos();
            ArrayList<ExportInfoDisplay> exportDisplays = new ArrayList<ExportInfoDisplay>(availableExportInfos.size());
            for (ExportInfo exportInfo : availableExportInfos) {
                exportDisplays.add(new ExportInfoDisplay(exportInfo, locale, migrationService.getStructureProvider()));
            }
            this.existingExports = new ListDataModel(exportDisplays);
        }
        return this.existingExports;
    }

    public String viewExport() {
        this.selectExport();
        return "exportDetail";
    }

    public String importPortlets() {
        List exportedPortlets = this.currentExport.getExportedPortlets();
        try {
            SortedMap errorCodesToFailedPortletHandlesMapping;
            ArrayList<SelectablePortletHandle> portletsToImport = new ArrayList<SelectablePortletHandle>(exportedPortlets.size());
            for (SelectablePortletHandle exportedPortlet : exportedPortlets) {
                if (!exportedPortlet.isSelected()) continue;
                portletsToImport.add(exportedPortlet);
            }
            WSRPConsumer consumer = this.getConsumer();
            ImportInfo info = consumer.importPortlets(this.currentExport.getExport(), WSRPUtils.transform(portletsToImport, (Function)SELECTABLE_TO_HANDLE));
            ConsumerStructureProvider structureProvider = consumer.getMigrationService().getStructureProvider();
            int importCount = 0;
            for (SelectablePortletHandle importedPortlet : portletsToImport) {
                String handle = importedPortlet.getHandle();
                PortletContext portletContext = info.getPortletContextFor(handle);
                if (portletContext == null) continue;
                structureProvider.assignPortletToWindow(portletContext, importedPortlet.getWindow(), importedPortlet.getPage(), handle);
                ++importCount;
            }
            if (importCount > 0) {
                this.beanContext.createLocalizedMessage("status", "bean_consumer_import_success", this.beanContext.getInfoSeverity(), new Object[]{importCount});
            }
            if (!(errorCodesToFailedPortletHandlesMapping = info.getErrorCodesToFailedPortletHandlesMapping()).isEmpty()) {
                for (Map.Entry entry : errorCodesToFailedPortletHandlesMapping.entrySet()) {
                    QName errorCode = (QName)entry.getKey();
                    for (String handle : (List)entry.getValue()) {
                        this.beanContext.createErrorMessage("bean_consumer_import_failed_portlets", new Object[]{handle + " (cause: " + errorCode + ")"});
                    }
                }
            }
            return "consumers";
        }
        catch (Exception e) {
            this.beanContext.createErrorMessageFrom(e);
            return null;
        }
    }

    public String deleteExport() {
        ExportInfo export = this.currentExport.getExport();
        WSRPConsumer consumer = this.getConsumer();
        if (consumer.getMigrationService().remove(export) == export) {
            try {
                consumer.releaseExport(export);
            }
            catch (PortletInvokerException e) {
                consumer.getMigrationService().add(export);
                this.beanContext.createErrorMessageFrom((Exception)((Object)e));
                return null;
            }
            this.existingExports = null;
            this.currentExport = null;
        }
        return "exports";
    }

    public void selectExport(ActionEvent actionEvent) {
        this.selectExport();
    }

    public void selectExport() {
        this.currentExport = (ExportInfoDisplay)this.getExistingExports().getRowData();
    }

    public boolean isImportExportSupported() {
        return this.isActive() && this.getConsumer().isImportExportSupported();
    }

    public boolean isAvailableExportInfosEmpty() {
        return this.getConsumer().getMigrationService().isAvailableExportInfosEmpty();
    }

    public boolean isWssEnabled() {
        return this.getProducerInfo().getEndpointConfigurationInfo().getWSSEnabled();
    }

    public boolean isWssAvailable() {
        return this.getProducerInfo().getEndpointConfigurationInfo().isWSSAvailable();
    }

    public void setWssEnabled(boolean enable) {
        this.getProducerInfo().getEndpointConfigurationInfo().setWSSEnabled(enable);
    }

    public WSRPConsumer getConsumer() {
        if (this.consumer == null) {
            this.resolveConsumer(this.id);
        }
        return this.consumer;
    }

    public void setConsumer(WSRPConsumer consumer) {
        this.consumer = consumer;
    }

    public ConsumerManagerBean getManager() {
        if (this.manager == null) {
            this.manager = (ConsumerManagerBean)this.beanContext.findBean("consumersMgr", ConsumerManagerBean.class);
        }
        return this.manager;
    }

    static /* synthetic */ void access$100() {
        ConsumerBean.bypassAndRedisplay();
    }
}

