/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.admin.ui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlDataTable;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import javax.faces.validator.ValidatorException;
import org.gatein.wsrp.admin.ui.LocalizedStringConverter;
import org.gatein.wsrp.admin.ui.ProducerBean;
import org.gatein.wsrp.admin.ui.WSRPManagedBean;
import org.gatein.wsrp.producer.config.ProducerConfiguration;
import org.gatein.wsrp.producer.config.ProducerConfigurationService;
import org.gatein.wsrp.producer.config.ProducerRegistrationRequirements;
import org.gatein.wsrp.registration.LocalizedString;
import org.gatein.wsrp.registration.RegistrationPropertyDescription;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProducerBean
extends WSRPManagedBean
implements Serializable {
    private static final String REGISTRATION_PROPERTY_TYPE = "REGISTRATION_PROPERTY_TYPE";
    private transient ProducerConfigurationService configurationService;
    private static final String PROPERTY = "property";
    private static final String PRODUCER = "producer";
    private String selectedProp;
    private transient LocalProducerConfiguration localProducerConfiguration;

    public ProducerConfigurationService getConfigurationService() {
        if (this.configurationService == null) {
            this.configurationService = (ProducerConfigurationService)this.beanContext.findBean("ProducerConfigurationService", ProducerConfigurationService.class);
        }
        return this.configurationService;
    }

    public void setConfigurationService(ProducerConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public ProducerConfiguration getConfiguration() {
        return this.getConfigurationService().getConfiguration();
    }

    public boolean isRegistrationRequiredForFullDescription() {
        return this.getLocalConfiguration().isRegistrationRequiredForFullDescription();
    }

    public void setRegistrationRequiredForFullDescription(boolean requireRegForFullDescription) {
        this.getLocalConfiguration().setRegistrationRequiredForFullDescription(requireRegForFullDescription);
    }

    public boolean isRegistrationRequired() {
        return this.getLocalConfiguration().isRegistrationRequired();
    }

    public void setRegistrationRequired(boolean requireRegistration) {
        this.getLocalConfiguration().setRegistrationRequired(requireRegistration);
    }

    public boolean isStrictMode() {
        return this.getLocalConfiguration().isUsingStrictMode();
    }

    public void setStrictMode(boolean strictMode) {
        this.getLocalConfiguration().setUsingStrictMode(strictMode);
    }

    public List<RegistrationPropertyDescription> getRegistrationProperties() {
        ArrayList<RegistrationPropertyDescription> propertyDescriptions = new ArrayList<RegistrationPropertyDescription>(this.getLocalConfiguration().getRegistrationProperties().values());
        Collections.sort(propertyDescriptions);
        return propertyDescriptions;
    }

    public boolean isRegistrationPropertiesEmpty() {
        return this.getLocalConfiguration().getRegistrationProperties().isEmpty();
    }

    public List<SelectItem> getSupportedPropertyTypes() {
        return Collections.singletonList(new SelectItem((Object)"xsd:string"));
    }

    public String getSelectedPropertyName() {
        return this.selectedProp;
    }

    public String save() {
        try {
            ProducerConfiguration currentlyPersistedConfiguration = this.getConfiguration();
            LocalProducerConfiguration localConfiguration = this.getLocalConfiguration();
            ProducerRegistrationRequirements registrationRequirements = currentlyPersistedConfiguration.getRegistrationRequirements();
            registrationRequirements.setRegistrationRequiredForFullDescription(localConfiguration.isRegistrationRequiredForFullDescription());
            registrationRequirements.setRegistrationRequired(localConfiguration.isRegistrationRequired());
            registrationRequirements.reloadPolicyFrom(localConfiguration.getRegistrationPolicyClassName(), localConfiguration.getValidatorClassName());
            registrationRequirements.setRegistrationProperties(localConfiguration.getRegistrationProperties());
            currentlyPersistedConfiguration.setUsingStrictMode(localConfiguration.isUsingStrictMode());
            this.getConfigurationService().saveConfiguration();
            this.localProducerConfiguration = null;
            this.beanContext.createInfoMessage("bean_producer_save_success");
        }
        catch (Exception e) {
            this.log.debug("Couldn't save producer", (Throwable)e);
            this.beanContext.createErrorMessage("bean_producer_cannot_save", new Object[]{e.getLocalizedMessage()});
        }
        return "producer";
    }

    public String reloadConfiguration() {
        try {
            this.getConfigurationService().reloadConfiguration();
            this.localProducerConfiguration = null;
            this.beanContext.createInfoMessage("bean_producer_cancel_success");
        }
        catch (Exception e) {
            this.log.debug("Couldn't reload producer configuration", (Throwable)e);
            this.beanContext.createErrorMessage("bean_producer_cannot_reload", new Object[]{e.getLocalizedMessage()});
        }
        return "producer";
    }

    public String addRegistrationProperty() {
        this.getLocalConfiguration().addEmptyRegistrationProperty("property" + System.currentTimeMillis());
        return "producer";
    }

    public String deleteRegistrationProperty() {
        this.getLocalConfiguration().removeRegistrationProperty(this.selectedProp);
        return "producer";
    }

    public void requireRegistrationListener(ValueChangeEvent event) {
        this.setRegistrationRequired(((Boolean)event.getNewValue()).booleanValue());
        ProducerBean.bypassAndRedisplay();
    }

    public void strictModeListener(ValueChangeEvent event) {
        this.setStrictMode(((Boolean)event.getNewValue()).booleanValue());
        ProducerBean.bypassAndRedisplay();
    }

    public void requireRegistrationForFullDescListener(ValueChangeEvent event) {
        this.setRegistrationRequiredForFullDescription(((Boolean)event.getNewValue()).booleanValue());
        ProducerBean.bypassAndRedisplay();
    }

    public void selectProperty(ActionEvent event) {
        HtmlDataTable table = this.getParentDataTable((UIComponent)event.getSource());
        RegistrationPropertyDescription prop = (RegistrationPropertyDescription)table.getRowData();
        this.selectedProp = prop.getNameAsString();
    }

    private HtmlDataTable getParentDataTable(UIComponent component) {
        if (component == null) {
            return null;
        }
        if (component instanceof HtmlDataTable) {
            return (HtmlDataTable)component;
        }
        return this.getParentDataTable(component.getParent());
    }

    protected String getObjectTypeName() {
        return "REGISTRATION_PROPERTY_TYPE";
    }

    public boolean isAlreadyExisting(String objectName) {
        return false;
    }

    private LocalProducerConfiguration getLocalConfiguration() {
        if (this.localProducerConfiguration == null) {
            this.localProducerConfiguration = new LocalProducerConfiguration(null);
            ProducerConfiguration configuration = this.getConfiguration();
            this.localProducerConfiguration.initFrom(configuration.getRegistrationRequirements(), configuration.isUsingStrictMode());
        }
        return this.localProducerConfiguration;
    }

    public String getV1WSDL() {
        return this.beanContext.getServerAddress() + "/wsrp-producer/v1/MarkupService?wsdl";
    }

    public String getV2WSDL() {
        return this.beanContext.getServerAddress() + "/wsrp-producer/v2/MarkupService?wsdl";
    }

    public void validate(FacesContext facesContext, UIComponent uiComponent, Object o) {
        String toValidate = null;
        if (o instanceof String) {
            toValidate = (String)o;
        } else if (o instanceof LocalizedString) {
            toValidate = LocalizedStringConverter.getAsString((Object)o);
        }
        String validated = this.checkNameValidity(toValidate, uiComponent.getClientId(facesContext));
        if (validated == null) {
            throw new ValidatorException(new FacesMessage());
        }
    }

    public List<SelectItem> getAvailableRegistrationPolicies() {
        return ProducerBean.getSelectItemsFrom((List)this.localProducerConfiguration.getRegistrationRequirements().getAvailableRegistrationPolicies());
    }

    public void policyChangeListener(ValueChangeEvent event) {
        this.getLocalConfiguration().setRegistrationPolicyClassName((String)event.getNewValue());
        ProducerBean.bypassAndRedisplay();
    }

    public String getRegistrationPolicyClassName() {
        return this.getLocalConfiguration().getRegistrationPolicyClassName();
    }

    public void setRegistrationPolicyClassName(String policyClassName) {
        this.getLocalConfiguration().setRegistrationPolicyClassName(policyClassName);
    }

    public boolean isDefaultRegistrationPolicy() {
        return this.getLocalConfiguration().isDefaultRegistrationPolicy();
    }

    public String getValidatorClassName() {
        return this.getLocalConfiguration().getValidatorClassName();
    }

    public void setValidatorClassName(String validatorClassName) {
        this.getLocalConfiguration().setValidatorClassName(validatorClassName);
    }

    public List<SelectItem> getAvailableValidators() {
        return ProducerBean.getSelectItemsFrom((List)this.localProducerConfiguration.getRegistrationRequirements().getAvailableRegistrationPropertyValidators());
    }
}

