/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.admin.ui;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import javax.faces.validator.ValidatorException;
import org.gatein.wsrp.admin.ui.LocalizedStringConverter;
import org.gatein.wsrp.admin.ui.ProducerBean;
import org.gatein.wsrp.admin.ui.WSRPManagedBean;
import org.gatein.wsrp.producer.config.ProducerConfiguration;
import org.gatein.wsrp.producer.config.ProducerConfigurationService;
import org.gatein.wsrp.producer.config.ProducerRegistrationRequirements;
import org.gatein.wsrp.registration.LocalizedString;
import org.gatein.wsrp.registration.RegistrationPropertyDescription;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProducerBean
extends WSRPManagedBean
implements Serializable {
    private static final String REGISTRATION_PROPERTY_TYPE = "REGISTRATION_PROPERTY_TYPE";
    private static final String SELECTED_PROP = "selectedProp";
    private static final String PROPERTY = "property";
    private static final String CURRENT_CONFIG = "currentConfig";
    private transient ProducerConfigurationService configurationService;
    private LocalProducerConfiguration localProducerConfiguration;

    @PostConstruct
    public void init() {
        if (this.localProducerConfiguration == null) {
            this.localProducerConfiguration = (LocalProducerConfiguration)this.beanContext.getFromSession("currentConfig", LocalProducerConfiguration.class);
            if (this.localProducerConfiguration == null) {
                this.localProducerConfiguration = new LocalProducerConfiguration(null);
                ProducerConfiguration configuration = this.getConfiguration();
                this.localProducerConfiguration.initFrom(configuration.getRegistrationRequirements(), configuration.isUsingStrictMode());
            } else {
                this.beanContext.removeFromSession("currentConfig", new String[0]);
            }
        }
    }

    public ProducerConfigurationService getConfigurationService() {
        if (this.configurationService == null) {
            this.configurationService = (ProducerConfigurationService)this.beanContext.findBean("ProducerConfigurationService", ProducerConfigurationService.class);
        }
        return this.configurationService;
    }

    public void setConfigurationService(ProducerConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public ProducerConfiguration getConfiguration() {
        return this.getConfigurationService().getConfiguration();
    }

    public boolean isRegistrationRequiredForFullDescription() {
        return this.getLocalConfiguration().isRegistrationRequiredForFullDescription();
    }

    public void setRegistrationRequiredForFullDescription(boolean requireRegForFullDescription) {
        this.getLocalConfiguration().setRegistrationRequiredForFullDescription(requireRegForFullDescription);
    }

    public boolean isRegistrationRequired() {
        return this.getLocalConfiguration().isRegistrationRequired();
    }

    public void setRegistrationRequired(boolean requireRegistration) {
        this.getLocalConfiguration().setRegistrationRequired(requireRegistration);
    }

    public boolean isStrictMode() {
        return this.getLocalConfiguration().isUsingStrictMode();
    }

    public void setStrictMode(boolean strictMode) {
        this.getLocalConfiguration().setUsingStrictMode(strictMode);
    }

    public List<RegistrationPropertyDescription> getRegistrationProperties() {
        return this.getLocalConfiguration().getRegistrationProperties();
    }

    public boolean isRegistrationPropertiesEmpty() {
        return this.getLocalConfiguration().getRegistrationProperties().isEmpty();
    }

    public List<SelectItem> getSupportedPropertyTypes() {
        return Collections.singletonList(new SelectItem((Object)"xsd:string"));
    }

    public String save() {
        try {
            ProducerConfiguration currentlyPersistedConfiguration = this.getConfiguration();
            LocalProducerConfiguration localConfiguration = this.getLocalConfiguration();
            ProducerRegistrationRequirements registrationRequirements = currentlyPersistedConfiguration.getRegistrationRequirements();
            registrationRequirements.setRegistrationRequiredForFullDescription(localConfiguration.isRegistrationRequiredForFullDescription());
            registrationRequirements.setRegistrationRequired(localConfiguration.isRegistrationRequired());
            registrationRequirements.reloadPolicyFrom(localConfiguration.getRegistrationPolicyClassName(), localConfiguration.getValidatorClassName());
            registrationRequirements.setRegistrationProperties((Collection)localConfiguration.getRegistrationProperties());
            currentlyPersistedConfiguration.setUsingStrictMode(localConfiguration.isUsingStrictMode());
            this.getConfigurationService().saveConfiguration();
            this.localProducerConfiguration = null;
            this.beanContext.createInfoMessage("bean_producer_save_success");
        }
        catch (Exception e) {
            this.log.debug("Couldn't save producer", (Throwable)e);
            this.beanContext.createErrorMessage("bean_producer_cannot_save", new Object[]{e.getLocalizedMessage()});
        }
        return null;
    }

    public String reloadConfiguration() {
        try {
            this.getConfigurationService().reloadConfiguration();
            this.localProducerConfiguration = null;
            this.beanContext.createInfoMessage("bean_producer_cancel_success");
        }
        catch (Exception e) {
            this.log.debug("Couldn't reload producer configuration", (Throwable)e);
            this.beanContext.createErrorMessage("bean_producer_cannot_reload", new Object[]{e.getLocalizedMessage()});
        }
        return null;
    }

    public String addRegistrationProperty() {
        this.getLocalConfiguration().addEmptyRegistrationProperty("property" + System.currentTimeMillis());
        return null;
    }

    public String confirmPropDeletion(String selectedProp) {
        this.beanContext.replaceInSession("selectedProp", (Object)selectedProp);
        this.beanContext.replaceInSession("currentConfig", (Object)this.getLocalConfiguration());
        return "confirmPropDeletion";
    }

    public String deleteRegistrationProperty() {
        String propertyName = (String)this.beanContext.getFromSession("selectedProp", String.class);
        if (propertyName != null) {
            this.getLocalConfiguration().removeRegistrationProperty(propertyName);
            this.beanContext.replaceInSession("currentConfig", (Object)this.getLocalConfiguration());
        }
        this.beanContext.removeFromSession("selectedProp", new String[0]);
        return "producer";
    }

    public void requireRegistrationListener(ValueChangeEvent event) {
        this.setRegistrationRequired(((Boolean)event.getNewValue()).booleanValue());
        ProducerBean.bypassAndRedisplay();
    }

    public void strictModeListener(ValueChangeEvent event) {
        this.setStrictMode(((Boolean)event.getNewValue()).booleanValue());
        ProducerBean.bypassAndRedisplay();
    }

    public void requireRegistrationForFullDescListener(ValueChangeEvent event) {
        this.setRegistrationRequiredForFullDescription(((Boolean)event.getNewValue()).booleanValue());
        ProducerBean.bypassAndRedisplay();
    }

    protected String getObjectTypeName() {
        return "REGISTRATION_PROPERTY_TYPE";
    }

    public boolean isAlreadyExisting(String objectName) {
        return false;
    }

    private LocalProducerConfiguration getLocalConfiguration() {
        this.init();
        return this.localProducerConfiguration;
    }

    public String getV1WSDL() {
        return this.beanContext.getServerAddress() + "/wsrp-producer/v1/MarkupService?wsdl";
    }

    public String getV2WSDL() {
        return this.beanContext.getServerAddress() + "/wsrp-producer/v2/MarkupService?wsdl";
    }

    public void validate(FacesContext facesContext, UIComponent uiComponent, Object o) {
        String toValidate = null;
        if (o instanceof String) {
            toValidate = (String)o;
        } else if (o instanceof LocalizedString) {
            toValidate = LocalizedStringConverter.getAsString((Object)o);
        }
        String validated = this.checkNameValidity(toValidate, uiComponent.getClientId(facesContext));
        if (validated == null) {
            throw new ValidatorException(new FacesMessage());
        }
    }

    public List<SelectItem> getAvailableRegistrationPolicies() {
        return ProducerBean.getSelectItemsFrom((List)this.getConfiguration().getRegistrationRequirements().getAvailableRegistrationPolicies());
    }

    public void policyChangeListener(ValueChangeEvent event) {
        this.getLocalConfiguration().setRegistrationPolicyClassName((String)event.getNewValue());
        ProducerBean.bypassAndRedisplay();
    }

    public String getRegistrationPolicyClassName() {
        return this.getLocalConfiguration().getRegistrationPolicyClassName();
    }

    public void setRegistrationPolicyClassName(String policyClassName) {
        this.getLocalConfiguration().setRegistrationPolicyClassName(policyClassName);
    }

    public boolean isDefaultRegistrationPolicy() {
        return this.getLocalConfiguration().isDefaultRegistrationPolicy();
    }

    public String getValidatorClassName() {
        return this.getLocalConfiguration().getValidatorClassName();
    }

    public void setValidatorClassName(String validatorClassName) {
        this.getLocalConfiguration().setValidatorClassName(validatorClassName);
    }

    public List<SelectItem> getAvailableValidators() {
        return ProducerBean.getSelectItemsFrom((List)this.getConfiguration().getRegistrationRequirements().getAvailableRegistrationPropertyValidators());
    }
}

