/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.admin.ui;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.gatein.common.util.ParameterValidation;
import org.gatein.wsrp.WSRPConsumer;
import org.gatein.wsrp.admin.ui.WSRPManagedBean;
import org.gatein.wsrp.consumer.ProducerInfo;
import org.gatein.wsrp.consumer.RefreshResult;
import org.gatein.wsrp.consumer.RegistrationInfo;
import org.gatein.wsrp.consumer.registry.ConsumerRegistry;

public class ConsumerManagerBean
extends WSRPManagedBean
implements Serializable {
    private transient ConsumerRegistry registry;
    private String selectedId;
    private static final String NO_CONSUMER = "bean_consumermanager_no_consumer";
    private static final String INVALID_NEW_CONSUMER_NAME = "bean_consumermanager_invalid_new_consumer_name";
    private static final String REFRESH_BYPASSED = "bean_consumermanager_refresh_bypassed";
    private static final String REFRESH_SUCCESS = "bean_consumermanager_refresh_success";
    private static final String REFRESH_FAILURE = "bean_consumermanager_refresh_failure";
    private static final String REFRESH_FAILURE_WSDL = "bean_consumermanager_refresh_failure_wsdl";
    private static final String REFRESH_EXCEPTION = "bean_consumermanager_refresh_exception";
    static final String CONFIGURE_CONSUMER = "configureConsumer";
    static final String EXPORT = "export";
    static final String EXPORTS = "exports";
    static final String EXPORT_DETAIL = "exportDetail";
    static final String IMPORT = "import";
    static final String CONSUMERS = "consumers";
    static final String EXPECTED_REG_INFO_KEY = "expectedRegistrationInfo";
    static final String REFRESH_MODIFY = "bean_consumermanager_refresh_modify";
    static final String REQUESTED_CONSUMER_ID = "id";
    static final String SESSION_CONSUMER_ID = "consumerId";
    private static final String MESSAGE_TARGET = "add-consumer:createConsumer:consumerName";

    public ConsumerRegistry getRegistry() {
        if (this.registry == null) {
            this.registry = (ConsumerRegistry)this.beanContext.findBean("ConsumerRegistry", ConsumerRegistry.class);
        }
        return this.registry;
    }

    public void setRegistry(ConsumerRegistry registry) {
        this.registry = registry;
    }

    public void setSelectedId(String consumerId) {
        this.selectedId = consumerId;
    }

    public String getSelectedId() {
        return this.selectedId;
    }

    public WSRPConsumer getSelectedConsumer() {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)this.selectedId, (String)"consumer id", null);
        return this.getRegistry().getConsumer(this.selectedId);
    }

    public boolean isConsumersEmpty() {
        return this.getRegistry().getConfiguredConsumerNumber() == 0;
    }

    public List<WSRPConsumer> getConsumers() {
        return this.getRegistry().getConfiguredConsumers();
    }

    public String reload() {
        this.getRegistry().reloadConsumers();
        return null;
    }

    public String activateConsumer() {
        if (this.refreshConsumerId() != null) {
            boolean activate = Boolean.valueOf(this.beanContext.getParameter("activate"));
            try {
                if (activate) {
                    WSRPConsumer consumer = this.getSelectedConsumer();
                    if (consumer.isRefreshNeeded()) {
                        RefreshResult result = this.internalRefresh(consumer);
                        if (result != null && !result.hasIssues()) {
                            this.getRegistry().activateConsumerWith(this.selectedId);
                        }
                    } else {
                        this.getRegistry().activateConsumerWith(this.selectedId);
                    }
                } else {
                    this.getRegistry().deactivateConsumerWith(this.selectedId);
                }
            }
            catch (Exception e) {
                this.beanContext.createErrorMessageFrom(e);
            }
            return this.listConsumers();
        }
        this.noSelectedConsumerError();
        return this.listConsumers();
    }

    public String registerConsumer() {
        if (this.refreshConsumerId() != null) {
            boolean register = Boolean.valueOf(this.beanContext.getParameter("register"));
            try {
                this.getRegistry().registerOrDeregisterConsumerWith(this.selectedId, register);
                return CONFIGURE_CONSUMER;
            }
            catch (Exception e) {
                this.beanContext.createErrorMessageFrom(e);
                return null;
            }
        }
        this.noSelectedConsumerError();
        return null;
    }

    public String createConsumer() {
        this.selectedId = this.checkNameValidity(this.selectedId, MESSAGE_TARGET);
        if (this.selectedId != null) {
            try {
                this.getRegistry().createConsumer(this.selectedId, ProducerInfo.DEFAULT_CACHE_VALUE, null);
                return CONFIGURE_CONSUMER;
            }
            catch (Exception e) {
                this.selectedId = null;
                this.beanContext.createErrorMessageFrom(MESSAGE_TARGET, e);
                return null;
            }
        }
        return null;
    }

    public String destroyConsumer() {
        if (this.refreshConsumerId() != null) {
            try {
                this.getRegistry().destroyConsumer(this.selectedId);
                return this.listConsumers();
            }
            catch (Exception e) {
                this.beanContext.createErrorMessageFrom(e);
                return null;
            }
        }
        this.noSelectedConsumerError();
        return null;
    }

    public String configureConsumer() {
        if (this.refreshConsumerId() != null) {
            return CONFIGURE_CONSUMER;
        }
        this.noSelectedConsumerError();
        return null;
    }

    public String refreshConsumer() {
        if (this.refreshConsumerId() != null) {
            this.internalRefresh(this.getSelectedConsumer());
            return this.configureConsumer();
        }
        this.noSelectedConsumerError();
        return null;
    }

    public String importPortlets() {
        if (this.refreshConsumerId() != null) {
            return EXPORTS;
        }
        this.noSelectedConsumerError();
        return null;
    }

    public String exportPortlets() {
        if (this.refreshConsumerId() != null) {
            return EXPORT;
        }
        this.noSelectedConsumerError();
        return null;
    }

    private RefreshResult internalRefresh(WSRPConsumer consumer) {
        try {
            RefreshResult result = consumer.refresh(true);
            String statusMessage = this.getLocalizationKeyFrom(result);
            if (result.hasIssues()) {
                RegistrationInfo expected = new RegistrationInfo(consumer.getProducerInfo().getRegistrationInfo());
                expected.refresh(result.getServiceDescription(), consumer.getProducerId(), true, true, true);
                this.setExpectedRegistrationInfo(expected);
                this.beanContext.createErrorMessage(statusMessage, new Object[0]);
                this.getRegistry().deactivateConsumerWith(consumer.getProducerId());
            } else {
                if (consumer.isActive()) {
                    this.getRegistry().activateConsumerWith(consumer.getProducerId());
                } else {
                    this.getRegistry().deactivateConsumerWith(consumer.getProducerId());
                }
                this.beanContext.createInfoMessage(statusMessage);
            }
            return result;
        }
        catch (Exception e) {
            this.beanContext.createErrorMessageFrom(e);
            return null;
        }
    }

    private String getLocalizationKeyFrom(RefreshResult result) {
        RefreshResult.Status status = result.getStatus();
        if (RefreshResult.Status.BYPASSED.equals((Object)status)) {
            return REFRESH_BYPASSED;
        }
        if (RefreshResult.Status.SUCCESS.equals((Object)status)) {
            return REFRESH_SUCCESS;
        }
        if (RefreshResult.Status.FAILURE.equals((Object)status)) {
            RefreshResult registrationResult = result.getRegistrationResult();
            if (registrationResult != null) {
                return REFRESH_FAILURE;
            }
            return REFRESH_FAILURE_WSDL;
        }
        if (RefreshResult.Status.MODIFY_REGISTRATION_REQUIRED.equals((Object)status)) {
            return REFRESH_MODIFY;
        }
        return REFRESH_EXCEPTION;
    }

    RefreshResult refresh(WSRPConsumer consumer) {
        RefreshResult result = this.internalRefresh(consumer);
        this.selectedId = consumer.getProducerId();
        return result;
    }

    private void setExpectedRegistrationInfo(RegistrationInfo expected) {
        Map sessionMap = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        sessionMap.put(EXPECTED_REG_INFO_KEY, expected);
    }

    public String listConsumers() {
        this.selectedId = null;
        return null;
    }

    public void selectConsumer(ActionEvent actionEvent) {
        this.refreshConsumerId();
    }

    private String refreshConsumerId() {
        this.selectedId = this.beanContext.getParameter(REQUESTED_CONSUMER_ID);
        return this.selectedId;
    }

    private void noSelectedConsumerError() {
        this.beanContext.createErrorMessage(NO_CONSUMER, new Object[0]);
    }

    protected String getObjectTypeName() {
        return "CONSUMER_TYPE";
    }

    public boolean isAlreadyExisting(String objectName) {
        return this.getRegistry().containsConsumer(objectName);
    }
}

