/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.admin.ui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.gatein.common.util.ParameterValidation;
import org.gatein.wsrp.admin.ui.BeanContext;
import org.gatein.wsrp.admin.ui.WSRPManagedBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WSRPManagedBean
implements Serializable {
    protected transient Logger log = LoggerFactory.getLogger(this.getClass());
    protected BeanContext beanContext;
    private String cancelOutcome;
    public static final String INVALID_NAME = "INVALID_NAME_ERROR";
    public static final String INVALID_PATH = "INVALID_PATH_ERROR";
    public static final String DUPLICATE = "DUPLICATE_ERROR";
    private PropertyValidator validator = new DefaultPropertyValidator(this);

    static void bypassAndRedisplay() {
        FacesContext.getCurrentInstance().renderResponse();
    }

    protected void setValidator(PropertyValidator validator) {
        this.validator = validator;
    }

    protected PropertyValidator getValidator() {
        return this.validator;
    }

    public void setBeanContext(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    public void setCancelOutcome(String cancelOutcome) {
        this.cancelOutcome = cancelOutcome;
    }

    public String checkAndReturnValueIfValid(String value, String targetForErrorMessage) {
        return this.checkAndReturnValueIfValid(value, targetForErrorMessage, this.validator);
    }

    public String checkAndReturnValueIfValid(String value, String targetForErrorMessage, PropertyValidator validator) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)validator, (String)"PropertyValidator");
        String objectTypeName = validator.getTypeOfValidatedValues();
        if (ParameterValidation.isNullOrEmpty((String)value)) {
            this.beanContext.createTargetedErrorMessage(targetForErrorMessage, validator.getErrorKey(), new Object[]{value, this.getLocalizedType(objectTypeName)});
            return null;
        }
        String original = value;
        if ((value = validator.checkForInvalidCharacters(value)) == null) {
            this.beanContext.createTargetedErrorMessage(targetForErrorMessage, validator.getErrorKey(), new Object[]{original, this.getLocalizedType(objectTypeName)});
            return null;
        }
        value = value.trim();
        if ((value = ParameterValidation.sanitizeFromPatternWithHandler((String)value, (Pattern)validator.getValidationPattern(), (ParameterValidation.ValidationErrorHandler)validator.getValidationErrorHandler(value, targetForErrorMessage))) == null) {
            return null;
        }
        if (validator.checkForDuplicates() && validator.isAlreadyExisting(value)) {
            this.getDuplicateErrorMessage(value, targetForErrorMessage, objectTypeName);
            return null;
        }
        return value;
    }

    protected void getDuplicateErrorMessage(String value, String targetForErrorMessage, String objectTypeName) {
        this.beanContext.createTargetedErrorMessage(targetForErrorMessage, DUPLICATE, new Object[]{value, this.getLocalizedType(objectTypeName)});
    }

    private String getLocalizedType(String objectTypeName) {
        return this.beanContext.getMessageFromBundle(objectTypeName, new Object[0]);
    }

    protected abstract String getObjectTypeName();

    public abstract boolean isAlreadyExisting(String var1);

    public boolean isOldAndNewDifferent(Object oldValue, Object newValue) {
        oldValue = this.normalizeStringIfNeeded(oldValue);
        newValue = this.normalizeStringIfNeeded(newValue);
        return oldValue != null && !oldValue.equals(newValue) || oldValue == null && newValue != null;
    }

    public Object normalizeStringIfNeeded(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            return stringValue.length() == 0 ? null : stringValue.trim();
        }
        return value;
    }

    public String cancel() {
        return this.cancelOutcome;
    }

    protected static List<SelectItem> getSelectItemsFrom(List<String> identifiers) {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>(identifiers.size());
        for (String pageIdentifier : identifiers) {
            result.add(new SelectItem((Object)pageIdentifier));
        }
        return result;
    }

    static /* synthetic */ String access$000(WSRPManagedBean x0, String x1) {
        return x0.getLocalizedType(x1);
    }
}

