/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gatein.common.NotYetImplemented;
import org.gatein.common.text.FastURLDecoder;
import org.gatein.common.util.Tools;
import org.gatein.pc.api.ActionURL;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.ParametersStateString;
import org.gatein.pc.api.PortletURL;
import org.gatein.pc.api.RenderURL;
import org.gatein.pc.api.ResourceURL;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.WindowState;
import org.gatein.wsrp.WSRPActionURL;
import org.gatein.wsrp.WSRPRenderURL;
import org.gatein.wsrp.WSRPResourceURL;
import org.gatein.wsrp.WSRPUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WSRPPortletURL
implements PortletURL {
    private static final Logger log = LoggerFactory.getLogger(WSRPPortletURL.class);
    private static final String EQUALS = "=";
    private static final String ENCODED_AMPERSAND = "&amp;";
    private static final String AMPERSAND = "&";
    private static final String AMP_AMP = "&amp;amp;";
    private static final String PARAM_SEPARATOR = "|";
    private static final int URL_TYPE_END = "wsrp-urlType".length() + "=".length();
    private boolean secure;
    private Mode mode;
    private WindowState windowState;
    protected static boolean strict = true;
    private Map<String, String> extraParams;
    protected String extra;
    private boolean extraParamsAfterEndToken = false;

    public static void setStrict(boolean strict) {
        WSRPPortletURL.strict = strict;
        log.debug("Using " + (strict ? "strict" : "lenient") + " rewriting parameters validation mode.");
    }

    public static WSRPPortletURL create(PortletURL portletURL, boolean secure) {
        WSRPPortletURL url;
        if (portletURL == null) {
            throw new IllegalArgumentException("Cannot construct a WSRPPortletURL from a null PortletURL!");
        }
        Mode mode = portletURL.getMode();
        WindowState windowState = portletURL.getWindowState();
        if (portletURL instanceof ActionURL) {
            StateString interactionState = ((ActionURL)portletURL).getInteractionState();
            StateString navigationalState = ((ActionURL)portletURL).getNavigationalState();
            url = new WSRPActionURL(mode, windowState, secure, navigationalState, interactionState);
        } else if (portletURL instanceof RenderURL) {
            StateString navigationalState = ((RenderURL)portletURL).getNavigationalState();
            url = new WSRPRenderURL(mode, windowState, secure, navigationalState);
        } else {
            if (portletURL instanceof ResourceURL) {
                throw new NotYetImplemented("ResourceURL support not quite yet implemented!");
            }
            throw new IllegalArgumentException("Unknown PortletURL type: " + portletURL.getClass().getName());
        }
        if (strict && portletURL instanceof WSRPPortletURL) {
            WSRPPortletURL other = (WSRPPortletURL)portletURL;
            url.setParams(other.extraParams, other.toString());
            url.setExtra(other.extra);
        }
        return url;
    }

    public static WSRPPortletURL create(String encodedURL, Set<String> customModes, Set<String> customWindowStates) {
        WSRPPortletURL url;
        String urlType;
        log.debug("Trying to build a WSRPPortletURL from <" + encodedURL + ">");
        if (encodedURL == null || encodedURL.length() == 0) {
            throw new IllegalArgumentException("Cannot construct a WSRPPortletURL from a null or empty URL!");
        }
        String originalURL = encodedURL;
        boolean extraAfterEnd = false;
        String extra = null;
        if (!encodedURL.startsWith("wsrp_rewrite?")) {
            throw new IllegalArgumentException(encodedURL + " does not start with " + "wsrp_rewrite?");
        }
        if (!encodedURL.endsWith("/wsrp_rewrite")) {
            int endTokenIndex = (encodedURL = encodedURL.substring(13)).indexOf(47);
            if (endTokenIndex < 0) {
                throw new IllegalArgumentException(originalURL + " does not contain " + "/wsrp_rewrite");
            }
            encodedURL = encodedURL.substring(0, endTokenIndex) + encodedURL.substring(endTokenIndex + 13);
            int concatenationIndex = encodedURL.indexOf(47);
            if (strict && concatenationIndex != endTokenIndex) {
                throw new IllegalArgumentException(encodedURL + " does not end with " + "/wsrp_rewrite" + " or does not appear to be a valid concatenation of URLs.");
            }
            if (concatenationIndex != -1) {
                String tmp = encodedURL;
                encodedURL = encodedURL.substring(0, concatenationIndex);
                extra = tmp.substring(concatenationIndex);
            }
            extraAfterEnd = true;
        } else {
            encodedURL = encodedURL.substring(13, encodedURL.length() - 13);
        }
        if (!encodedURL.startsWith("wsrp-urlType=")) {
            throw new IllegalArgumentException(originalURL + " does not specify a URL type.");
        }
        if (encodedURL.contains(AMP_AMP)) {
            throw new IllegalArgumentException(encodedURL + " contains a doubly encoded &!");
        }
        encodedURL = Tools.replace((String)encodedURL, (String)ENCODED_AMPERSAND, (String)PARAM_SEPARATOR);
        encodedURL = Tools.replace((String)encodedURL, (String)AMPERSAND, (String)PARAM_SEPARATOR);
        if ((encodedURL = encodedURL.substring(URL_TYPE_END)).startsWith("render")) {
            urlType = "render";
            url = new WSRPRenderURL();
        } else if (encodedURL.startsWith("blockingAction")) {
            urlType = "blockingAction";
            url = new WSRPActionURL();
        } else if (encodedURL.startsWith("resource")) {
            log.debug("Using experimental resource URL support...");
            urlType = "resource";
            url = new WSRPResourceURL();
        } else {
            throw new IllegalArgumentException("Unrecognized URL type: " + encodedURL.substring(0, encodedURL.indexOf(PARAM_SEPARATOR)) + "in " + originalURL);
        }
        Map<String, String> params = null;
        int urlTypeLength = urlType.length();
        if (encodedURL.length() > urlTypeLength) {
            encodedURL = encodedURL.substring(urlTypeLength + PARAM_SEPARATOR.length());
            params = WSRPPortletURL.extractParams(encodedURL, originalURL, customModes, customWindowStates);
        } else if ("resource".equals(urlType)) {
            throw new IllegalArgumentException("Both the 'wsrp-url' and 'wsrp-requiresRewrite' parameters MUST also be specified for resource URL '" + originalURL + "'");
        }
        url.setParams(params, originalURL);
        url.setExtraParamsAfterEndToken(extraAfterEnd);
        url.setExtra(extra);
        return url;
    }

    public static WSRPPortletURL create(String encodedURL) {
        return WSRPPortletURL.create(encodedURL, Collections.<String>emptySet(), Collections.<String>emptySet());
    }

    protected WSRPPortletURL(Mode mode, WindowState windowState, boolean secure) {
        this.mode = mode;
        this.windowState = windowState;
        this.secure = secure;
    }

    protected WSRPPortletURL() {
    }

    protected final void setParams(Map<String, String> params, String originalURL) {
        this.dealWithSpecificParams(params, originalURL);
        if (!strict) {
            this.extraParams = new HashMap<String, String>();
            this.extraParams.putAll(params);
        }
    }

    protected void dealWithSpecificParams(Map<String, String> params, String originalURL) {
        String paramValue = this.getRawParameterValueFor(params, "wsrp-mode");
        if (paramValue != null) {
            this.mode = WSRPUtils.getJSR168PortletModeFromWSRPName(paramValue);
            params.remove("wsrp-mode");
        }
        if ((paramValue = this.getRawParameterValueFor(params, "wsrp-windowState")) != null) {
            this.windowState = WSRPUtils.getJSR168WindowStateFromWSRPName(paramValue);
            params.remove("wsrp-windowState");
        }
        if ((paramValue = this.getRawParameterValueFor(params, "wsrp-secureURL")) != null) {
            this.secure = Boolean.valueOf(paramValue);
            params.remove("wsrp-secureURL");
        }
    }

    protected String getRawParameterValueFor(Map params, String parameterName) {
        if (params != null) {
            return (String)params.get(parameterName);
        }
        return null;
    }

    public Mode getMode() {
        return this.mode;
    }

    public WindowState getWindowState() {
        return this.windowState;
    }

    public boolean isSecure() {
        return this.secure;
    }

    protected abstract String getURLType();

    public String toString() {
        StringBuffer sb = new StringBuffer(255);
        sb.append("wsrp_rewrite?").append("wsrp-urlType").append(EQUALS).append(this.getURLType());
        if (this.secure) {
            this.createURLParameter(sb, "wsrp-secureURL", "true");
        }
        if (this.mode != null) {
            this.createURLParameter(sb, "wsrp-mode", WSRPUtils.getWSRPNameFromJSR168PortletMode(this.mode));
        }
        if (this.windowState != null) {
            this.createURLParameter(sb, "wsrp-windowState", WSRPUtils.getWSRPNameFromJSR168WindowState(this.windowState));
        }
        this.appendEnd(sb);
        if (strict) {
            sb.append("/wsrp_rewrite");
        } else if (this.extraParams != null && !this.extraParams.isEmpty()) {
            StringBuffer extras = new StringBuffer();
            this.appendExtraParams(extras);
            if (this.extraParamsAfterEndToken) {
                sb.append("/wsrp_rewrite");
                sb.append(extras);
                if (this.extra != null) {
                    sb.append(this.extra);
                }
            } else {
                sb.append(extras);
                sb.append("/wsrp_rewrite");
            }
        } else {
            sb.append("/wsrp_rewrite");
        }
        return sb.toString();
    }

    protected void appendExtraParams(StringBuffer buffer) {
        if (this.extraParams != null) {
            for (Map.Entry<String, String> entry : this.extraParams.entrySet()) {
                this.createURLParameter(buffer, entry.getKey(), entry.getValue());
            }
        }
    }

    protected abstract void appendEnd(StringBuffer var1);

    protected final void createURLParameter(StringBuffer sb, String name, String value) {
        if (value != null) {
            sb.append(AMPERSAND).append(name).append(EQUALS).append(value);
        }
    }

    private static Map<String, String> extractParams(String encodedURL, String originalURL, Set<String> customModes, Set<String> customWindowStates) {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean finished = false;
        while (encodedURL.length() > 0 && !finished) {
            String param;
            int endParamIndex = encodedURL.indexOf(PARAM_SEPARATOR);
            if (endParamIndex < 0) {
                param = encodedURL;
                finished = true;
            } else {
                param = encodedURL.substring(0, endParamIndex);
            }
            int equalsIndex = param.indexOf(EQUALS);
            if (equalsIndex < 0) {
                throw new IllegalArgumentException(param + " is not a valid parameter for " + originalURL);
            }
            String name = param.substring(0, equalsIndex);
            if (!name.startsWith("wsrp-")) {
                if (strict) {
                    throw new IllegalArgumentException("Invalid parameter name in strict validation mode (see documentation): '" + name + "' in " + originalURL);
                }
                log.debug("Relaxed validation allowed invalid parameter name: " + name + " in " + originalURL);
            }
            String value = param.substring(equalsIndex + EQUALS.length(), param.length());
            if ("wsrp-mode".equals(name)) {
                value = WSRPPortletURL.checkModeOrWindowState(value, true, customModes);
            }
            if ("wsrp-windowState".equals(name)) {
                value = WSRPPortletURL.checkModeOrWindowState(value, false, customWindowStates);
            }
            params.put(name, value);
            if (log.isTraceEnabled() && ("wsrp-interactionState".equals(name) || "wsrp-navigationalState".equals(name))) {
                StateString clear = ParametersStateString.create((String)value);
                log.trace(name + " value:" + clear);
            }
            encodedURL = encodedURL.substring(endParamIndex + PARAM_SEPARATOR.length());
        }
        return params;
    }

    private static String checkModeOrWindowState(String value, boolean mode, Set<String> supportedValues) {
        value = FastURLDecoder.getUTF8Instance().encode(value);
        boolean standard = mode ? WSRPUtils.isDefaultWSRPMode(value) : WSRPUtils.isDefaultWSRPWindowState(value);
        if (!standard) {
            if (supportedValues.contains(value)) {
                return value;
            }
            throw new IllegalArgumentException("Unsupported " + (mode ? "mode: " : "window state: ") + value);
        }
        return value;
    }

    private void setExtraParamsAfterEndToken(boolean extraParamsAfterEndToken) {
        this.extraParamsAfterEndToken = extraParamsAfterEndToken;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }
}

