/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gatein.common.net.URLTools;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.RenderURL;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.WindowState;
import org.gatein.wsrp.WSRPPortletURL;
import org.gatein.wsrp.WSRPUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSRPRenderURL
extends WSRPPortletURL
implements RenderURL {
    private Map<String, String[]> publicNSChanges;

    protected WSRPRenderURL(Mode mode, WindowState windowState, boolean secure, StateString navigationalState, Map<String, String[]> publicNavigationalStateChanges) {
        super(mode, windowState, secure, navigationalState);
        this.publicNSChanges = publicNavigationalStateChanges;
    }

    protected WSRPRenderURL() {
    }

    @Override
    protected void dealWithSpecificParams(Map<String, String> params, String originalURL) {
        super.dealWithSpecificParams(params, originalURL);
        String paramValue = this.getRawParameterValueFor(params, "wsrp-navigationalValues");
        if (paramValue != null) {
            this.publicNSChanges = WSRPRenderURL.decodePublicNS(paramValue);
            params.remove("wsrp-navigationalValues");
        }
    }

    @Override
    protected String getURLType() {
        return "render";
    }

    public Map<String, String[]> getPublicNavigationalStateChanges() {
        return this.publicNSChanges;
    }

    @Override
    protected void appendEnd(StringBuffer sb) {
        if (this.publicNSChanges != null) {
            this.createURLParameter(sb, "wsrp-navigationalValues", WSRPRenderURL.encodePublicNS(this.publicNSChanges));
        }
    }

    protected static String encodePublicNS(Map<String, String[]> publicNSChanges) {
        if (ParameterValidation.existsAndIsNotEmpty(publicNSChanges)) {
            StringBuilder sb = new StringBuilder(128);
            Set<Map.Entry<String, String[]>> entries = publicNSChanges.entrySet();
            int entryNb = entries.size();
            int currentEntry = 0;
            for (Map.Entry<String, String[]> entry : entries) {
                String name = entry.getKey();
                Object[] values = entry.getValue();
                if (ParameterValidation.existsAndIsNotEmpty((Object[])values)) {
                    int valueNb = values.length;
                    int currentValueIndex = 0;
                    for (Object value : values) {
                        sb.append(name).append("=").append((String)value);
                        if (currentValueIndex++ == valueNb - 1) continue;
                        sb.append("&");
                    }
                } else {
                    sb.append(name);
                }
                if (currentEntry++ == entryNb - 1) continue;
                sb.append("&");
            }
            return URLTools.encodeXWWWFormURL((String)sb.toString());
        }
        return null;
    }

    protected static Map<String, String[]> decodePublicNS(String paramValue) {
        if (!ParameterValidation.isNullOrEmpty((String)paramValue)) {
            String encodedURL = URLTools.decodeXWWWFormURL((String)paramValue);
            HashMap<String, String[]> publicNS = new HashMap<String, String[]>(7);
            boolean finished = false;
            while (encodedURL.length() > 0 && !finished) {
                String param;
                int endParamIndex = encodedURL.indexOf("&");
                if (endParamIndex < 0) {
                    param = encodedURL;
                    finished = true;
                } else {
                    param = encodedURL.substring(0, endParamIndex);
                }
                int equalsIndex = param.indexOf("=");
                if (equalsIndex < 0) {
                    publicNS.put(param, null);
                } else {
                    String name = param.substring(0, equalsIndex);
                    String value = param.substring(equalsIndex + "=".length(), param.length());
                    WSRPUtils.addMultiValuedValueTo(publicNS, name, value);
                }
                encodedURL = encodedURL.substring(endParamIndex + "&".length());
            }
            return publicNS;
        }
        return null;
    }
}

