/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.payload;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gatein.common.util.ParameterValidation;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.payload.XSDTypeConverter;
import org.oasis.wsrp.v2.EventPayload;
import org.oasis.wsrp.v2.NamedStringArray;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PayloadUtils {
    private static final Map<String, XSDTypeConverter> converters;

    public static Serializable getPayloadAsSerializable(QName type, EventPayload payload) {
        if (payload == null) {
            return null;
        }
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)type, (String)"Payload expected type");
        Object any = payload.getAny();
        if (any == null) {
            NamedStringArray namedStringArray = payload.getNamedStringArray();
            if (namedStringArray != null) {
                throw new UnsupportedOperationException("Don't know how to convert NamedStringArray to a Serializable in an interroperable way. :(");
            }
            return null;
        }
        Element element = (Element)any;
        String typeName = type.getLocalPart();
        if ("http://www.w3.org/2001/XMLSchema".equals(type.getNamespaceURI())) {
            XSDTypeConverter converter = converters.get(typeName);
            if (converter == null) {
                throw new IllegalArgumentException("Don't know how to deal with standard type: " + type);
            }
            return converter.convert(element.getTextContent());
        }
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<Serializable> clazz = loader.loadClass(typeName).asSubclass(Serializable.class);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            JAXBElement result = unmarshaller.unmarshal((Node)element, clazz);
            return (Serializable)result.getValue();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't unmarshall element " + element + " with expected type " + type, e);
        }
    }

    public static EventPayload getPayloadAsEventPayload(QName type, Serializable payload) {
        try {
            Class<?> payloadClass = payload.getClass();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{payloadClass});
            Marshaller marshaller = context.createMarshaller();
            JAXBElement element = new JAXBElement(type, payloadClass, (Object)payload);
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            Document document = builderFactory.newDocumentBuilder().newDocument();
            marshaller.marshal((Object)element, (Node)document);
            return WSRPTypeFactory.createEventPayloadAsAny(document.getDocumentElement());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't marshall payload " + payload + " with expected type " + type, e);
        }
    }

    static {
        XSDTypeConverter[] converterArray;
        converters = new HashMap<String, XSDTypeConverter>(19);
        for (XSDTypeConverter converter : converterArray = XSDTypeConverter.values()) {
            converters.put(converter.typeName(), converter);
        }
    }
}

