/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.gatein.common.text.TextTools;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.ActionURL;
import org.gatein.pc.api.ContainerURL;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.OpaqueStateString;
import org.gatein.pc.api.PortletStateType;
import org.gatein.pc.api.RenderURL;
import org.gatein.pc.api.ResourceURL;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.StatefulPortletContext;
import org.gatein.pc.api.URLFormat;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.cache.CacheLevel;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.payload.PayloadUtils;
import org.gatein.wsrp.spec.v2.ErrorCodes;
import org.oasis.wsrp.v2.BlockingInteractionResponse;
import org.oasis.wsrp.v2.CacheControl;
import org.oasis.wsrp.v2.ClientData;
import org.oasis.wsrp.v2.ClonePortlet;
import org.oasis.wsrp.v2.Contact;
import org.oasis.wsrp.v2.CopiedPortlet;
import org.oasis.wsrp.v2.CopyPortlets;
import org.oasis.wsrp.v2.CopyPortletsResponse;
import org.oasis.wsrp.v2.DestroyPortlets;
import org.oasis.wsrp.v2.DestroyPortletsResponse;
import org.oasis.wsrp.v2.EmployerInfo;
import org.oasis.wsrp.v2.Event;
import org.oasis.wsrp.v2.EventDescription;
import org.oasis.wsrp.v2.EventParams;
import org.oasis.wsrp.v2.EventPayload;
import org.oasis.wsrp.v2.ExportPortlets;
import org.oasis.wsrp.v2.ExportPortletsResponse;
import org.oasis.wsrp.v2.ExportedPortlet;
import org.oasis.wsrp.v2.Extension;
import org.oasis.wsrp.v2.FailedPortlets;
import org.oasis.wsrp.v2.GetMarkup;
import org.oasis.wsrp.v2.GetPortletDescription;
import org.oasis.wsrp.v2.GetPortletProperties;
import org.oasis.wsrp.v2.GetPortletPropertyDescription;
import org.oasis.wsrp.v2.GetResource;
import org.oasis.wsrp.v2.GetServiceDescription;
import org.oasis.wsrp.v2.HandleEvents;
import org.oasis.wsrp.v2.HandleEventsResponse;
import org.oasis.wsrp.v2.ImportPortlet;
import org.oasis.wsrp.v2.ImportPortlets;
import org.oasis.wsrp.v2.ImportPortletsFailed;
import org.oasis.wsrp.v2.ImportPortletsResponse;
import org.oasis.wsrp.v2.ImportedPortlet;
import org.oasis.wsrp.v2.InitCookie;
import org.oasis.wsrp.v2.InteractionParams;
import org.oasis.wsrp.v2.ItemDescription;
import org.oasis.wsrp.v2.Lifetime;
import org.oasis.wsrp.v2.LocalizedString;
import org.oasis.wsrp.v2.MarkupContext;
import org.oasis.wsrp.v2.MarkupParams;
import org.oasis.wsrp.v2.MarkupResponse;
import org.oasis.wsrp.v2.MarkupType;
import org.oasis.wsrp.v2.MimeResponse;
import org.oasis.wsrp.v2.MissingParametersFault;
import org.oasis.wsrp.v2.ModelDescription;
import org.oasis.wsrp.v2.ModifyRegistration;
import org.oasis.wsrp.v2.NamedString;
import org.oasis.wsrp.v2.NamedStringArray;
import org.oasis.wsrp.v2.NavigationalContext;
import org.oasis.wsrp.v2.Online;
import org.oasis.wsrp.v2.OperationFailedFault;
import org.oasis.wsrp.v2.ParameterDescription;
import org.oasis.wsrp.v2.PerformBlockingInteraction;
import org.oasis.wsrp.v2.PersonName;
import org.oasis.wsrp.v2.PortletContext;
import org.oasis.wsrp.v2.PortletDescription;
import org.oasis.wsrp.v2.PortletDescriptionResponse;
import org.oasis.wsrp.v2.PortletPropertyDescriptionResponse;
import org.oasis.wsrp.v2.Postal;
import org.oasis.wsrp.v2.Property;
import org.oasis.wsrp.v2.PropertyDescription;
import org.oasis.wsrp.v2.PropertyList;
import org.oasis.wsrp.v2.RegistrationContext;
import org.oasis.wsrp.v2.RegistrationData;
import org.oasis.wsrp.v2.ReleaseExport;
import org.oasis.wsrp.v2.ReleaseSessions;
import org.oasis.wsrp.v2.ResetProperty;
import org.oasis.wsrp.v2.Resource;
import org.oasis.wsrp.v2.ResourceContext;
import org.oasis.wsrp.v2.ResourceList;
import org.oasis.wsrp.v2.ResourceParams;
import org.oasis.wsrp.v2.ResourceResponse;
import org.oasis.wsrp.v2.ResourceValue;
import org.oasis.wsrp.v2.ReturnAny;
import org.oasis.wsrp.v2.RuntimeContext;
import org.oasis.wsrp.v2.ServiceDescription;
import org.oasis.wsrp.v2.SessionContext;
import org.oasis.wsrp.v2.SessionParams;
import org.oasis.wsrp.v2.SetExportLifetime;
import org.oasis.wsrp.v2.SetPortletProperties;
import org.oasis.wsrp.v2.StateChange;
import org.oasis.wsrp.v2.Telecom;
import org.oasis.wsrp.v2.TelephoneNum;
import org.oasis.wsrp.v2.Templates;
import org.oasis.wsrp.v2.UpdateResponse;
import org.oasis.wsrp.v2.UploadContext;
import org.oasis.wsrp.v2.UserContext;
import org.oasis.wsrp.v2.UserProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSRPTypeFactory {
    private static final String AMP = "&";
    private static final String EQ = "=";
    private static final String ADDITIONAL_RESOURCE_URL_PARAMS = "&wsrp-requiresRewrite={wsrp-requiresRewrite}&wsrp-url={wsrp-url}&wsrp-preferOperation={wsrp-preferOperation}";
    private static final OpaqueStateString WSRP_NAVIGATIONAL_STATE_TOKEN = new OpaqueStateString("{wsrp-navigationalState}");
    private static final WindowState WSRP_WINDOW_STATE_TOKEN = WindowState.create((String)"{wsrp-windowState}", (boolean)true);
    private static final Mode WSRP_MODE_TOKEN = Mode.create((String)"{wsrp-mode}", (boolean)true);
    private static final OpaqueStateString WSRP_INTERACTION_STATE_TOKEN = new OpaqueStateString("{wsrp-interactionState}");
    private static final ActionURL ACTION_URL = new ActionURL(){

        public StateString getInteractionState() {
            return WSRP_INTERACTION_STATE_TOKEN;
        }

        public StateString getNavigationalState() {
            return WSRPTypeFactory.getTemplateNS();
        }

        public Mode getMode() {
            return WSRPTypeFactory.getTemplateMode();
        }

        public WindowState getWindowState() {
            return WSRPTypeFactory.getTemplateWindowState();
        }

        public Map<String, String> getProperties() {
            return Collections.emptyMap();
        }
    };
    private static final HashMap<String, String[]> WSRP_PNS_MAP_TOKEN = new HashMap();
    private static final RenderURL RENDER_URL;
    private static final OpaqueStateString WSRP_RESOURCE_STATE_TOKEN;
    private static ResourceURL RESOURCE_URL;

    private WSRPTypeFactory() {
    }

    public static GetServiceDescription createGetServiceDescription(RegistrationContext registrationContext, UserContext userContext) {
        GetServiceDescription getServiceDescription = new GetServiceDescription();
        getServiceDescription.setRegistrationContext(registrationContext);
        getServiceDescription.setUserContext(userContext);
        return getServiceDescription;
    }

    public static GetMarkup createGetMarkup(RegistrationContext registrationContext, PortletContext portletContext, RuntimeContext runtimeContext, UserContext userContext, MarkupParams markupParams) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)portletContext.getPortletHandle(), (String)"portlet handle", (String)"PortletContext");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)runtimeContext, (String)"RuntimeContext");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)markupParams, (String)"MarkupParams");
        GetMarkup getMarkup = new GetMarkup();
        getMarkup.setRegistrationContext(registrationContext);
        getMarkup.setPortletContext(portletContext);
        getMarkup.setRuntimeContext(runtimeContext);
        getMarkup.setUserContext(userContext);
        getMarkup.setMarkupParams(markupParams);
        return getMarkup;
    }

    public static GetResource createGetResource(RegistrationContext registrationContext, PortletContext portletContext, RuntimeContext runtimeContext, UserContext userContext, ResourceParams resourceParams) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)portletContext.getPortletHandle(), (String)"portlet handle", (String)"PortletContext");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)runtimeContext, (String)"RuntimeContext");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)resourceParams, (String)"ResourceParams");
        GetResource getResource = new GetResource();
        getResource.setRegistrationContext(registrationContext);
        getResource.setPortletContext(portletContext);
        getResource.setRuntimeContext(runtimeContext);
        getResource.setUserContext(userContext);
        getResource.setResourceParams(resourceParams);
        return getResource;
    }

    public static PerformBlockingInteraction createPerformBlockingInteraction(RegistrationContext registrationContext, PortletContext portletContext, RuntimeContext runtimeContext, UserContext userContext, MarkupParams markupParams, InteractionParams interactionParams) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)portletContext.getPortletHandle(), (String)"portlet handle", (String)"PortletContext");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)runtimeContext, (String)"RuntimeContext");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)markupParams, (String)"MarkupParams");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)interactionParams, (String)"InteractionParams");
        PerformBlockingInteraction performBlockingInteraction = new PerformBlockingInteraction();
        performBlockingInteraction.setRegistrationContext(registrationContext);
        performBlockingInteraction.setPortletContext(portletContext);
        performBlockingInteraction.setRuntimeContext(runtimeContext);
        performBlockingInteraction.setUserContext(userContext);
        performBlockingInteraction.setMarkupParams(markupParams);
        performBlockingInteraction.setInteractionParams(interactionParams);
        return performBlockingInteraction;
    }

    public static HandleEvents createHandleEvents(RegistrationContext registrationContext, PortletContext portletContext, RuntimeContext runtimeContext, UserContext userContext, MarkupParams markupParams, EventParams eventParams) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)portletContext.getPortletHandle(), (String)"portlet handle", (String)"PortletContext");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)runtimeContext, (String)"RuntimeContext");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)markupParams, (String)"MarkupParams");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)eventParams, (String)"EventParams");
        HandleEvents handleEvents = new HandleEvents();
        handleEvents.setRegistrationContext(registrationContext);
        handleEvents.setPortletContext(portletContext);
        handleEvents.setRuntimeContext(runtimeContext);
        handleEvents.setUserContext(userContext);
        handleEvents.setMarkupParams(markupParams);
        handleEvents.setEventParams(eventParams);
        return handleEvents;
    }

    public static GetPortletDescription createGetPortletDescription(RegistrationContext registrationContext, String portletHandle) {
        PortletContext portletContext = WSRPTypeFactory.createPortletContext(portletHandle);
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"portlet context");
        GetPortletDescription description = new GetPortletDescription();
        description.setPortletContext(portletContext);
        description.setRegistrationContext(registrationContext);
        return description;
    }

    public static GetPortletDescription createGetPortletDescription(RegistrationContext registrationContext, PortletContext portletContext, UserContext userContext) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"portlet context");
        GetPortletDescription description = new GetPortletDescription();
        description.setPortletContext(portletContext);
        description.setRegistrationContext(registrationContext);
        description.setUserContext(userContext);
        return description;
    }

    public static GetPortletDescription createGetPortletDescription(RegistrationContext registrationContext, org.gatein.pc.api.PortletContext portletContext) {
        StatefulPortletContext context;
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"portlet context");
        PortletContext wsrpPC = WSRPTypeFactory.createPortletContext(portletContext.getId());
        if (portletContext instanceof StatefulPortletContext && PortletStateType.OPAQUE.equals((context = (StatefulPortletContext)portletContext).getType())) {
            wsrpPC.setPortletState((byte[])context.getState());
        }
        GetPortletDescription getPortletDescription = new GetPortletDescription();
        getPortletDescription.setRegistrationContext(registrationContext);
        getPortletDescription.setPortletContext(wsrpPC);
        return getPortletDescription;
    }

    public static GetPortletProperties createGetPortletProperties(RegistrationContext registrationContext, PortletContext portletContext, UserContext userContext, List<String> names) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        GetPortletProperties properties = new GetPortletProperties();
        properties.setRegistrationContext(registrationContext);
        properties.setPortletContext(portletContext);
        properties.setUserContext(userContext);
        properties.getNames().addAll(names);
        return properties;
    }

    public static BlockingInteractionResponse createBlockingInteractionResponse(UpdateResponse updateResponse) {
        if (updateResponse == null) {
            throw new IllegalArgumentException("BlockingInteractionResponse requires either an UpdateResponse or a redirect URL.");
        }
        BlockingInteractionResponse interactionResponse = new BlockingInteractionResponse();
        interactionResponse.setUpdateResponse(updateResponse);
        return interactionResponse;
    }

    public static BlockingInteractionResponse createBlockingInteractionResponse(String redirectURL) {
        if (redirectURL == null || redirectURL.length() == 0) {
            throw new IllegalArgumentException("BlockingInteractionResponse requires either an UpdateResponse or a redirect URL.");
        }
        BlockingInteractionResponse interactionResponse = new BlockingInteractionResponse();
        interactionResponse.setRedirectURL(redirectURL);
        return interactionResponse;
    }

    public static UpdateResponse createUpdateResponse() {
        return new UpdateResponse();
    }

    public static PortletDescription createPortletDescription(String portletHandle, List<MarkupType> markupTypes) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)portletHandle, (String)"portlet handle", null);
        WSRPTypeFactory.checkPortletHandle(portletHandle);
        ParameterValidation.throwIllegalArgExceptionIfNull(markupTypes, (String)"MarkupType");
        if (markupTypes.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a PortletDescription with an empty list of MarkupTypes!");
        }
        PortletDescription portletDescription = new PortletDescription();
        portletDescription.setPortletHandle(portletHandle);
        portletDescription.getMarkupTypes().addAll(markupTypes);
        return portletDescription;
    }

    private static void checkPortletHandle(String portletHandle) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)portletHandle, (String)"portlet handle", (String)"PortletDescription");
        if (portletHandle.length() > 255) {
            throw new IllegalArgumentException("Portlet handles must be less than 255 characters long. Was " + portletHandle.length() + " long.");
        }
    }

    public static MarkupParams createMarkupParams(boolean secureClientCommunication, List<String> locales, List<String> mimeTypes, String mode, String windowState) {
        ParameterValidation.throwIllegalArgExceptionIfNull(locales, (String)"locales");
        if (locales.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a MarkupParams with an empty list of locales!");
        }
        if (mimeTypes.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a MarkupParams with an empty list of mimeTypes!");
        }
        ParameterValidation.throwIllegalArgExceptionIfNull(mimeTypes, (String)"MIME types");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)mode, (String)"mode", (String)"MarkupParams");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)windowState, (String)"window state", (String)"MarkupParams");
        MarkupParams markupParams = new MarkupParams();
        markupParams.setSecureClientCommunication(secureClientCommunication);
        markupParams.setMode(mode);
        markupParams.setWindowState(windowState);
        if (ParameterValidation.existsAndIsNotEmpty(locales)) {
            markupParams.getLocales().addAll(locales);
        }
        if (ParameterValidation.existsAndIsNotEmpty(mimeTypes)) {
            markupParams.getMimeTypes().addAll(mimeTypes);
        }
        return markupParams;
    }

    public static ResourceParams createDefaultResourceParams(String resourceID) {
        return WSRPTypeFactory.createResourceParams(false, WSRPConstants.getDefaultLocales(), WSRPConstants.getDefaultMimeTypes(), "wsrp:view", "wsrp:normal", resourceID, StateChange.READ_ONLY);
    }

    public static ResourceParams createResourceParams(boolean secureClientCommunication, List<String> locales, List<String> mimeTypes, String mode, String windowState, String resourceID, StateChange stateChange) {
        ParameterValidation.throwIllegalArgExceptionIfNull(locales, (String)"locales");
        if (locales.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a ResourceParams with an empty list of locales!");
        }
        ParameterValidation.throwIllegalArgExceptionIfNull(mimeTypes, (String)"locales");
        if (mimeTypes.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a MarkupParams with an empty list of mimeTypes!");
        }
        ParameterValidation.throwIllegalArgExceptionIfNull(mimeTypes, (String)"MIME types");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)stateChange, (String)"State Change");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)mode, (String)"mode", (String)"ResourceParams");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)windowState, (String)"window state", (String)"ResourceParams");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)resourceID, (String)"Resource ID", (String)"ResourceParams");
        ResourceParams resourceParams = new ResourceParams();
        resourceParams.setSecureClientCommunication(secureClientCommunication);
        resourceParams.setMode(mode);
        resourceParams.setWindowState(windowState);
        if (ParameterValidation.existsAndIsNotEmpty(locales)) {
            resourceParams.getLocales().addAll(locales);
        }
        if (ParameterValidation.existsAndIsNotEmpty(mimeTypes)) {
            resourceParams.getMimeTypes().addAll(mimeTypes);
        }
        resourceParams.setResourceID(resourceID);
        resourceParams.setPortletStateChange(stateChange);
        return resourceParams;
    }

    public static RuntimeContext createRuntimeContext(String userAuthentication, String portletInstanceKey, String namespacePrefix) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)userAuthentication, (String)"user authentication", (String)"RuntimeContext");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)portletInstanceKey, (String)"Portlet Instance Key", (String)"RuntimeContext");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)namespacePrefix, (String)"Namespace Prefix", (String)"RuntimeContext");
        RuntimeContext runtimeContext = new RuntimeContext();
        runtimeContext.setUserAuthentication(userAuthentication);
        runtimeContext.setPortletInstanceKey(portletInstanceKey);
        runtimeContext.setNamespacePrefix(namespacePrefix);
        return runtimeContext;
    }

    public static PortletContext createPortletContext(String portletHandle) {
        WSRPTypeFactory.checkPortletHandle(portletHandle);
        PortletContext portletContext = new PortletContext();
        portletContext.setPortletHandle(portletHandle);
        return portletContext;
    }

    public static PortletContext createPortletContext(String portletHandle, byte[] portletState) {
        PortletContext pc = WSRPTypeFactory.createPortletContext(portletHandle);
        pc.setPortletState(portletState);
        return pc;
    }

    public static InteractionParams createInteractionParams(StateChange portletStateChange) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletStateChange, (String)"portletStateChange");
        InteractionParams interactionParams = new InteractionParams();
        interactionParams.setPortletStateChange(portletStateChange);
        return interactionParams;
    }

    public static InitCookie createInitCookie(RegistrationContext registrationContext) {
        InitCookie initCookie = new InitCookie();
        initCookie.setRegistrationContext(registrationContext);
        return initCookie;
    }

    public static ServiceDescription createServiceDescription(boolean requiresRegistration) {
        ServiceDescription serviceDescription = new ServiceDescription();
        serviceDescription.setRequiresRegistration(requiresRegistration);
        return serviceDescription;
    }

    public static MarkupResponse createMarkupResponse(MarkupContext markupContext) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)markupContext, (String)"MarkupContext");
        MarkupResponse markupResponse = new MarkupResponse();
        markupResponse.setMarkupContext(markupContext);
        return markupResponse;
    }

    public static ResourceResponse createResourceResponse(ResourceContext resourceContext) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)resourceContext, (String)"ResourceContext");
        ResourceResponse resourceResponse = new ResourceResponse();
        resourceResponse.setResourceContext(resourceContext);
        return resourceResponse;
    }

    public static MarkupContext createMarkupContext(String mediaType, String markupString) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)mediaType, (String)"Media type", (String)"MarkupContext");
        if (markupString == null) {
            throw new IllegalArgumentException("MarkupContext requires either a non-null markup string or binary markup.");
        }
        MarkupContext markupContext = new MarkupContext();
        markupContext.setMimeType(mediaType);
        markupContext.setItemString(markupString);
        return markupContext;
    }

    public static MarkupContext createMarkupContext(String mediaType, byte[] markupBinary) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)mediaType, (String)"MIME type", (String)"MarkupContext");
        if (markupBinary == null || markupBinary.length == 0) {
            throw new IllegalArgumentException("MarkupContext requires either a non-null markup string or binary markup.");
        }
        MarkupContext markupContext = new MarkupContext();
        markupContext.setMimeType(mediaType);
        markupContext.setItemBinary(markupBinary);
        return markupContext;
    }

    public static ResourceContext createResourceContext(String mediaType, String resourceString, byte[] resourceBinary) {
        return WSRPTypeFactory.createMimeResponse(mediaType, resourceString, resourceBinary, ResourceContext.class);
    }

    public static <T extends MimeResponse> T createMimeResponse(String mimeType, String itemString, byte[] itemBinary, Class<T> clazz) {
        MimeResponse mimeResponse;
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)mimeType, (String)"MIME type", (String)"MimeResponse");
        if (itemString == null && (itemBinary == null || itemBinary.length == 0)) {
            throw new IllegalArgumentException("MimeResponse requires either a non-null markup string or binary markup.");
        }
        try {
            mimeResponse = (MimeResponse)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't instantiate " + clazz.getSimpleName(), e);
        }
        mimeResponse.setMimeType(mimeType);
        if (itemString != null) {
            mimeResponse.setItemString(itemString);
        } else {
            mimeResponse.setItemBinary(itemBinary);
        }
        return (T)mimeResponse;
    }

    public static SessionContext createSessionContext(String sessionID, int expires) {
        if (expires < 0) {
            throw new IllegalArgumentException("SessionContext requires a positive expiration time.");
        }
        SessionContext sessionContext = new SessionContext();
        sessionContext.setSessionID(sessionID);
        sessionContext.setExpires(Integer.valueOf(expires));
        return sessionContext;
    }

    public static UserContext createUserContext(String userContextKey) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)userContextKey, (String)"user context key", (String)"UserContext");
        UserContext userContext = new UserContext();
        userContext.setUserContextKey(userContextKey);
        return userContext;
    }

    public static RegistrationData createRegistrationData(String consumerName, String consumerAgent, boolean methodGetSupported) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerName, (String)"consumer name", (String)"RegistrationData");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerAgent, (String)"consumer agent", (String)"RegistrationData");
        RegistrationData regData = WSRPTypeFactory.createDefaultRegistrationData();
        regData.setConsumerName(consumerName);
        regData.setConsumerAgent(consumerAgent);
        regData.setMethodGetSupported(methodGetSupported);
        return regData;
    }

    public static RegistrationData createDefaultRegistrationData() {
        RegistrationData registrationData = new RegistrationData();
        registrationData.setConsumerName(WSRPConstants.DEFAULT_CONSUMER_NAME);
        registrationData.setConsumerAgent(WSRPConstants.CONSUMER_AGENT);
        registrationData.setMethodGetSupported(false);
        return registrationData;
    }

    public static Property createProperty(String name, String lang, String stringValue) {
        QName qName = QName.valueOf(name);
        return WSRPTypeFactory.createProperty(qName, lang, stringValue);
    }

    public static Property createProperty(QName name, String lang, String stringValue) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)name, (String)"name");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)lang, (String)"language", (String)"Property");
        Property property = new Property();
        property.setName(name);
        property.setLang(lang);
        property.setStringValue(stringValue);
        return property;
    }

    private static StateString getTemplateNS() {
        return WSRP_NAVIGATIONAL_STATE_TOKEN;
    }

    private static WindowState getTemplateWindowState() {
        return WSRP_WINDOW_STATE_TOKEN;
    }

    private static Mode getTemplateMode() {
        return WSRP_MODE_TOKEN;
    }

    public static Templates createTemplates(PortletInvocationContext context) {
        Templates templates = new Templates();
        templates.setBlockingActionTemplate(WSRPTypeFactory.createTemplate(context, (ContainerURL)ACTION_URL, Boolean.FALSE));
        templates.setRenderTemplate(WSRPTypeFactory.createTemplate(context, (ContainerURL)RENDER_URL, Boolean.FALSE));
        templates.setSecureBlockingActionTemplate(WSRPTypeFactory.createTemplate(context, (ContainerURL)ACTION_URL, Boolean.TRUE));
        templates.setSecureRenderTemplate(WSRPTypeFactory.createTemplate(context, (ContainerURL)RENDER_URL, Boolean.TRUE));
        templates.setResourceTemplate(WSRPTypeFactory.createTemplate(context, (ContainerURL)RESOURCE_URL, false));
        templates.setSecureResourceTemplate(WSRPTypeFactory.createTemplate(context, (ContainerURL)RESOURCE_URL, true));
        return templates;
    }

    public static Templates createTemplates(String defaultTemplate, String blockingActionTemplate, String renderTemplate, String resourceTemplate, String secureDefaultTemplate, String secureBlockingActionTemplate, String secureRenderTemplate, String secureResourceTemplate) {
        Templates templates = new Templates();
        templates.setDefaultTemplate(defaultTemplate);
        templates.setBlockingActionTemplate(blockingActionTemplate);
        templates.setRenderTemplate(renderTemplate);
        templates.setResourceTemplate(resourceTemplate);
        templates.setSecureDefaultTemplate(secureDefaultTemplate);
        templates.setSecureBlockingActionTemplate(secureBlockingActionTemplate);
        templates.setSecureRenderTemplate(secureRenderTemplate);
        templates.setSecureResourceTemplate(secureResourceTemplate);
        return templates;
    }

    private static String createTemplate(PortletInvocationContext context, ContainerURL url, Boolean secure) {
        String template = context.renderURL(url, new URLFormat(secure, null, null, Boolean.valueOf(true)));
        template = TextTools.replace((String)template, (String)"%7B", (String)"{");
        template = TextTools.replace((String)template, (String)"%7D", (String)"}");
        if (RESOURCE_URL == url) {
            template = template + ADDITIONAL_RESOURCE_URL_PARAMS;
        }
        return template;
    }

    public static ClientData createClientData(String userAgent) {
        ClientData clientData = new ClientData();
        clientData.setUserAgent(userAgent);
        return clientData;
    }

    public static CacheControl createCacheControl(int expires, String userScope) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)userScope, (String)"user scope", (String)"CacheControl");
        if (expires < -1) {
            throw new IllegalArgumentException("Cache expiration time must be greater than -1, -1 indicating that the cache will never expire.");
        }
        CacheControl cacheControl = new CacheControl();
        cacheControl.setExpires(expires);
        cacheControl.setUserScope(userScope);
        return cacheControl;
    }

    public static RegistrationContext createRegistrationContext(String registrationHandle) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)registrationHandle, (String)"Registration handle");
        RegistrationContext registrationContext = new RegistrationContext();
        registrationContext.setRegistrationHandle(registrationHandle);
        return registrationContext;
    }

    public static ModelDescription createModelDescription(List<PropertyDescription> propertyDescriptions) {
        ModelDescription description = new ModelDescription();
        if (ParameterValidation.existsAndIsNotEmpty(propertyDescriptions)) {
            description.getPropertyDescriptions().addAll(propertyDescriptions);
        }
        return description;
    }

    public static PropertyDescription createPropertyDescription(String name, QName type) {
        QName qName = QName.valueOf(name);
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)type, (String)"PropertyDescription type");
        PropertyDescription description = new PropertyDescription();
        description.setName(qName);
        description.setType(type);
        return description;
    }

    public static LocalizedString createLocalizedString(String lang, String resourceName, String value) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)lang, (String)"LocalizedString language");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)value, (String)"LocalizedString value");
        LocalizedString localizedString = new LocalizedString();
        localizedString.setLang(lang);
        localizedString.setResourceName(resourceName);
        localizedString.setValue(value);
        return localizedString;
    }

    public static LocalizedString createLocalizedString(String value) {
        return WSRPTypeFactory.createLocalizedString("en", null, value);
    }

    public static PortletDescriptionResponse createPortletDescriptionResponse(PortletDescription portletDescription) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletDescription, (String)"PortletDescription");
        PortletDescriptionResponse response = new PortletDescriptionResponse();
        response.setPortletDescription(portletDescription);
        return response;
    }

    public static PortletPropertyDescriptionResponse createPortletPropertyDescriptionResponse(List<PropertyDescription> propertyDescriptions) {
        ModelDescription modelDescription = propertyDescriptions == null ? null : WSRPTypeFactory.createModelDescription(propertyDescriptions);
        PortletPropertyDescriptionResponse portletPropertyDescriptionResponse = new PortletPropertyDescriptionResponse();
        portletPropertyDescriptionResponse.setModelDescription(modelDescription);
        return portletPropertyDescriptionResponse;
    }

    public static GetPortletPropertyDescription createGetPortletPropertyDescription(RegistrationContext registrationContext, PortletContext portletContext, UserContext userContext, List<String> desiredLocales) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        GetPortletPropertyDescription description = new GetPortletPropertyDescription();
        description.setRegistrationContext(registrationContext);
        description.setPortletContext(portletContext);
        description.setUserContext(userContext);
        if (ParameterValidation.existsAndIsNotEmpty(desiredLocales)) {
            description.getDesiredLocales().addAll(desiredLocales);
        }
        return description;
    }

    public static GetPortletPropertyDescription createSimpleGetPortletPropertyDescription(String portletHandle) {
        return WSRPTypeFactory.createGetPortletPropertyDescription(null, WSRPTypeFactory.createPortletContext(portletHandle), null, null);
    }

    public static SetPortletProperties createSetPortletProperties(RegistrationContext registrationContext, PortletContext portletContext, PropertyList propertyList) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyList, (String)"PropertyList");
        SetPortletProperties properties = new SetPortletProperties();
        properties.setRegistrationContext(registrationContext);
        properties.setPortletContext(portletContext);
        properties.setPropertyList(propertyList);
        return properties;
    }

    public static ClonePortlet createSimpleClonePortlet(String portletHandle) {
        return WSRPTypeFactory.createClonePortlet(null, WSRPTypeFactory.createPortletContext(portletHandle), null);
    }

    public static ClonePortlet createClonePortlet(RegistrationContext registrationContext, PortletContext portletContext, UserContext userContext) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        ClonePortlet clonePortlet = new ClonePortlet();
        clonePortlet.setPortletContext(portletContext);
        clonePortlet.setRegistrationContext(registrationContext);
        clonePortlet.setUserContext(userContext);
        return clonePortlet;
    }

    public static DestroyPortlets createDestroyPortlets(RegistrationContext registrationContext, List<String> portletHandles) {
        ParameterValidation.throwIllegalArgExceptionIfNull(portletHandles, (String)"Portlet handles");
        if (!ParameterValidation.existsAndIsNotEmpty(portletHandles)) {
            throw new IllegalArgumentException("Cannot create a DestroyPortlets with an empty list of portlet handles!");
        }
        DestroyPortlets destroyPortlets = new DestroyPortlets();
        destroyPortlets.setRegistrationContext(registrationContext);
        destroyPortlets.getPortletHandles().addAll(portletHandles);
        return destroyPortlets;
    }

    public static PropertyList createPropertyList() {
        return new PropertyList();
    }

    public static ResetProperty createResetProperty(String name) {
        QName qName = QName.valueOf(name);
        ResetProperty resetProperty = new ResetProperty();
        resetProperty.setName(qName);
        return resetProperty;
    }

    public static ReleaseSessions createReleaseSessions(RegistrationContext registrationContext, List<String> sessionIDs) {
        ParameterValidation.throwIllegalArgExceptionIfNull(sessionIDs, (String)"Session IDs");
        if (sessionIDs.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a ReleaseSessions with an empty list of session IDs!");
        }
        ReleaseSessions sessions = new ReleaseSessions();
        sessions.setRegistrationContext(registrationContext);
        if (ParameterValidation.existsAndIsNotEmpty(sessionIDs)) {
            sessions.getSessionIDs().addAll(sessionIDs);
        }
        return sessions;
    }

    public static ModifyRegistration createModifyRegistration(RegistrationContext registrationContext, RegistrationData registrationData) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)registrationData, (String)"RegistrationData");
        ModifyRegistration registration = new ModifyRegistration();
        registration.setRegistrationContext(registrationContext);
        registration.setRegistrationData(registrationData);
        return registration;
    }

    public static UploadContext createUploadContext(String mimeType, byte[] uploadData) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)mimeType, (String)"MIME Type", (String)"UploadContext");
        if (uploadData == null || uploadData.length == 0) {
            throw new IllegalArgumentException("Must pass non-null, non-empty upload data");
        }
        UploadContext uploadContext = new UploadContext();
        uploadContext.setMimeType(mimeType);
        uploadContext.setUploadData(uploadData);
        return uploadContext;
    }

    public static MarkupType createMarkupType(String mimeType, List<String> modeNames, List<String> windowStateNames, List<String> localeNames) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)mimeType, (String)"MIME Type", (String)"MarkupContext");
        ParameterValidation.throwIllegalArgExceptionIfNull(modeNames, (String)"modeNames");
        if (modeNames.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a MarkupType with an empty list of modes!");
        }
        ParameterValidation.throwIllegalArgExceptionIfNull(windowStateNames, (String)"windowStatesNames");
        if (windowStateNames.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a MarkupType with an empty list of windowStates!");
        }
        MarkupType markupType = new MarkupType();
        markupType.setMimeType(mimeType);
        if (ParameterValidation.existsAndIsNotEmpty(modeNames)) {
            markupType.getModes().addAll(modeNames);
        }
        if (ParameterValidation.existsAndIsNotEmpty(windowStateNames)) {
            markupType.getWindowStates().addAll(windowStateNames);
        }
        if (ParameterValidation.existsAndIsNotEmpty(localeNames)) {
            markupType.getLocales().addAll(localeNames);
        }
        return markupType;
    }

    public static FailedPortlets createFailedPortlets(Collection<String> portletHandles, ErrorCodes.Codes errorCode, String reason) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)((Object)errorCode), (String)"ErrorCode");
        if (ParameterValidation.existsAndIsNotEmpty(portletHandles)) {
            FailedPortlets failedPortlets = new FailedPortlets();
            failedPortlets.getPortletHandles().addAll(portletHandles);
            if (reason != null) {
                failedPortlets.setReason(WSRPTypeFactory.createLocalizedString(reason));
            }
            failedPortlets.setErrorCode(ErrorCodes.getQname(errorCode));
            return failedPortlets;
        }
        throw new IllegalArgumentException("Must provide non-null, non-empty portlet handle list.");
    }

    public static DestroyPortletsResponse createDestroyPortletsResponse(List<FailedPortlets> failedPortlets) {
        DestroyPortletsResponse dpr = new DestroyPortletsResponse();
        if (ParameterValidation.existsAndIsNotEmpty(failedPortlets)) {
            dpr.getFailedPortlets().addAll(failedPortlets);
        }
        return dpr;
    }

    public static NavigationalContext createNavigationalContextOrNull(StateString navigationalState, Map<String, String[]> publicNavigationalState) {
        if (navigationalState != null || publicNavigationalState != null) {
            String state;
            NavigationalContext context = new NavigationalContext();
            if (navigationalState != null && !"JBPNS_".equals(state = navigationalState.getStringValue())) {
                context.setOpaqueValue(state);
            }
            if (ParameterValidation.existsAndIsNotEmpty(publicNavigationalState)) {
                for (Map.Entry<String, String[]> entry : publicNavigationalState.entrySet()) {
                    String name = entry.getKey();
                    for (String value : entry.getValue()) {
                        context.getPublicValues().add(WSRPTypeFactory.createNamedString(name, value));
                    }
                }
            }
            return context;
        }
        return null;
    }

    public static NavigationalContext createNavigationalContext(String opaqueValue, List<NamedString> publicValues) {
        NavigationalContext navigationalContext = new NavigationalContext();
        navigationalContext.setOpaqueValue(opaqueValue);
        if (publicValues != null && !publicValues.isEmpty()) {
            navigationalContext.getPublicValues().addAll(publicValues);
        }
        return navigationalContext;
    }

    public static ParameterDescription createParameterDescription(String identifier) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)identifier, (String)"Parameter identifier", null);
        ParameterDescription desc = new ParameterDescription();
        desc.setIdentifier(identifier);
        return desc;
    }

    public static EventDescription createEventDescription(QName name) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)name, (String)"name");
        EventDescription desc = new EventDescription();
        desc.setName(name);
        return desc;
    }

    public static HandleEventsResponse createHandleEventsReponse() {
        return new HandleEventsResponse();
    }

    public static EventParams createEventParams(List<Event> events, StateChange portletStateChange) {
        if (!ParameterValidation.existsAndIsNotEmpty(events)) {
            throw new IllegalArgumentException("Must provide at least one Event to EventParams.");
        }
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletStateChange, (String)"StateChange");
        EventParams eventParams = new EventParams();
        eventParams.setPortletStateChange(portletStateChange);
        eventParams.getEvents().addAll(events);
        return eventParams;
    }

    public static Event createEvent(QName name, Serializable payload) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)name, (String)"Event name");
        Event event = new Event();
        event.setName(name);
        if (payload != null) {
            event.setPayload(PayloadUtils.getPayloadAsEventPayload(event, payload));
        }
        return event;
    }

    public static EventPayload createEventPayloadAsAny(Object value) {
        EventPayload payload = new EventPayload();
        payload.setAny(value);
        return payload;
    }

    public static NamedString createNamedString(String name, String value) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)name, (String)"name");
        NamedString namedString = new NamedString();
        namedString.setName(name);
        namedString.setValue(value);
        return namedString;
    }

    public static EventPayload createEventPayloadAsNamedString(NamedStringArray payload) {
        EventPayload result = new EventPayload();
        result.setNamedStringArray(payload);
        return result;
    }

    public static ExportPortlets createExportPortlets(RegistrationContext registrationContext, List<PortletContext> portletContexts, UserContext userContext, Lifetime lifetime, Boolean exportByValue) {
        if (!ParameterValidation.existsAndIsNotEmpty(portletContexts)) {
            throw new IllegalArgumentException("Must provide at least one PortletContext to ExportPortlets.");
        }
        ExportPortlets exportPortlets = new ExportPortlets();
        exportPortlets.setRegistrationContext(registrationContext);
        exportPortlets.getPortletContext().addAll(portletContexts);
        exportPortlets.setUserContext(userContext);
        exportPortlets.setLifetime(lifetime);
        exportPortlets.setExportByValueRequired(exportByValue);
        return exportPortlets;
    }

    public static ExportPortletsResponse createExportPortletsResponse(byte[] exportContext, List<ExportedPortlet> exportedPortlets, List<FailedPortlets> failedPortlets, Lifetime lifetime, ResourceList resourceList) {
        ExportPortletsResponse response = new ExportPortletsResponse();
        response.setExportContext(exportContext);
        response.getExportedPortlet().addAll(exportedPortlets);
        response.getFailedPortlets().addAll(failedPortlets);
        response.setLifetime(lifetime);
        response.setResourceList(resourceList);
        return response;
    }

    public static ExportedPortlet createExportedPortlet(String portletHandle, byte[] exportData) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletHandle, (String)"PortletHandle");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)exportData, (String)"ExportData");
        ExportedPortlet exportedPortlet = new ExportedPortlet();
        exportedPortlet.setPortletHandle(portletHandle);
        exportedPortlet.setExportData(exportData);
        return exportedPortlet;
    }

    public static ImportPortlets createImportPortlets(RegistrationContext registrationContext, byte[] importContext, List<ImportPortlet> importPortlet, UserContext userContext, Lifetime lifetime) {
        if (!ParameterValidation.existsAndIsNotEmpty(importPortlet)) {
            throw new IllegalArgumentException("Must provide at least one ImportPortlet to ImportPortlets.");
        }
        ImportPortlets importPortlets = new ImportPortlets();
        importPortlets.setRegistrationContext(registrationContext);
        importPortlets.setImportContext(importContext);
        importPortlets.getImportPortlet().addAll(importPortlet);
        importPortlets.setUserContext(userContext);
        importPortlets.setLifetime(lifetime);
        return importPortlets;
    }

    public static ImportPortlet createImportPortlet(String importID, byte[] exportData) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)importID, (String)"ImportID");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)exportData, (String)"ExportData");
        ImportPortlet importPortlet = new ImportPortlet();
        importPortlet.setImportID(importID);
        importPortlet.setExportData(exportData);
        return importPortlet;
    }

    public static ImportPortletsResponse createImportPortletsResponse(List<ImportedPortlet> importedPortlets, List<ImportPortletsFailed> importPortletsFailed, ResourceList resourceList) {
        ImportPortletsResponse response = new ImportPortletsResponse();
        response.getImportedPortlets().addAll(importedPortlets);
        response.getImportFailed().addAll(importPortletsFailed);
        response.setResourceList(resourceList);
        return response;
    }

    public static ImportPortletsFailed createImportPortletsFailed(List<String> importIds, ErrorCodes.Codes errorCode, String reason) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)((Object)errorCode), (String)"ErrorCode");
        if (ParameterValidation.existsAndIsNotEmpty(importIds)) {
            ImportPortletsFailed failedPortlets = new ImportPortletsFailed();
            failedPortlets.getImportID().addAll(importIds);
            if (reason != null) {
                failedPortlets.setReason(WSRPTypeFactory.createLocalizedString(reason));
            }
            failedPortlets.setErrorCode(ErrorCodes.getQname(errorCode));
            return failedPortlets;
        }
        throw new IllegalArgumentException("Must provide non-null, non-empty portlet id list.");
    }

    public static ImportedPortlet createImportedPortlet(String portletID, PortletContext portletContext) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletID, (String)"PortletID");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        ImportedPortlet importedPortlet = new ImportedPortlet();
        importedPortlet.setImportID(portletID);
        importedPortlet.setNewPortletContext(portletContext);
        return importedPortlet;
    }

    public static ReleaseExport createReleaseExport(RegistrationContext registrationContext, byte[] exportContext, UserContext userContext) {
        if (exportContext == null || exportContext.length == 0) {
            throw new IllegalArgumentException("Must provide a non null or empty exportContext to ReleaseExport.");
        }
        ReleaseExport releaseExport = new ReleaseExport();
        releaseExport.setRegistrationContext(registrationContext);
        releaseExport.setExportContext(exportContext);
        releaseExport.setUserContext(userContext);
        return releaseExport;
    }

    public static SetExportLifetime createSetExportLifetime(RegistrationContext registrationContext, byte[] exportContext, UserContext userContext, Lifetime lifetime) {
        if (exportContext == null || exportContext.length == 0) {
            throw new IllegalArgumentException("Must provide a non null or empty exportContext to SetExportLifetime.");
        }
        SetExportLifetime setExportLifetime = new SetExportLifetime();
        setExportLifetime.setRegistrationContext(registrationContext);
        setExportLifetime.setExportContext(exportContext);
        setExportLifetime.setUserContext(userContext);
        setExportLifetime.setLifetime(lifetime);
        return setExportLifetime;
    }

    public static Contact createContact(Postal postal, Telecom telecom, Online online) {
        Contact contact = new Contact();
        contact.setPostal(postal);
        contact.setTelecom(telecom);
        contact.setOnline(online);
        return contact;
    }

    public static Postal createPostal(String name, String street, String city, String stateprov, String postalCode, String country, String organization) {
        Postal postal = new Postal();
        postal.setName(name);
        postal.setStreet(street);
        postal.setCity(city);
        postal.setStateprov(stateprov);
        postal.setPostalcode(postalCode);
        postal.setCountry(country);
        postal.setOrganization(organization);
        return postal;
    }

    public static Telecom createTelecom(TelephoneNum telephone, TelephoneNum fax, TelephoneNum mobile, TelephoneNum pager) {
        Telecom telecom = new Telecom();
        telecom.setTelephone(telephone);
        telecom.setFax(fax);
        telecom.setMobile(mobile);
        telecom.setPager(pager);
        return telecom;
    }

    public static TelephoneNum createTelephoneNum(String intCode, String loccode, String number, String ext, String comment) {
        TelephoneNum telephoneNum = new TelephoneNum();
        telephoneNum.setIntcode(intCode);
        telephoneNum.setLoccode(loccode);
        telephoneNum.setNumber(number);
        telephoneNum.setExt(ext);
        telephoneNum.setComment(comment);
        return telephoneNum;
    }

    public static Online createOnline(String email, String uri) {
        Online online = new Online();
        online.setEmail(email);
        online.setUri(uri);
        return online;
    }

    public static EmployerInfo createEmployerInfo(String employer, String department, String jobTitle) {
        EmployerInfo employerInfo = new EmployerInfo();
        employerInfo.setEmployer(employer);
        employerInfo.setDepartment(department);
        employerInfo.setJobtitle(jobTitle);
        return employerInfo;
    }

    public static PersonName createPersonName(String prefix, String given, String family, String middle, String suffix, String nickname) {
        PersonName personName = new PersonName();
        personName.setPrefix(prefix);
        personName.setGiven(given);
        personName.setFamily(family);
        personName.setMiddle(middle);
        personName.setSuffix(suffix);
        personName.setNickname(nickname);
        return personName;
    }

    public static Extension createExtension(Object any) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)any, (String)"Any");
        Extension extension = new Extension();
        extension.setAny(any);
        return extension;
    }

    public static MissingParametersFault createMissingParametersFault() {
        MissingParametersFault missingParametersFault = new MissingParametersFault();
        return missingParametersFault;
    }

    public static OperationFailedFault createOperationFailedFault() {
        OperationFailedFault operationFailedFault = new OperationFailedFault();
        return operationFailedFault;
    }

    public static ItemDescription createItemDescription(LocalizedString description, LocalizedString displayName, String itemName) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)itemName, (String)"ItemName");
        ItemDescription itemDescription = new ItemDescription();
        itemDescription.setDescription(description);
        itemDescription.setDisplayName(displayName);
        itemDescription.setItemName(itemName);
        return itemDescription;
    }

    public static Resource createResource(String resourceName, List<ResourceValue> resourceValue) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)resourceName, (String)"ResourceName");
        Resource resource = new Resource();
        resource.setResourceName(resourceName);
        if (resourceValue != null && !resourceValue.isEmpty()) {
            resource.getValues().addAll(resourceValue);
        }
        return resource;
    }

    public static ResourceList createResourceList(List<Resource> resources) {
        if (ParameterValidation.existsAndIsNotEmpty(resources)) {
            ResourceList resourceList = new ResourceList();
            resourceList.getResources().addAll(resources);
            return resourceList;
        }
        throw new IllegalArgumentException("Must provide non-null, non-empty resource list.");
    }

    public static ResourceValue createResourceValue(String lang, String value) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)lang, (String)"Lang");
        ResourceValue resourceValue = new ResourceValue();
        resourceValue.setLang(value);
        resourceValue.setValue(value);
        return resourceValue;
    }

    public static ReturnAny createReturnAny() {
        return new ReturnAny();
    }

    public static SessionParams createSessionParams(String sessionID) {
        SessionParams sessionParams = new SessionParams();
        sessionParams.setSessionID(sessionID);
        return sessionParams;
    }

    public static UserProfile createUserProfile(PersonName name, XMLGregorianCalendar bdate, String gender, EmployerInfo employerInfo, Contact homeInfo, Contact businessInfo) {
        UserProfile userProfile = new UserProfile();
        userProfile.setName(name);
        userProfile.setBdate(bdate);
        userProfile.setGender(gender);
        userProfile.setEmployerInfo(employerInfo);
        userProfile.setHomeInfo(homeInfo);
        userProfile.setBusinessInfo(businessInfo);
        return userProfile;
    }

    public static CopyPortlets createCopyPortlets(RegistrationContext toRegistrationContext, UserContext toUserContext, RegistrationContext fromRegistrationContext, UserContext fromUserContext, List<PortletContext> fromPortletContexts) {
        if (!ParameterValidation.existsAndIsNotEmpty(fromPortletContexts)) {
            throw new IllegalArgumentException("Must provide at least one PortletContext to CopyPortlets.");
        }
        CopyPortlets copyPortlets = new CopyPortlets();
        copyPortlets.setToRegistrationContext(toRegistrationContext);
        copyPortlets.setToUserContext(toUserContext);
        copyPortlets.setFromRegistrationContext(fromRegistrationContext);
        copyPortlets.setFromUserContext(fromUserContext);
        copyPortlets.getFromPortletContexts().addAll(fromPortletContexts);
        return copyPortlets;
    }

    public static CopyPortletsResponse createCopyPortletsResponse(List<CopiedPortlet> copiedPortlets, List<FailedPortlets> failedPortlets, ResourceList resourceList) {
        CopyPortletsResponse response = new CopyPortletsResponse();
        response.getCopiedPortlets().addAll(copiedPortlets);
        response.getFailedPortlets().addAll(failedPortlets);
        response.setResourceList(resourceList);
        return response;
    }

    public static CopiedPortlet createCopiedPortlet(PortletContext newPortletContext, String fromPortletHandle) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)newPortletContext, (String)"newPortletContext");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)fromPortletHandle, (String)"fromPortletHandle", (String)"createCopiedPortlet");
        CopiedPortlet copiedPortlet = new CopiedPortlet();
        copiedPortlet.setNewPortletContext(newPortletContext);
        copiedPortlet.setFromPortletHandle(fromPortletHandle);
        return copiedPortlet;
    }

    public static NamedStringArray createNamedStringArray() {
        return new NamedStringArray();
    }

    static {
        WSRP_PNS_MAP_TOKEN.put("wsrp-navigationalValues", new String[]{"{wsrp-navigationalValues}"});
        RENDER_URL = new RenderURL(){

            public StateString getNavigationalState() {
                return WSRPTypeFactory.getTemplateNS();
            }

            public Map<String, String[]> getPublicNavigationalStateChanges() {
                return WSRP_PNS_MAP_TOKEN;
            }

            public Mode getMode() {
                return WSRPTypeFactory.getTemplateMode();
            }

            public WindowState getWindowState() {
                return WSRPTypeFactory.getTemplateWindowState();
            }

            public Map<String, String> getProperties() {
                return Collections.emptyMap();
            }
        };
        WSRP_RESOURCE_STATE_TOKEN = new OpaqueStateString("{wsrp-resourceState}");
        RESOURCE_URL = new ResourceURL(){

            public String getResourceId() {
                return "{wsrp-resourceID}";
            }

            public StateString getResourceState() {
                return WSRP_RESOURCE_STATE_TOKEN;
            }

            public CacheLevel getCacheability() {
                return CacheLevel.create((String)"{wsrp-resourceCacheability}");
            }

            public Mode getMode() {
                return WSRPTypeFactory.getTemplateMode();
            }

            public WindowState getWindowState() {
                return WSRPTypeFactory.getTemplateWindowState();
            }

            public StateString getNavigationalState() {
                return WSRPTypeFactory.getTemplateNS();
            }

            public Map<String, String> getProperties() {
                return Collections.emptyMap();
            }
        };
    }
}

