/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.registration;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.gatein.common.util.ParameterValidation;
import org.gatein.wsrp.registration.LocalizedString;
import org.gatein.wsrp.registration.PropertyDescription;
import org.gatein.wsrp.registration.ValueChangeListener;

public class RegistrationPropertyDescription
implements PropertyDescription {
    private String key;
    private QName name;
    private QName type;
    private String schemaLocation;
    private LocalizedString description;
    private LocalizedString hint;
    private LocalizedString label;
    private String[] usages;
    private QName[] aliases;
    private transient ValueChangeListener valueChangeListener;

    public RegistrationPropertyDescription(QName name, QName type) {
        this.name = name;
        this.type = type;
    }

    public RegistrationPropertyDescription(String name, QName type) {
        this(new QName(name), type);
    }

    public RegistrationPropertyDescription() {
    }

    public RegistrationPropertyDescription(RegistrationPropertyDescription other) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)other, (String)"RegistrationPropertyDescription");
        this.setName(QName.valueOf(other.name.toString()));
        this.setType(QName.valueOf(other.type.toString()));
        if (other.aliases != null) {
            this.aliases = new QName[other.aliases.length];
            System.arraycopy(other.aliases, 0, this.aliases, 0, other.aliases.length);
        }
        if (other.description != null) {
            this.setDescription(new LocalizedString(other.description));
        }
        if (other.hint != null) {
            this.setHint(new LocalizedString(other.hint));
        }
        if (other.label != null) {
            this.setLabel(new LocalizedString(other.label));
        }
        if (other.schemaLocation != null) {
            this.setSchemaLocation(other.schemaLocation);
        }
        if (other.usages != null) {
            this.usages = new String[other.usages.length];
            System.arraycopy(other.usages, 0, this.usages, 0, other.usages.length);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegistrationPropertyDescription that = (RegistrationPropertyDescription)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public String toString() {
        return "Registration Property Description named '" + this.name + "', type=" + this.type + ", hint=" + this.hint + ", label=" + this.label;
    }

    public int compareTo(PropertyDescription o) {
        return this.getName().toString().compareTo(o.getName().toString());
    }

    public String getPersistentKey() {
        return this.key;
    }

    public void setPersistentKey(String key) {
        this.key = key;
    }

    public QName getName() {
        return this.name;
    }

    public void setName(QName name) {
        if (this.valueWillBeUpdated(this.name, name)) {
            QName oldName = this.name;
            this.name = name;
            if (this.valueChangeListener != null) {
                this.valueChangeListener.valueHasChanged(this, oldName, name, true);
            }
        }
    }

    public void setNameAsString(String name) {
        this.setName(new QName(name));
    }

    public String getNameAsString() {
        return this.getName().getLocalPart();
    }

    public QName getType() {
        return this.type;
    }

    public void setType(QName type) {
        this.type = (QName)this.modifyIfNeeded(this.type, type);
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public URI getSchemaLocationAsURI() {
        try {
            return new URI(this.schemaLocation);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI: " + this.schemaLocation + ". Cause: " + e.getLocalizedMessage());
        }
    }

    public void setSchemaLocation(String schemaLocation) {
        if (schemaLocation != null) {
            try {
                new URI(schemaLocation);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid URI: " + schemaLocation + ". Cause: " + e.getLocalizedMessage());
            }
            this.schemaLocation = (String)this.modifyIfNeeded(this.schemaLocation, schemaLocation);
        }
    }

    public LocalizedString getDescription() {
        return this.description;
    }

    public void setDescription(LocalizedString description) {
        this.description = (LocalizedString)this.modifyIfNeeded(this.description, description);
    }

    public void setDefaultDescription(String value) {
        this.setDescription(value == null ? null : new LocalizedString(value));
    }

    public LocalizedString getHint() {
        return this.hint;
    }

    public void setHint(LocalizedString hint) {
        this.hint = (LocalizedString)this.modifyIfNeeded(this.hint, hint);
    }

    public void setDefaultHint(String value) {
        this.setHint(value == null ? null : new LocalizedString(value));
    }

    public LocalizedString getLabel() {
        return this.label;
    }

    public void setLabel(LocalizedString label) {
        this.label = (LocalizedString)this.modifyIfNeeded(this.label, label);
    }

    public void setDefaultLabel(String value) {
        this.setLabel(value == null ? null : new LocalizedString(value));
    }

    public String[] getUsages() {
        return this.usages;
    }

    public void setUsages(String[] usages) {
        if (!Arrays.equals(this.usages, usages)) {
            this.notifyParentOfChangeIfNeeded(this.usages, usages);
            if (usages != null) {
                this.usages = new String[usages.length];
                System.arraycopy(usages, 0, this.usages, 0, usages.length);
            } else {
                this.usages = null;
            }
        }
    }

    public QName[] getAliases() {
        return this.aliases;
    }

    public void setAliases(QName[] aliases) {
        if (!Arrays.equals(this.aliases, aliases)) {
            this.notifyParentOfChangeIfNeeded(this.aliases, aliases);
            if (aliases != null) {
                this.aliases = new QName[aliases.length];
                System.arraycopy(aliases, 0, this.aliases, 0, aliases.length);
            } else {
                this.aliases = null;
            }
        }
    }

    public void setValueChangeListener(ValueChangeListener listener) {
        this.valueChangeListener = listener;
    }

    private void notifyParentOfChangeIfNeeded(Object oldValue, Object newValue) {
        if (this.valueChangeListener != null) {
            this.valueChangeListener.valueHasChanged(this, oldValue, newValue, false);
        }
    }

    public Object modifyIfNeeded(Object oldValue, Object newValue) {
        if (this.valueWillBeUpdated(oldValue, newValue)) {
            this.notifyParentOfChangeIfNeeded(oldValue, newValue);
            oldValue = newValue;
        }
        return oldValue;
    }

    private boolean valueWillBeUpdated(Object oldValue, Object newValue) {
        return oldValue != null && !oldValue.equals(newValue) || oldValue == null && newValue != null;
    }

    public Locale getLang() {
        Locale locale;
        Locale defaultLocale = Locale.getDefault();
        Locale locale2 = locale = this.label != null ? this.label.getLocale() : defaultLocale;
        if (!defaultLocale.equals(locale)) {
            return locale;
        }
        Locale locale3 = locale = this.hint != null ? this.hint.getLocale() : defaultLocale;
        if (!defaultLocale.equals(locale)) {
            return locale;
        }
        Locale locale4 = locale = this.description != null ? this.description.getLocale() : defaultLocale;
        if (!defaultLocale.equals(locale)) {
            return locale;
        }
        return defaultLocale;
    }
}

