/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.gatein.common.net.URLTools;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.OpaqueStateString;
import org.gatein.pc.api.ResourceURL;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.cache.CacheLevel;
import org.gatein.wsrp.WSRPPortletURL;
import org.gatein.wsrp.WSRPUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSRPResourceURL
extends WSRPPortletURL
implements ResourceURL {
    public static final String DEFAULT_RESOURCE_ID = "_gtn_resid_";
    private String resourceId;
    private StateString resourceState;
    private CacheLevel cacheability;
    private boolean requiresRewrite = false;
    private URL resourceURL;
    private boolean preferOperation = false;

    public WSRPResourceURL() {
    }

    public WSRPResourceURL(Mode mode, WindowState windowState, boolean secure, StateString navigationalState, StateString resourceState, String resourceId, CacheLevel cacheability) {
        super(mode, windowState, secure, navigationalState);
        if (resourceId == null) {
            resourceId = DEFAULT_RESOURCE_ID;
        }
        this.resourceId = resourceId;
        this.resourceState = resourceState;
        this.cacheability = cacheability;
    }

    @Override
    protected String getURLType() {
        return "resource";
    }

    @Override
    protected void appendEnd(StringBuffer sb) {
        if (this.resourceURL != null) {
            this.createURLParameter(sb, "wsrp-url", URLTools.encodeXWWWFormURL((String)this.resourceURL.toExternalForm()));
        }
        this.createURLParameter(sb, "wsrp-requiresRewrite", this.requiresRewrite ? "true" : "false");
        if (this.resourceId != null) {
            this.createURLParameter(sb, "wsrp-resourceID", this.resourceId);
        }
        if (this.preferOperation) {
            this.createURLParameter(sb, "wsrp-preferOperation", Boolean.toString(this.preferOperation));
        }
        if (this.resourceState != null) {
            this.createURLParameter(sb, "wsrp-resourceState", this.resourceState.getStringValue());
        }
    }

    @Override
    protected void dealWithSpecificParams(Map<String, String> params, String originalURL) {
        String cacheabilityParam;
        String resourceIDParam;
        String url;
        String resourceState;
        super.dealWithSpecificParams(params, originalURL);
        String requireRewrite = this.getRawParameterValueFor(params, "wsrp-requiresRewrite");
        if (requireRewrite != null) {
            this.requiresRewrite = Boolean.valueOf(requireRewrite);
            params.remove("wsrp-requiresRewrite");
        }
        if ((resourceState = this.getRawParameterValueFor(params, "wsrp-resourceState")) != null) {
            this.resourceState = new OpaqueStateString(resourceState);
            params.remove("wsrp-resourceState");
        }
        if ((url = this.getRawParameterValueFor(params, "wsrp-url")) != null) {
            try {
                url = URLTools.decodeXWWWFormURL((String)url);
                this.resourceURL = new URL(url);
                params.remove("wsrp-url");
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Malformed URL: " + url, e);
            }
        }
        if ((resourceIDParam = this.getRawParameterValueFor(params, "wsrp-resourceID")) != null) {
            this.resourceId = resourceIDParam;
        }
        if (resourceIDParam == null && requireRewrite == null) {
            this.requiresRewrite = false;
        }
        if (resourceIDParam == null && url == null) {
            throw new IllegalArgumentException("The parsed parameters are not valid for a resource url. A resource URL must contain either a wsrp-resourceID or wsrp-url and wsrp-requiresRewrite parameter in " + originalURL);
        }
        String preferOperationParam = this.getRawParameterValueFor(params, "wsrp-preferOperation");
        if (preferOperationParam != null) {
            this.preferOperation = Boolean.valueOf(preferOperationParam);
        }
        if ((cacheabilityParam = this.getRawParameterValueFor(params, "wsrp-resourceCacheability")) != null) {
            this.cacheability = WSRPUtils.getCacheLevelFromResourceCacheability(cacheabilityParam);
        }
        if (resourceIDParam == null && url == null) {
            throw new IllegalArgumentException("The parsed parameters don't contain a value for  wsrp-url or for wsrp-resourceID parameter in " + originalURL);
        }
    }

    public URL getResourceURL() {
        return this.resourceURL;
    }

    public String getResourceId() {
        return WSRPResourceURL.encodeResource(this.resourceId, this.resourceURL, this.preferOperation);
    }

    public StateString getResourceState() {
        return this.resourceState;
    }

    public CacheLevel getCacheability() {
        return this.cacheability;
    }

    public boolean requiresRewrite() {
        return this.requiresRewrite;
    }

    public static String encodeResource(String resourceId, URL resourceURL, boolean preferedOperation) {
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        if (resourceId != null) {
            parameters.put("wsrp-resourceID", new String[]{resourceId});
        }
        if (resourceURL != null) {
            parameters.put("wsrp-url", new String[]{resourceURL.toString()});
        }
        parameters.put("wsrp-preferOperation", new String[]{Boolean.toString(preferedOperation)});
        return StateString.encodeAsOpaqueValue(parameters);
    }

    public static Map<String, String> decodeResource(String resourceInfo) {
        Map resourceParameters = StateString.decodeOpaqueValue((String)resourceInfo);
        HashMap<String, String> resource = new HashMap<String, String>();
        for (Map.Entry entry : resourceParameters.entrySet()) {
            if (entry.getValue() == null || ((String[])entry.getValue()).length <= 0) continue;
            resource.put((String)entry.getKey(), ((String[])entry.getValue())[0]);
        }
        return resource;
    }
}

