/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.spec.v1;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.gatein.common.text.TextTools;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.ActionURL;
import org.gatein.pc.api.ContainerURL;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.OpaqueStateString;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletStateType;
import org.gatein.pc.api.RenderURL;
import org.gatein.pc.api.ResourceURL;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.StatefulPortletContext;
import org.gatein.pc.api.URLFormat;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.cache.CacheLevel;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.WSRPResourceURL;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.spec.v1.V2ToV1Converter;
import org.oasis.wsrp.v1.V1BlockingInteractionResponse;
import org.oasis.wsrp.v1.V1CacheControl;
import org.oasis.wsrp.v1.V1ClientData;
import org.oasis.wsrp.v1.V1ClonePortlet;
import org.oasis.wsrp.v1.V1DestroyFailed;
import org.oasis.wsrp.v1.V1DestroyPortlets;
import org.oasis.wsrp.v1.V1DestroyPortletsResponse;
import org.oasis.wsrp.v1.V1GetMarkup;
import org.oasis.wsrp.v1.V1GetPortletDescription;
import org.oasis.wsrp.v1.V1GetPortletProperties;
import org.oasis.wsrp.v1.V1GetPortletPropertyDescription;
import org.oasis.wsrp.v1.V1GetServiceDescription;
import org.oasis.wsrp.v1.V1InitCookie;
import org.oasis.wsrp.v1.V1InteractionParams;
import org.oasis.wsrp.v1.V1LocalizedString;
import org.oasis.wsrp.v1.V1MarkupContext;
import org.oasis.wsrp.v1.V1MarkupParams;
import org.oasis.wsrp.v1.V1MarkupResponse;
import org.oasis.wsrp.v1.V1MarkupType;
import org.oasis.wsrp.v1.V1ModelDescription;
import org.oasis.wsrp.v1.V1ModifyRegistration;
import org.oasis.wsrp.v1.V1PerformBlockingInteraction;
import org.oasis.wsrp.v1.V1PortletContext;
import org.oasis.wsrp.v1.V1PortletDescription;
import org.oasis.wsrp.v1.V1PortletDescriptionResponse;
import org.oasis.wsrp.v1.V1PortletPropertyDescriptionResponse;
import org.oasis.wsrp.v1.V1Property;
import org.oasis.wsrp.v1.V1PropertyDescription;
import org.oasis.wsrp.v1.V1PropertyList;
import org.oasis.wsrp.v1.V1RegistrationContext;
import org.oasis.wsrp.v1.V1RegistrationData;
import org.oasis.wsrp.v1.V1ReleaseSessions;
import org.oasis.wsrp.v1.V1ResetProperty;
import org.oasis.wsrp.v1.V1RuntimeContext;
import org.oasis.wsrp.v1.V1ServiceDescription;
import org.oasis.wsrp.v1.V1SessionContext;
import org.oasis.wsrp.v1.V1SetPortletProperties;
import org.oasis.wsrp.v1.V1StateChange;
import org.oasis.wsrp.v1.V1Templates;
import org.oasis.wsrp.v1.V1UpdateResponse;
import org.oasis.wsrp.v1.V1UploadContext;
import org.oasis.wsrp.v1.V1UserContext;

public class WSRP1TypeFactory {
    private static final String REQUIRE_REWRITE_URL_PARAM = "&wsrp-requiresRewrite={wsrp-requiresRewrite}";
    private static final ActionURL ACTION_URL = new ActionURL(){

        public StateString getInteractionState() {
            return new OpaqueStateString("{wsrp-interactionState}");
        }

        public StateString getNavigationalState() {
            return WSRP1TypeFactory.getTemplateNS();
        }

        public Mode getMode() {
            return WSRP1TypeFactory.getTemplateMode();
        }

        public WindowState getWindowState() {
            return WSRP1TypeFactory.getTemplateWindowState();
        }

        public Map<String, String> getProperties() {
            return Collections.emptyMap();
        }
    };
    private static final RenderURL RENDER_URL = new RenderURL(){

        public StateString getNavigationalState() {
            return WSRP1TypeFactory.getTemplateNS();
        }

        public Map<String, String[]> getPublicNavigationalStateChanges() {
            return null;
        }

        public Mode getMode() {
            return WSRP1TypeFactory.getTemplateMode();
        }

        public WindowState getWindowState() {
            return WSRP1TypeFactory.getTemplateWindowState();
        }

        public Map<String, String> getProperties() {
            return Collections.emptyMap();
        }
    };
    private static ResourceURL RESOURCE_URL = new WSRPResourceURL(){

        @Override
        public String getResourceId() {
            return "{wsrp-url}";
        }

        @Override
        public StateString getResourceState() {
            return null;
        }

        @Override
        public CacheLevel getCacheability() {
            return null;
        }

        @Override
        public Mode getMode() {
            return WSRP1TypeFactory.getTemplateMode();
        }

        @Override
        public WindowState getWindowState() {
            return WSRP1TypeFactory.getTemplateWindowState();
        }

        @Override
        public StateString getNavigationalState() {
            return WSRP1TypeFactory.getTemplateNS();
        }
    };

    private WSRP1TypeFactory() {
    }

    public static V1GetServiceDescription createGetServiceDescription() {
        return new V1GetServiceDescription();
    }

    public static V1GetMarkup createMarkupRequest(V1PortletContext portletContext, V1RuntimeContext runtimeContext, V1MarkupParams markupParams) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)runtimeContext, (String)"RuntimeContext");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)markupParams, (String)"MarkupParams");
        V1GetMarkup getMarkup = new V1GetMarkup();
        getMarkup.setPortletContext(portletContext);
        getMarkup.setRuntimeContext(runtimeContext);
        getMarkup.setMarkupParams(markupParams);
        return getMarkup;
    }

    public static V1PerformBlockingInteraction createPerformBlockingInteraction(V1PortletContext portletContext, V1RuntimeContext runtimeContext, V1MarkupParams markupParams, V1InteractionParams interactionParams) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)portletContext.getPortletHandle(), (String)"portlet handle", (String)"PortletContext");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)runtimeContext, (String)"RuntimeContext");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)markupParams, (String)"MarkupParams");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)interactionParams, (String)"InteractionParams");
        V1PerformBlockingInteraction performBlockingInteraction = new V1PerformBlockingInteraction();
        performBlockingInteraction.setPortletContext(portletContext);
        performBlockingInteraction.setRuntimeContext(runtimeContext);
        performBlockingInteraction.setMarkupParams(markupParams);
        performBlockingInteraction.setInteractionParams(interactionParams);
        return performBlockingInteraction;
    }

    public static V1GetPortletDescription createGetPortletDescription(V1RegistrationContext registrationContext, String portletHandle) {
        V1GetPortletDescription description = new V1GetPortletDescription();
        description.setPortletContext(WSRP1TypeFactory.createPortletContext(portletHandle));
        description.setRegistrationContext(registrationContext);
        return description;
    }

    public static V1GetPortletDescription createGetPortletDescription(V1RegistrationContext registrationContext, PortletContext portletContext) {
        StatefulPortletContext context;
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"portlet context");
        V1PortletContext wsrpPC = WSRP1TypeFactory.createPortletContext(portletContext.getId());
        if (portletContext instanceof StatefulPortletContext && PortletStateType.OPAQUE.equals((context = (StatefulPortletContext)portletContext).getType())) {
            wsrpPC.setPortletState((byte[])context.getState());
        }
        V1GetPortletDescription getPortletDescription = new V1GetPortletDescription();
        getPortletDescription.setRegistrationContext(registrationContext);
        getPortletDescription.setPortletContext(wsrpPC);
        return getPortletDescription;
    }

    public static V1GetPortletProperties createGetPortletProperties(V1RegistrationContext registrationContext, V1PortletContext portletContext) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        V1GetPortletProperties properties = new V1GetPortletProperties();
        properties.setRegistrationContext(registrationContext);
        properties.setPortletContext(portletContext);
        return properties;
    }

    public static V1BlockingInteractionResponse createBlockingInteractionResponse(V1UpdateResponse updateResponse) {
        if (updateResponse == null) {
            throw new IllegalArgumentException("BlockingInteractionResponse requires either an UpdateResponse or a redirect URL.");
        }
        V1BlockingInteractionResponse interactionResponse = new V1BlockingInteractionResponse();
        interactionResponse.setUpdateResponse(updateResponse);
        return interactionResponse;
    }

    public static V1BlockingInteractionResponse createBlockingInteractionResponse(String redirectURL) {
        if (redirectURL == null || redirectURL.length() == 0) {
            throw new IllegalArgumentException("BlockingInteractionResponse requires either an UpdateResponse or a redirect URL.");
        }
        V1BlockingInteractionResponse interactionResponse = new V1BlockingInteractionResponse();
        interactionResponse.setRedirectURL(redirectURL);
        return interactionResponse;
    }

    public static V1UpdateResponse createUpdateResponse() {
        return new V1UpdateResponse();
    }

    public static V1PortletDescription createPortletDescription(PortletContext portletContext, List<V1MarkupType> markupTypes) {
        V1PortletContext context = V2ToV1Converter.toV1PortletContext(WSRPUtils.convertToWSRPPortletContext(portletContext));
        ParameterValidation.throwIllegalArgExceptionIfNull(markupTypes, (String)"MarkupType");
        if (markupTypes.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a PortletDescription with an empty list of MarkupTypes!");
        }
        V1PortletDescription portletDescription = new V1PortletDescription();
        portletDescription.setPortletHandle(context.getPortletHandle());
        portletDescription.getMarkupTypes().addAll(markupTypes);
        return portletDescription;
    }

    public static V1PortletDescription createPortletDescription(String portletHandle, List<V1MarkupType> markupTypes) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)portletHandle, (String)"portlet handle", null);
        WSRP1TypeFactory.checkPortletHandle(portletHandle);
        ParameterValidation.throwIllegalArgExceptionIfNull(markupTypes, (String)"MarkupType");
        if (markupTypes.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a PortletDescription with an empty list of MarkupTypes!");
        }
        V1PortletDescription portletDescription = new V1PortletDescription();
        portletDescription.setPortletHandle(portletHandle);
        portletDescription.getMarkupTypes().addAll(markupTypes);
        return portletDescription;
    }

    private static void checkPortletHandle(String portletHandle) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)portletHandle, (String)"portlet handle", (String)"PortletDescription");
        if (portletHandle.length() > 255) {
            throw new IllegalArgumentException("Portlet handles must be less than 255 characters long. Was " + portletHandle.length() + " long.");
        }
    }

    public static V1MarkupParams createDefaultMarkupParams() {
        return WSRP1TypeFactory.createMarkupParams(false, WSRPConstants.getDefaultLocales(), WSRPConstants.getDefaultMimeTypes(), "wsrp:view", "wsrp:normal");
    }

    public static V1MarkupParams createMarkupParams(boolean secureClientCommunication, List<String> locales, List<String> mimeTypes, String mode, String windowState) {
        ParameterValidation.throwIllegalArgExceptionIfNull(locales, (String)"locales");
        if (locales.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a MarkupParams with an empty list of locales!");
        }
        ParameterValidation.throwIllegalArgExceptionIfNull(mimeTypes, (String)"MIME types");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)mode, (String)"mode", (String)"MarkupParams");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)windowState, (String)"window state", (String)"MarkupParams");
        V1MarkupParams markupParams = new V1MarkupParams();
        markupParams.setSecureClientCommunication(secureClientCommunication);
        markupParams.setMode(mode);
        markupParams.setWindowState(windowState);
        if (ParameterValidation.existsAndIsNotEmpty(locales)) {
            markupParams.getLocales().addAll(locales);
        }
        if (ParameterValidation.existsAndIsNotEmpty(mimeTypes)) {
            markupParams.getMimeTypes().addAll(mimeTypes);
        }
        return markupParams;
    }

    public static V1RuntimeContext createRuntimeContext(String userAuthentication, String portletInstanceKey, String namespacePrefix) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)userAuthentication, (String)"user authentication", (String)"RuntimeContext");
        V1RuntimeContext runtimeContext = new V1RuntimeContext();
        runtimeContext.setUserAuthentication(userAuthentication);
        runtimeContext.setPortletInstanceKey(portletInstanceKey);
        runtimeContext.setNamespacePrefix(namespacePrefix);
        return runtimeContext;
    }

    public static V1PortletContext createPortletContext(String portletHandle) {
        WSRP1TypeFactory.checkPortletHandle(portletHandle);
        V1PortletContext portletContext = new V1PortletContext();
        portletContext.setPortletHandle(portletHandle);
        return portletContext;
    }

    public static V1PortletContext createPortletContext(String portletHandle, byte[] portletState) {
        V1PortletContext pc = WSRP1TypeFactory.createPortletContext(portletHandle);
        pc.setPortletState(portletState);
        return pc;
    }

    public static V1InteractionParams createDefaultInteractionParams() {
        return WSRP1TypeFactory.createInteractionParams(V1StateChange.READ_ONLY);
    }

    public static V1InteractionParams createInteractionParams(V1StateChange portletStateChange) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletStateChange, (String)"portletStateChange");
        V1InteractionParams interactionParams = new V1InteractionParams();
        interactionParams.setPortletStateChange(portletStateChange);
        return interactionParams;
    }

    public static V1InitCookie createInitCookie(V1RegistrationContext registrationContext) {
        V1InitCookie initCookie = new V1InitCookie();
        initCookie.setRegistrationContext(registrationContext);
        return initCookie;
    }

    public static V1ServiceDescription createServiceDescription(boolean requiresRegistration) {
        V1ServiceDescription serviceDescription = new V1ServiceDescription();
        serviceDescription.setRequiresRegistration(requiresRegistration);
        return serviceDescription;
    }

    public static V1MarkupResponse createMarkupResponse(V1MarkupContext markupContext) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)markupContext, (String)"MarkupContext");
        V1MarkupResponse markupResponse = new V1MarkupResponse();
        markupResponse.setMarkupContext(markupContext);
        return markupResponse;
    }

    public static V1MarkupContext createMarkupContext(String mediaType, String markupString, byte[] markupBinary, Boolean useCacheItem) {
        boolean isUseCacheItem = useCacheItem == null ? false : useCacheItem;
        V1MarkupContext markupContext = new V1MarkupContext();
        markupContext.setMimeType(mediaType);
        if (isUseCacheItem) {
            markupContext.setUseCachedMarkup(useCacheItem);
        } else {
            ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)mediaType, (String)"MIME type", (String)"MarkupContext");
            if (markupBinary != null) {
                markupContext.setMarkupBinary(markupBinary);
            } else if (markupString != null) {
                markupContext.setMarkupString(markupString);
            } else {
                throw new IllegalArgumentException("MarkupContext required either a true useCacheItem or a non-null markup string or binary markup");
            }
        }
        return markupContext;
    }

    public static V1SessionContext createSessionContext(String sessionID, int expires) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)sessionID, (String)"session Id", (String)"SessionContext");
        if (expires < 0) {
            throw new IllegalArgumentException("SessionContext requires a positive expiration time.");
        }
        V1SessionContext sessionContext = new V1SessionContext();
        sessionContext.setSessionID(sessionID);
        sessionContext.setExpires(expires);
        return sessionContext;
    }

    public static V1UserContext createUserContext(String userContextKey) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)userContextKey, (String)"user context key", (String)"UserContext");
        V1UserContext userContext = new V1UserContext();
        userContext.setUserContextKey(userContextKey);
        return userContext;
    }

    public static V1RegistrationData createRegistrationData(String consumerName, boolean methodGetSupported) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerName, (String)"consumer name", (String)"RegistrationData");
        V1RegistrationData regData = WSRP1TypeFactory.createDefaultRegistrationData();
        regData.setConsumerName(consumerName);
        regData.setMethodGetSupported(methodGetSupported);
        return regData;
    }

    public static V1RegistrationData createDefaultRegistrationData() {
        V1RegistrationData registrationData = new V1RegistrationData();
        registrationData.setConsumerName(WSRPConstants.DEFAULT_CONSUMER_NAME);
        registrationData.setConsumerAgent(WSRPConstants.CONSUMER_AGENT);
        registrationData.setMethodGetSupported(false);
        return registrationData;
    }

    public static V1Property createProperty(String name, String lang, String stringValue) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)name, (String)"name", (String)"Property");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)lang, (String)"language", (String)"Property");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)stringValue, (String)"String value", (String)"Property");
        V1Property property = new V1Property();
        property.setName(name);
        property.setLang(lang);
        property.setStringValue(stringValue);
        return property;
    }

    private static StateString getTemplateNS() {
        return new OpaqueStateString("{wsrp-navigationalState}");
    }

    private static WindowState getTemplateWindowState() {
        return WindowState.create((String)"{wsrp-windowState}", (boolean)true);
    }

    private static Mode getTemplateMode() {
        return Mode.create((String)"{wsrp-mode}", (boolean)true);
    }

    public static V1Templates createTemplates(PortletInvocationContext context) {
        V1Templates templates = new V1Templates();
        templates.setBlockingActionTemplate(WSRP1TypeFactory.createTemplate(context, (ContainerURL)ACTION_URL, Boolean.FALSE));
        templates.setRenderTemplate(WSRP1TypeFactory.createTemplate(context, (ContainerURL)RENDER_URL, Boolean.FALSE));
        templates.setSecureBlockingActionTemplate(WSRP1TypeFactory.createTemplate(context, (ContainerURL)ACTION_URL, Boolean.TRUE));
        templates.setSecureRenderTemplate(WSRP1TypeFactory.createTemplate(context, (ContainerURL)RENDER_URL, Boolean.TRUE));
        templates.setResourceTemplate(WSRP1TypeFactory.createTemplate(context, (ContainerURL)RESOURCE_URL, false));
        templates.setSecureResourceTemplate(WSRP1TypeFactory.createTemplate(context, (ContainerURL)RESOURCE_URL, true));
        return templates;
    }

    private static String createTemplate(PortletInvocationContext context, ContainerURL url, Boolean secure) {
        String template = context.renderURL(url, new URLFormat(secure, null, null, Boolean.valueOf(true)));
        template = TextTools.replace((String)template, (String)"%7B", (String)"{");
        template = TextTools.replace((String)template, (String)"%7D", (String)"}");
        if (RESOURCE_URL == url) {
            template = template + REQUIRE_REWRITE_URL_PARAM;
        }
        return template;
    }

    public static V1ClientData createClientData(String userAgent) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)userAgent, (String)"user agent", (String)"ClientData");
        V1ClientData clientData = new V1ClientData();
        clientData.setUserAgent(userAgent);
        return clientData;
    }

    public static V1CacheControl createCacheControl(int expires, String userScope) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)userScope, (String)"user scope", (String)"CacheControl");
        if (expires < -1) {
            throw new IllegalArgumentException("Cache expiration time must be greater than -1, -1 indicating that the cache will never expire.");
        }
        V1CacheControl cacheControl = new V1CacheControl();
        cacheControl.setExpires(expires);
        cacheControl.setUserScope(userScope);
        return cacheControl;
    }

    public static V1RegistrationContext createRegistrationContext(String registrationHandle) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)registrationHandle, (String)"Registration handle");
        V1RegistrationContext registrationContext = new V1RegistrationContext();
        registrationContext.setRegistrationHandle(registrationHandle);
        return registrationContext;
    }

    public static V1ModelDescription createModelDescription(List<V1PropertyDescription> propertyDescriptions) {
        V1ModelDescription description = new V1ModelDescription();
        if (ParameterValidation.existsAndIsNotEmpty(propertyDescriptions)) {
            description.getPropertyDescriptions().addAll(propertyDescriptions);
        }
        return description;
    }

    public static V1PropertyDescription createPropertyDescription(String name, QName type) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)name, (String)"PropertyDescription name");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)type, (String)"PropertyDescription type");
        V1PropertyDescription description = new V1PropertyDescription();
        description.setName(name);
        description.setType(type);
        return description;
    }

    public static V1LocalizedString createLocalizedString(String lang, String resourceName, String value) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)lang, (String)"LocalizedString language");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)value, (String)"LocalizedString value");
        V1LocalizedString localizedString = new V1LocalizedString();
        localizedString.setLang(lang);
        localizedString.setResourceName(resourceName);
        localizedString.setValue(value);
        return localizedString;
    }

    public static V1LocalizedString createLocalizedString(String value) {
        return WSRP1TypeFactory.createLocalizedString("en", null, value);
    }

    public static V1PortletDescriptionResponse createPortletDescriptionResponse(V1PortletDescription portletDescription) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletDescription, (String)"PortletDescription");
        V1PortletDescriptionResponse response = new V1PortletDescriptionResponse();
        response.setPortletDescription(portletDescription);
        return response;
    }

    public static V1PortletPropertyDescriptionResponse createPortletPropertyDescriptionResponse(List<V1PropertyDescription> propertyDescriptions) {
        V1ModelDescription modelDescription = propertyDescriptions == null ? null : WSRP1TypeFactory.createModelDescription(propertyDescriptions);
        V1PortletPropertyDescriptionResponse portletPropertyDescriptionResponse = new V1PortletPropertyDescriptionResponse();
        portletPropertyDescriptionResponse.setModelDescription(modelDescription);
        return portletPropertyDescriptionResponse;
    }

    public static V1GetPortletPropertyDescription createGetPortletPropertyDescription(V1RegistrationContext registrationContext, V1PortletContext portletContext, V1UserContext userContext, List<String> desiredLocales) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        V1GetPortletPropertyDescription description = new V1GetPortletPropertyDescription();
        description.setRegistrationContext(registrationContext);
        description.setPortletContext(portletContext);
        description.setUserContext(userContext);
        if (ParameterValidation.existsAndIsNotEmpty(desiredLocales)) {
            description.getDesiredLocales().addAll(desiredLocales);
        }
        return description;
    }

    public static V1GetPortletPropertyDescription createSimpleGetPortletPropertyDescription(String portletHandle) {
        return WSRP1TypeFactory.createGetPortletPropertyDescription(null, WSRP1TypeFactory.createPortletContext(portletHandle), null, null);
    }

    public static V1DestroyFailed createDestroyFailed(String portletHandle, String reason) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)portletHandle, (String)"Portlet handle", (String)"DestroyFailed");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)reason, (String)"Reason for failure", (String)"DestroyFailed");
        V1DestroyFailed destroyFailed = new V1DestroyFailed();
        destroyFailed.setPortletHandle(portletHandle);
        destroyFailed.setReason(reason);
        return destroyFailed;
    }

    public static V1DestroyPortletsResponse createDestroyPortletsResponse(List<V1DestroyFailed> destroyFailed) {
        V1DestroyPortletsResponse destroyPortletsResponse = new V1DestroyPortletsResponse();
        if (ParameterValidation.existsAndIsNotEmpty(destroyFailed)) {
            destroyPortletsResponse.getDestroyFailed().addAll(destroyFailed);
        }
        return destroyPortletsResponse;
    }

    public static V1SetPortletProperties createSetPortletProperties(V1RegistrationContext registrationContext, V1PortletContext portletContext, V1PropertyList propertyList) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)propertyList, (String)"PropertyList");
        V1SetPortletProperties properties = new V1SetPortletProperties();
        properties.setRegistrationContext(registrationContext);
        properties.setPortletContext(portletContext);
        properties.setPropertyList(propertyList);
        return properties;
    }

    public static V1ClonePortlet createSimpleClonePortlet(String portletHandle) {
        return WSRP1TypeFactory.createClonePortlet(null, WSRP1TypeFactory.createPortletContext(portletHandle), null);
    }

    public static V1ClonePortlet createClonePortlet(V1RegistrationContext registrationContext, V1PortletContext portletContext, V1UserContext userContext) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        V1ClonePortlet clonePortlet = new V1ClonePortlet();
        clonePortlet.setPortletContext(portletContext);
        clonePortlet.setRegistrationContext(registrationContext);
        clonePortlet.setUserContext(userContext);
        return clonePortlet;
    }

    public static V1DestroyPortlets createDestroyPortlets(V1RegistrationContext registrationContext, List<String> portletHandles) {
        ParameterValidation.throwIllegalArgExceptionIfNull(portletHandles, (String)"Portlet handles");
        if (portletHandles.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a DestroyPortlets with an empty list of portlet handles!");
        }
        V1DestroyPortlets destroyPortlets = new V1DestroyPortlets();
        destroyPortlets.setRegistrationContext(registrationContext);
        if (ParameterValidation.existsAndIsNotEmpty(portletHandles)) {
            destroyPortlets.getPortletHandles().addAll(portletHandles);
        }
        return destroyPortlets;
    }

    public static V1PropertyList createPropertyList() {
        return new V1PropertyList();
    }

    public static V1ResetProperty createResetProperty(String name) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)name, (String)"Property name", (String)"ResetProperty");
        V1ResetProperty resetProperty = new V1ResetProperty();
        resetProperty.setName(name);
        return resetProperty;
    }

    public static V1ReleaseSessions createReleaseSessions(V1RegistrationContext registrationContext, List<String> sessionIDs) {
        ParameterValidation.throwIllegalArgExceptionIfNull(sessionIDs, (String)"Session IDs");
        if (sessionIDs.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a ReleaseSessions with an empty list of session IDs!");
        }
        V1ReleaseSessions sessions = new V1ReleaseSessions();
        sessions.setRegistrationContext(registrationContext);
        if (ParameterValidation.existsAndIsNotEmpty(sessionIDs)) {
            sessions.getSessionIDs().addAll(sessionIDs);
        }
        return sessions;
    }

    public static V1ModifyRegistration createModifyRegistration(V1RegistrationContext registrationContext, V1RegistrationData registrationData) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)registrationData, (String)"RegistrationData");
        V1ModifyRegistration registration = new V1ModifyRegistration();
        registration.setRegistrationContext(registrationContext);
        registration.setRegistrationData(registrationData);
        return registration;
    }

    public static V1UploadContext createUploadContext(String mimeType, byte[] uploadData) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)mimeType, (String)"MIME Type", (String)"UploadContext");
        if (uploadData == null || uploadData.length == 0) {
            throw new IllegalArgumentException("Must pass non-null, non-empty upload data");
        }
        V1UploadContext uploadContext = new V1UploadContext();
        uploadContext.setMimeType(mimeType);
        uploadContext.setUploadData(uploadData);
        return uploadContext;
    }

    public static V1MarkupType createMarkupType(String mimeType, List<String> modeNames, List<String> windowStateNames, List<String> localeNames) {
        V1MarkupType markupType = new V1MarkupType();
        markupType.setMimeType(mimeType);
        if (ParameterValidation.existsAndIsNotEmpty(modeNames)) {
            markupType.getModes().addAll(modeNames);
        }
        if (ParameterValidation.existsAndIsNotEmpty(windowStateNames)) {
            markupType.getWindowStates().addAll(windowStateNames);
        }
        if (ParameterValidation.existsAndIsNotEmpty(localeNames)) {
            markupType.getLocales().addAll(localeNames);
        }
        return markupType;
    }
}

