/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp;

import java.util.Map;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.RenderURL;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.WindowState;
import org.gatein.wsrp.WSRPPortletURL;
import org.gatein.wsrp.WSRPUtils;

public class WSRPRenderURL
extends WSRPPortletURL
implements RenderURL {
    private Map<String, String[]> publicNSChanges;

    protected WSRPRenderURL(Mode mode, WindowState windowState, boolean secure, StateString navigationalState, Map<String, String[]> publicNavigationalStateChanges, WSRPPortletURL.URLContext context) {
        super(mode, windowState, secure, navigationalState, context);
        this.publicNSChanges = publicNavigationalStateChanges;
    }

    protected WSRPRenderURL() {
    }

    @Override
    protected void dealWithSpecificParams(Map<String, String> params, String originalURL) {
        super.dealWithSpecificParams(params, originalURL);
        String paramValue = this.getRawParameterValueFor(params, "wsrp-navigationalValues");
        if (paramValue != null) {
            this.publicNSChanges = WSRPUtils.decodePublicNS(paramValue);
            params.remove("wsrp-navigationalValues");
        }
    }

    @Override
    protected String getURLType() {
        return "render";
    }

    public Map<String, String[]> getPublicNavigationalStateChanges() {
        return this.publicNSChanges;
    }

    @Override
    protected void appendEnd(StringBuffer sb) {
        if (this.publicNSChanges != null) {
            this.createURLParameter(sb, "wsrp-navigationalValues", WSRPUtils.encodePublicNS(this.publicNSChanges));
        }
    }
}

