/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.registration;

import java.io.Serializable;
import java.util.Locale;
import org.gatein.common.util.ParameterValidation;

public class LocalizedString
implements Serializable {
    private String value;
    private Locale locale;
    private String resourceName;

    public LocalizedString(String value, Locale locale) {
        this.setValue(value);
        this.locale = locale;
    }

    public LocalizedString(String value) {
        this(value, Locale.getDefault());
    }

    public LocalizedString() {
    }

    public LocalizedString(LocalizedString other) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)other, (String)"LocalizedString");
        this.value = other.value;
        this.locale = other.locale;
        this.resourceName = other.resourceName;
    }

    public String toString() {
        return "LocalizedString{value='" + this.value + '\'' + ", locale=" + this.locale + ", resourceName='" + this.resourceName + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalizedString that = (LocalizedString)o;
        if (!this.locale.equals(that.locale)) {
            return false;
        }
        if (this.resourceName != null ? !this.resourceName.equals(that.resourceName) : that.resourceName != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + this.locale.hashCode();
        result = 31 * result + (this.resourceName != null ? this.resourceName.hashCode() : 0);
        return result;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)value, (String)"value", (String)"LocalizedString");
        this.value = value;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)locale, (String)"locale");
        this.locale = locale;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }
}

