/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp;

import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.gatein.common.net.URLTools;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.cache.CacheLevel;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.WSRPPortletURL;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.WSRPUtils;
import org.oasis.wsrp.v2.GetResource;
import org.oasis.wsrp.v2.NamedString;
import org.oasis.wsrp.v2.RegistrationContext;
import org.oasis.wsrp.v2.ResourceParams;
import org.oasis.wsrp.v2.RuntimeContext;
import org.oasis.wsrp.v2.StateChange;

public class ResourceServingUtil {
    private static final String REG_HANDLE = "regHandle";
    private static final String INSTANCE_KEY = "instanceKey";
    private static final String NS = "ns";
    private static final String MODE = "mode";
    private static final String WINDOW_STATE = "windowState";
    private static final String RESOURCE_STATE = "resourceState";
    private static final String NAV_STATE = "navState";
    private static final String SLASH_REPLACEMENT = "__";
    private static final String QMARK = "?";

    public static GetResource decode(HttpServletRequest req) {
        String path = req.getPathInfo();
        int portletHandleEnd = path.indexOf("/", 1);
        String portletHandle = path.substring(1, portletHandleEnd);
        org.oasis.wsrp.v2.PortletContext portletContext = ResourceServingUtil.decode(portletHandle);
        String resourceId = path.substring(portletHandleEnd);
        String registrationHandle = req.getParameter(REG_HANDLE);
        RegistrationContext registrationContext = null;
        if (!ParameterValidation.isNullOrEmpty((String)registrationHandle)) {
            registrationContext = WSRPTypeFactory.createRegistrationContext(registrationHandle);
        }
        String instanceKey = URLTools.decodeXWWWFormURL((String)req.getParameter(INSTANCE_KEY));
        String ns = req.getParameter(NS);
        RuntimeContext runtimeContext = WSRPTypeFactory.createRuntimeContext("wsrp:none", instanceKey, ns);
        Enumeration reqLocales = req.getLocales();
        List<String> locales = WSRPUtils.convertLocalesToRFC3066LanguageTags(Collections.list(reqLocales));
        List<String> mimeTypes = WSRPConstants.getDefaultMimeTypes();
        ResourceParams resourceParams = WSRPTypeFactory.createResourceParams(req.isSecure(), locales, mimeTypes, "wsrp:view", "wsrp:normal", resourceId, StateChange.READ_ONLY);
        resourceParams.setResourceState(req.getParameter(RESOURCE_STATE));
        String navState = req.getParameter(NAV_STATE);
        if (!ParameterValidation.isNullOrEmpty((String)navState)) {
            resourceParams.setNavigationalContext(WSRPTypeFactory.createNavigationalContext(navState, Collections.<NamedString>emptyList()));
        }
        return WSRPTypeFactory.createGetResource(registrationContext, portletContext, runtimeContext, null, resourceParams);
    }

    public static URL encode(Mode mode, WindowState windowState, boolean secure, StateString navigationalState, StateString resourceState, String resourceId, CacheLevel cacheability, WSRPPortletURL.URLContext context) {
        String serverAddress = (String)context.getValueFor("org.gatein.wsrp.server.address");
        PortletContext portletContext = (PortletContext)context.getValueFor("org.gatein.wsrp.portlet.context");
        try {
            StringBuilder sb = new StringBuilder(ResourceServingUtil.createAbsoluteURLFrom(resourceId, serverAddress, portletContext));
            ResourceServingUtil.appendParameter(sb, MODE, mode);
            ResourceServingUtil.appendParameter(sb, WINDOW_STATE, windowState);
            String instanceKey = (String)context.getValueFor("org.gatein.wsrp.instance.key");
            instanceKey = URLTools.encodeXWWWFormURL((String)instanceKey);
            ResourceServingUtil.appendParameter(sb, INSTANCE_KEY, instanceKey);
            ResourceServingUtil.appendParameter(sb, NS, context.getValueFor("org.gatein.wsrp.namespace"));
            ResourceServingUtil.appendParameter(sb, REG_HANDLE, context.getValueFor("org.gatein.wsrp.registration"));
            if (resourceState != null) {
                ResourceServingUtil.appendParameter(sb, RESOURCE_STATE, resourceState.getStringValue());
            }
            if (navigationalState != null) {
                ResourceServingUtil.appendParameter(sb, NAV_STATE, navigationalState.getStringValue());
            }
            return new URI(sb.toString()).toURL();
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't create an absolute URL from resourceId: " + resourceId + ", server address: " + serverAddress + ", portlet: " + portletContext, e);
        }
    }

    private static String createAbsoluteURLFrom(String resourceId, String serverAddress, PortletContext portletContext) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)resourceId, (String)"resource ID", null);
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)serverAddress, (String)"server address", null);
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"portlet context");
        String url = serverAddress + "/wsrp-producer/resource/";
        url = url + ResourceServingUtil.encode(portletContext);
        url = resourceId.startsWith("/") ? url + resourceId + QMARK : url + "/" + resourceId + QMARK;
        return url;
    }

    private static String encode(PortletContext portletContext) {
        String id = portletContext.getId();
        if (id.startsWith("/")) {
            id = id.replace("/", SLASH_REPLACEMENT);
        }
        return URLTools.encodeXWWWFormURL((String)id);
    }

    private static org.oasis.wsrp.v2.PortletContext decode(String encodedPortletContext) {
        if (encodedPortletContext.startsWith(SLASH_REPLACEMENT)) {
            encodedPortletContext = encodedPortletContext.replace(SLASH_REPLACEMENT, "/");
        }
        return WSRPTypeFactory.createPortletContext(URLTools.decodeXWWWFormURL((String)encodedPortletContext));
    }

    private static void appendParameter(StringBuilder builder, String name, Object value) {
        if (value != null) {
            builder.append("&").append(name).append("=").append(value);
        }
    }
}

