/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer;

import java.util.BitSet;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.InvokerUnavailableException;
import org.gatein.wsrp.consumer.ConsumerException;
import org.gatein.wsrp.consumer.ProducerInfo;
import org.gatein.wsrp.services.SOAPServiceFactory;
import org.gatein.wsrp.services.ServiceFactory;
import org.oasis.wsrp.v1.WSRPV1MarkupPortType;
import org.oasis.wsrp.v1.WSRPV1PortletManagementPortType;
import org.oasis.wsrp.v1.WSRPV1RegistrationPortType;
import org.oasis.wsrp.v1.WSRPV1ServiceDescriptionPortType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointConfigurationInfo {
    private static final Logger log = LoggerFactory.getLogger(EndpointConfigurationInfo.class);
    private Long key;
    private String persistentServiceDescriptionURL = "MUST BE SET";
    private String persistentMarkupURL = "MUST BE SET";
    private String persistentRegistrationURL;
    private String persistentPortletManagementURL;
    private String persistentWsdlDefinitionURL = "MUST BE SET";
    private transient SOAPServiceFactory serviceFactory;
    private transient String remoteHostAddress;
    public static final String UNSET = "MUST BE SET";
    private BitSet clean = new BitSet();
    private static final int SD = 0;
    private static final int M = 1;
    private static final int PM = 2;
    private static final int R = 3;
    private boolean usingWSDL = true;
    private boolean isModifiedWSDL;

    public EndpointConfigurationInfo(ProducerInfo producerInfo) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)producerInfo, (String)"ProducerInfo");
        producerInfo.setEndpointConfigurationInfo(this);
        this.serviceFactory = new SOAPServiceFactory();
    }

    public Long getKey() {
        return this.key;
    }

    public void setKey(Long key) {
        this.key = key;
    }

    public boolean usesWSDL() {
        return this.isWSDLNotNullAndSet() && !this.isModifiedWSDL || this.usingWSDL;
    }

    public void setUsesWSDL(boolean useWSDL) {
        this.usingWSDL = useWSDL;
    }

    public String getWsdlDefinitionURL() {
        if (this.serviceFactory != null) {
            this.persistentWsdlDefinitionURL = this.serviceFactory.getWsdlDefinitionURL();
        }
        return this.persistentWsdlDefinitionURL;
    }

    public String getServiceDescriptionURL() {
        if (this.serviceFactory != null) {
            this.persistentServiceDescriptionURL = this.serviceFactory.getServiceDescriptionURL();
        }
        return this.persistentServiceDescriptionURL;
    }

    public String getMarkupURL() {
        if (this.serviceFactory != null) {
            this.persistentMarkupURL = this.serviceFactory.getMarkupURL();
        }
        return this.persistentMarkupURL;
    }

    public String getPortletManagementURL() {
        if (this.serviceFactory != null) {
            this.persistentPortletManagementURL = this.serviceFactory.getPortletManagementURL();
        }
        return this.persistentPortletManagementURL;
    }

    public String getRegistrationURL() {
        if (this.serviceFactory != null) {
            this.persistentRegistrationURL = this.serviceFactory.getRegistrationURL();
        }
        return this.persistentRegistrationURL;
    }

    public void setServiceDescriptionURL(String serviceDescriptionURL) {
        if (this.serviceFactory != null) {
            this.serviceFactory.setServiceDescriptionURL(serviceDescriptionURL);
        }
        this.persistentServiceDescriptionURL = this.modifyIfNeeded(this.persistentServiceDescriptionURL, serviceDescriptionURL, 0);
    }

    public void setMarkupURL(String markupURL) {
        if (this.serviceFactory != null) {
            this.serviceFactory.setMarkupURL(markupURL);
        }
        this.persistentMarkupURL = this.modifyIfNeeded(this.persistentMarkupURL, markupURL, 1);
    }

    public void setRegistrationURL(String registrationURL) {
        if (this.serviceFactory != null) {
            this.serviceFactory.setRegistrationURL(registrationURL);
        }
        this.persistentRegistrationURL = this.modifyIfNeeded(this.persistentRegistrationURL, registrationURL, 3);
    }

    public void setPortletManagementURL(String portletManagementURL) {
        if (this.serviceFactory != null) {
            this.serviceFactory.setPortletManagementURL(portletManagementURL);
        }
        this.persistentPortletManagementURL = this.modifyIfNeeded(this.persistentPortletManagementURL, portletManagementURL, 2);
    }

    public void setWsdlDefinitionURL(String wsdlDefinitionURL) throws RuntimeException {
        this.persistentWsdlDefinitionURL = wsdlDefinitionURL;
        if (this.isWSDLNotNullAndSet()) {
            this.usingWSDL = true;
            this.internalSetWsdlURL();
        } else {
            this.usingWSDL = false;
        }
    }

    private boolean isWSDLNotNullAndSet() {
        return this.persistentWsdlDefinitionURL != null && !UNSET.equals(this.persistentWsdlDefinitionURL);
    }

    private String modifyIfNeeded(String oldValue, String newValue, int whichURL) {
        if (oldValue != null && !oldValue.equals(newValue) || oldValue == null && newValue != null) {
            if (this.usesWSDL()) {
                this.isModifiedWSDL = true;
                this.usingWSDL = false;
            }
            oldValue = newValue;
            this.clean.clear(whichURL);
        }
        return oldValue;
    }

    private ServiceFactory initServiceFactoryIfNeeded() throws RuntimeException {
        if (this.serviceFactory == null) {
            this.serviceFactory = new SOAPServiceFactory();
            if (this.usesWSDL()) {
                this.internalSetWsdlURL();
            } else if (!UNSET.equals(this.persistentServiceDescriptionURL) && !UNSET.equals(this.persistentMarkupURL)) {
                this.serviceFactory.setServiceDescriptionURL(this.persistentServiceDescriptionURL);
                this.serviceFactory.setMarkupURL(this.persistentMarkupURL);
                this.serviceFactory.setPortletManagementURL(this.persistentPortletManagementURL);
                this.serviceFactory.setRegistrationURL(this.persistentRegistrationURL);
            } else {
                throw new IllegalStateException("Cannot initialize ServiceFactory: missing either service description or markup URLs!");
            }
            this.startServiceFactoryIfNeeded();
        }
        return this.serviceFactory;
    }

    private void startServiceFactoryIfNeeded() {
        if (!this.serviceFactory.isAvailable()) {
            if (!this.serviceFactory.isFailed()) {
                try {
                    this.serviceFactory.start();
                    this.refreshServices(this.serviceFactory);
                }
                catch (Exception e) {
                    throw new ConsumerException("Couldn't start ServiceFactory", e);
                }
            } else {
                throw new ConsumerException("ServiceFactory has an error condition that couldn't be recovered from.");
            }
        }
    }

    private void internalSetWsdlURL() {
        try {
            this.serviceFactory.setWsdlDefinitionURL(this.persistentWsdlDefinitionURL);
            this.persistentMarkupURL = this.serviceFactory.getMarkupURL();
            this.persistentPortletManagementURL = this.serviceFactory.getPortletManagementURL();
            this.persistentRegistrationURL = this.serviceFactory.getRegistrationURL();
            this.persistentServiceDescriptionURL = this.serviceFactory.getServiceDescriptionURL();
            this.clean.set(0, 4);
            this.isModifiedWSDL = false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void start() throws Exception {
        this.initServiceFactoryIfNeeded();
    }

    public void stop() throws Exception {
        if (this.serviceFactory != null) {
            this.serviceFactory.stop();
        }
    }

    private ServiceFactory getServiceFactory() {
        this.initServiceFactoryIfNeeded();
        this.startServiceFactoryIfNeeded();
        return this.serviceFactory;
    }

    WSRPV1ServiceDescriptionPortType getServiceDescriptionService() throws InvokerUnavailableException {
        return this.getService(WSRPV1ServiceDescriptionPortType.class);
    }

    WSRPV1MarkupPortType getMarkupService() throws InvokerUnavailableException {
        return this.getService(WSRPV1MarkupPortType.class);
    }

    WSRPV1PortletManagementPortType getPortletManagementService() throws InvokerUnavailableException {
        return this.getService(WSRPV1PortletManagementPortType.class);
    }

    WSRPV1RegistrationPortType getRegistrationService() throws InvokerUnavailableException {
        return this.getService(WSRPV1RegistrationPortType.class);
    }

    private <T> T getService(Class<T> clazz) throws InvokerUnavailableException {
        return this.getService(clazz, this.getServiceFactory());
    }

    private <T> T getService(Class<T> clazz, ServiceFactory serviceFactory) throws InvokerUnavailableException {
        try {
            T service = serviceFactory.getService(clazz);
            this.clean.set(this.getIndexFor(clazz));
            return service;
        }
        catch (Exception e) {
            throw new InvokerUnavailableException("Couldn't access " + clazz.getSimpleName() + " service. Cause: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private int getIndexFor(Class clazz) {
        if (clazz == WSRPV1ServiceDescriptionPortType.class) {
            return 0;
        }
        if (clazz == WSRPV1MarkupPortType.class) {
            return 1;
        }
        if (clazz == WSRPV1PortletManagementPortType.class) {
            return 2;
        }
        return 3;
    }

    public boolean isAvailable() {
        return this.serviceFactory.isAvailable();
    }

    public boolean isRefreshNeeded() {
        boolean result;
        boolean bl = result = !this.isAvailable() || this.areURLsDirty();
        if (result) {
            log.debug("Refresh needed");
        }
        return result;
    }

    private boolean areURLsDirty() {
        return !this.clean.get(0) || !this.clean.get(1) || this.persistentPortletManagementURL != null && !this.clean.get(2) || this.persistentRegistrationURL != null && !this.clean.get(3);
    }

    public void refresh() throws InvokerUnavailableException {
        if (this.isRefreshNeeded()) {
            this.forceRefresh();
        }
    }

    void forceRefresh() throws InvokerUnavailableException {
        ServiceFactory serviceFactory = this.initServiceFactoryIfNeeded();
        this.refreshServices(serviceFactory);
    }

    private void refreshServices(ServiceFactory serviceFactory) throws InvokerUnavailableException {
        if (this.areURLsDirty()) {
            this.getService(WSRPV1ServiceDescriptionPortType.class, serviceFactory);
            this.getService(WSRPV1MarkupPortType.class, serviceFactory);
            if (this.persistentPortletManagementURL != null) {
                this.getService(WSRPV1PortletManagementPortType.class, serviceFactory);
            }
            if (this.persistentRegistrationURL != null) {
                this.getService(WSRPV1RegistrationPortType.class, serviceFactory);
            }
        }
    }

    public String getRemoteHostAddress() {
        if (this.remoteHostAddress == null || this.areURLsDirty()) {
            int hostBegin = this.persistentMarkupURL.indexOf("://") + 3;
            this.remoteHostAddress = this.persistentMarkupURL.substring(0, this.persistentMarkupURL.indexOf(47, hostBegin));
        }
        return this.remoteHostAddress;
    }
}

