/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.ws.Holder;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.InvokerUnavailableException;
import org.gatein.pc.api.NoSuchPortletException;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.PortletStateType;
import org.gatein.pc.api.invocation.ActionInvocation;
import org.gatein.pc.api.invocation.InvocationException;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.RenderInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.pc.api.spi.UserContext;
import org.gatein.pc.api.state.DestroyCloneFailure;
import org.gatein.pc.api.state.PropertyChange;
import org.gatein.pc.api.state.PropertyMap;
import org.gatein.pc.portlet.impl.spi.AbstractPortletInvocationContext;
import org.gatein.pc.portlet.state.SimplePropertyMap;
import org.gatein.wsrp.UserContextConverter;
import org.gatein.wsrp.WSRPConsumer;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.api.SessionEvent;
import org.gatein.wsrp.consumer.ActionHandler;
import org.gatein.wsrp.consumer.EndpointConfigurationInfo;
import org.gatein.wsrp.consumer.InvocationHandler;
import org.gatein.wsrp.consumer.ProducerInfo;
import org.gatein.wsrp.consumer.ProducerSessionInformation;
import org.gatein.wsrp.consumer.RefreshResult;
import org.gatein.wsrp.consumer.RenderHandler;
import org.gatein.wsrp.consumer.SessionHandler;
import org.gatein.wsrp.consumer.portlet.WSRPPortlet;
import org.gatein.wsrp.consumer.portlet.info.WSRPPortletInfo;
import org.gatein.wsrp.servlet.UserAccess;
import org.oasis.wsrp.v1.DestroyFailed;
import org.oasis.wsrp.v1.Property;
import org.oasis.wsrp.v1.PropertyList;
import org.oasis.wsrp.v1.RegistrationContext;
import org.oasis.wsrp.v1.RegistrationData;
import org.oasis.wsrp.v1.ResetProperty;
import org.oasis.wsrp.v1.RuntimeContext;
import org.oasis.wsrp.v1.WSRPV1MarkupPortType;
import org.oasis.wsrp.v1.WSRPV1PortletManagementPortType;
import org.oasis.wsrp.v1.WSRPV1RegistrationPortType;
import org.oasis.wsrp.v1.WSRPV1ServiceDescriptionPortType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSRPConsumerImpl
implements WSRPConsumer {
    private ActionHandler actionHandler;
    private RenderHandler renderHandler;
    private SessionHandler sessionHandler;
    private ProducerInfo producerInfo;
    private static final RegistrationData REGISTRATION_NOT_NEEDED = WSRPTypeFactory.createDefaultRegistrationData();
    private static final Logger log = LoggerFactory.getLogger(WSRPConsumer.class);
    private static final Set<String> WSRP_DEFAULT_USER_SCOPE;
    private Set supportedUserScopes = WSRP_DEFAULT_USER_SCOPE;
    private transient boolean started;

    public WSRPConsumerImpl() {
        this(new ProducerInfo());
    }

    public WSRPConsumerImpl(ProducerInfo info) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)info, (String)"ProducerInfo");
        this.producerInfo = info;
        this.actionHandler = new ActionHandler(this);
        this.renderHandler = new RenderHandler(this);
        this.sessionHandler = new SessionHandler(this);
    }

    @Override
    public ProducerInfo getProducerInfo() {
        return this.producerInfo;
    }

    @Override
    public void setProducerInfo(ProducerInfo producerInfo) {
        this.producerInfo = producerInfo;
    }

    public Set getPortlets() throws InvokerUnavailableException {
        try {
            Map<String, Portlet> portletMap = this.producerInfo.getPortletMap();
            return new LinkedHashSet<Portlet>(portletMap.values());
        }
        catch (Exception e) {
            throw new InvokerUnavailableException(e.getMessage(), e.getCause());
        }
    }

    public Portlet getPortlet(PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        Portlet portlet = this.producerInfo.getPortlet(portletContext);
        if (portlet == null) {
            throw new NoSuchPortletException(portletContext.getId());
        }
        return portlet;
    }

    public PortletInvocationResponse invoke(PortletInvocation invocation) throws PortletInvokerException {
        InvocationHandler handler;
        if (invocation instanceof RenderInvocation) {
            handler = this.renderHandler;
        } else if (invocation instanceof ActionInvocation) {
            handler = this.actionHandler;
        } else {
            throw new InvocationException("Unknown invocation type: " + invocation);
        }
        return handler.handle(invocation);
    }

    public PortletContext createClone(PortletStateType stateType, PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        if (!PortletStateType.OPAQUE.equals(stateType)) {
            throw new IllegalArgumentException("This PortletInvoker cannot deal with PortletStateTypes other than PortletStateType.OPAQUE. Given: " + stateType);
        }
        WSRPPortlet original = this.getWSRPPortlet(portletContext);
        if (original == null) {
            throw new PortletInvokerException("No portlet '" + portletContext.getId() + "' to clone!");
        }
        try {
            Holder handle = new Holder();
            Holder portletState = new Holder();
            this.getPortletManagementService().clonePortlet(this.getRegistrationContext(), WSRPUtils.convertToWSRPPortletContext((PortletContext)portletContext), UserAccess.getUserContext(), handle, portletState, new Holder());
            return WSRPUtils.convertToPortalPortletContext((String)((String)handle.value), (byte[])((byte[])portletState.value));
        }
        catch (Exception e) {
            throw new PortletInvokerException("Couldn't clone portlet '" + portletContext.getId() + "'", (Throwable)e);
        }
    }

    public List destroyClones(List portletContexts) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContexts, (String)"Portlet identifiers");
        int numberOfClones = portletContexts.size();
        if (numberOfClones == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> handles = new ArrayList<String>(numberOfClones);
        for (Object portletContext : portletContexts) {
            PortletContext context = (PortletContext)portletContext;
            String id = context.getId();
            handles.add(id);
        }
        log.debug("Attempting to destroy clones: " + handles);
        try {
            Holder destroyFailed = new Holder();
            this.getPortletManagementService().destroyPortlets(this.getRegistrationContext(), handles, destroyFailed, new Holder());
            List failures = (List)destroyFailed.value;
            List result = Collections.emptyList();
            if (failures != null) {
                result = new ArrayList(failures.size());
                for (DestroyFailed failure : failures) {
                    String handle = failure.getPortletHandle();
                    result.add(new DestroyCloneFailure(handle, failure.getReason()));
                    handles.remove(handle);
                    log.debug("Couldn't destroy clone '" + handle + "'");
                }
            }
            if (!handles.isEmpty()) {
                for (String handle : handles) {
                    this.producerInfo.removeHandleFromCaches(handle);
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new PortletInvokerException("Couldn't destroy clones.", (Throwable)e);
        }
    }

    public PropertyMap getProperties(PortletContext portletContext, Set<String> keys) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        ParameterValidation.throwIllegalArgExceptionIfNull(keys, (String)"Portlet ids");
        return this.getProperties(portletContext, new ArrayList<String>(keys));
    }

    private PropertyMap getProperties(PortletContext portletContext, List<String> keys) throws PortletInvokerException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        try {
            Holder properties = new Holder();
            Holder resetProperties = new Holder();
            this.getPortletManagementService().getPortletProperties(this.getRegistrationContext(), WSRPUtils.convertToWSRPPortletContext((PortletContext)portletContext), UserAccess.getUserContext(), keys, properties, resetProperties, new Holder());
            List props = (List)properties.value;
            if (props != null) {
                SimplePropertyMap result = new SimplePropertyMap(props.size());
                for (Property prop : props) {
                    String name = prop.getName();
                    String value = prop.getStringValue();
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(value);
                    result.put((Object)name, list);
                }
                return result;
            }
            return new SimplePropertyMap();
        }
        catch (Exception e) {
            log.debug("Couldn't get properties for portlet '" + portletContext.getId() + "'", (Throwable)e);
            return new SimplePropertyMap();
        }
    }

    public PropertyMap getProperties(PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        return this.getProperties(portletContext, Collections.<String>emptyList());
    }

    public PortletContext setProperties(PortletContext portletContext, PropertyChange[] changes) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"PortletContext");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((Object[])changes, (String)"Property changes");
        WSRPPortlet portlet = this.getWSRPPortlet(portletContext);
        if (portlet == null) {
            throw new PortletInvokerException("Cannot set properties on portlet '" + portletContext.getId() + "' because there is no such portlet.");
        }
        PropertyList propertyList = WSRPTypeFactory.createPropertyList();
        int changesNumber = changes.length;
        ArrayList<Property> updates = new ArrayList<Property>(changesNumber);
        ArrayList<ResetProperty> resets = new ArrayList<ResetProperty>(changesNumber);
        block6: for (int i = 0; i < changesNumber; ++i) {
            PropertyChange change = changes[i];
            switch (change.getType()) {
                case 1: {
                    resets.add(WSRPTypeFactory.createResetProperty((String)change.getKey()));
                    continue block6;
                }
                case 0: {
                    updates.add(WSRPTypeFactory.createProperty((String)change.getKey(), (String)WSRPUtils.toString((Locale)Locale.getDefault()), (String)((String)change.getValue().get(0))));
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected property change type: " + change.getType());
                }
            }
        }
        propertyList.getProperties().addAll(updates);
        propertyList.getResetProperties().addAll(resets);
        try {
            Holder handle = new Holder();
            Holder portletState = new Holder();
            this.getPortletManagementService().setPortletProperties(this.getRegistrationContext(), WSRPUtils.convertToWSRPPortletContext((PortletContext)portletContext), UserAccess.getUserContext(), propertyList, handle, portletState, new Holder());
            PortletContext newPortletContext = PortletContext.createPortletContext((String)((String)handle.value), (byte[])((byte[])portletState.value));
            portlet.setPortletContext(newPortletContext);
            return newPortletContext;
        }
        catch (Exception e) {
            throw new PortletInvokerException("Unable to set properties for portlet '" + portletContext.getId() + "'", (Throwable)e);
        }
    }

    @Override
    public String getProducerId() {
        return this.producerInfo.getId();
    }

    public SessionHandler getSessionHandler() {
        return this.sessionHandler;
    }

    public Map<String, Set<Portlet>> getPortletGroupMap() throws PortletInvokerException {
        return this.producerInfo.getPortletGroupMap();
    }

    static PortletContext getPortletContext(PortletInvocation invocation) {
        return invocation.getTarget();
    }

    WSRPPortletInfo getPortletInfo(PortletInvocation invocation) throws PortletInvokerException {
        return (WSRPPortletInfo)this.getWSRPPortlet(WSRPConsumerImpl.getPortletContext(invocation)).getInfo();
    }

    WSRPPortlet getWSRPPortlet(PortletContext portletContext) throws PortletInvokerException {
        return (WSRPPortlet)this.getPortlet(portletContext);
    }

    public Set getSupportedUserScopes() {
        return Collections.unmodifiableSet(this.supportedUserScopes);
    }

    public boolean supportsUserScope(String userScope) {
        return this.supportedUserScopes.contains(userScope);
    }

    void handleInvalidRegistrationFault() throws PortletInvokerException {
        this.producerInfo.resetRegistration();
        this.refreshProducerInfo(true);
    }

    RegistrationContext getRegistrationContext() throws PortletInvokerException {
        return this.producerInfo.getRegistrationContext();
    }

    @Override
    public ProducerSessionInformation getProducerSessionInformationFrom(PortletInvocation invocation) {
        return this.sessionHandler.getProducerSessionInformation(invocation);
    }

    @Override
    public ProducerSessionInformation getProducerSessionInformationFrom(HttpSession session) {
        return this.sessionHandler.getProducerSessionInformation(session);
    }

    @Override
    public void activate() throws Exception {
        this.internalStart();
        this.producerInfo.setActiveAndSave(true);
    }

    private void internalStart() throws Exception {
        if (!this.started) {
            try {
                this.start();
            }
            catch (Exception e) {
                this.producerInfo.setActiveAndSave(false);
                throw e;
            }
            log.info("Consumer with id '" + this.getProducerId() + "' activated");
        }
    }

    @Override
    public void deactivate() throws Exception {
        this.producerInfo.setActiveAndSave(false);
        if (this.started) {
            this.stop();
            log.info("Consumer with id '" + this.getProducerId() + "' deactivated");
        }
    }

    @Override
    public boolean isActive() {
        return this.producerInfo.isActive() && this.started;
    }

    @Override
    public boolean isRefreshNeeded() {
        return !this.started || this.producerInfo.isRefreshNeeded(false);
    }

    @Override
    public RefreshResult refresh(boolean forceRefresh) throws PortletInvokerException {
        try {
            this.internalStart();
        }
        catch (Exception e) {
            throw new PortletInvokerException((Throwable)e);
        }
        RefreshResult refreshResult = this.producerInfo.detailedRefresh(forceRefresh);
        this.sessionHandler.setRequiresInitCookie(this.producerInfo.getRequiresInitCookie());
        return refreshResult;
    }

    @Override
    public void start() throws Exception {
        this.getEndpointConfigurationInfo().start();
        this.started = true;
        log.info("Consumer with id '" + this.getProducerId() + "' started");
    }

    @Override
    public void stop() throws Exception {
        this.getEndpointConfigurationInfo().stop();
        this.started = false;
        log.info("Consumer with id '" + this.getProducerId() + "' stopped");
    }

    private EndpointConfigurationInfo getEndpointConfigurationInfo() {
        return this.producerInfo.getEndpointConfigurationInfo();
    }

    public WSRPV1ServiceDescriptionPortType getServiceDescriptionService() throws PortletInvokerException {
        this.refreshProducerInfo(false);
        return this.getEndpointConfigurationInfo().getServiceDescriptionService();
    }

    public WSRPV1MarkupPortType getMarkupService() throws PortletInvokerException {
        this.refreshProducerInfo(false);
        return this.getEndpointConfigurationInfo().getMarkupService();
    }

    public WSRPV1PortletManagementPortType getPortletManagementService() throws PortletInvokerException {
        this.refreshProducerInfo(false);
        return this.getEndpointConfigurationInfo().getPortletManagementService();
    }

    public WSRPV1RegistrationPortType getRegistrationService() throws PortletInvokerException {
        this.refreshProducerInfo(false);
        return this.getEndpointConfigurationInfo().getRegistrationService();
    }

    @Override
    public void refreshProducerInfo() throws PortletInvokerException {
        this.refreshProducerInfo(true);
    }

    private void refreshProducerInfo(boolean forceRefresh) throws PortletInvokerException {
        this.producerInfo.refresh(forceRefresh);
        this.sessionHandler.setRequiresInitCookie(this.producerInfo.getRequiresInitCookie());
    }

    @Override
    public void releaseSessions() throws PortletInvokerException {
        this.sessionHandler.releaseSessions();
    }

    private String getUserContextKeyFor(UserContext userContext) {
        String userId = userContext.getId();
        if (userId != null) {
            return userId;
        }
        return null;
    }

    org.oasis.wsrp.v1.UserContext getUserContextFrom(PortletInvocation invocation, RuntimeContext runtimeContext) throws PortletInvokerException {
        WSRPPortletInfo info = this.getPortletInfo(invocation);
        if (info != null && info.isUserContextStoredInSession() && runtimeContext.getSessionID() != null) {
            return null;
        }
        UserContext userContext = invocation.getUserContext();
        if (userContext != null) {
            String userContextKey = this.getUserContextKeyFor(userContext);
            if (userContextKey == null) {
                return null;
            }
            return UserContextConverter.createWSRPUserContextFrom((UserContext)userContext, (String)userContextKey, null);
        }
        return null;
    }

    void setTemplatesIfNeeded(PortletInvocation invocation, RuntimeContext runtimeContext) throws PortletInvokerException {
        WSRPPortletInfo info = this.getPortletInfo(invocation);
        if (info != null && info.isDoesUrlTemplateProcessing() && (!info.isTemplatesStoredInSession() || runtimeContext.getSessionID() == null)) {
            runtimeContext.setTemplates(WSRPTypeFactory.createTemplates((PortletInvocationContext)invocation.getContext()));
        }
    }

    static HttpServletRequest getHttpRequest(PortletInvocation invocation) {
        AbstractPortletInvocationContext invocationContext = (AbstractPortletInvocationContext)invocation.getContext();
        return invocationContext.getClientRequest();
    }

    static HttpSession getHttpSession(PortletInvocation invocation) {
        return WSRPConsumerImpl.getHttpRequest(invocation).getSession();
    }

    public void onSessionEvent(SessionEvent event) {
        this.sessionHandler.onSessionEvent(event);
    }

    static {
        REGISTRATION_NOT_NEEDED.setConsumerAgent("INVALID AGENT");
        REGISTRATION_NOT_NEEDED.setConsumerName("INVALID NAME");
        WSRP_DEFAULT_USER_SCOPE = new HashSet<String>(2);
        WSRP_DEFAULT_USER_SCOPE.add("wsrp:forAll");
        WSRP_DEFAULT_USER_SCOPE.add("wsrp:perUser");
    }
}

