/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.registry;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.federation.FederatedPortletInvoker;
import org.gatein.pc.federation.FederatingPortletInvoker;
import org.gatein.wsrp.WSRPConsumer;
import org.gatein.wsrp.api.SessionEventBroadcaster;
import org.gatein.wsrp.api.SessionEventListener;
import org.gatein.wsrp.consumer.ConsumerException;
import org.gatein.wsrp.consumer.ProducerInfo;
import org.gatein.wsrp.consumer.WSRPConsumerImpl;
import org.gatein.wsrp.consumer.registry.ConsumerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConsumerRegistry
implements ConsumerRegistry {
    private FederatingPortletInvoker federatingPortletInvoker;
    protected SortedMap<String, WSRPConsumer> consumers;
    private SessionEventBroadcaster sessionEventBroadcaster;
    private static final String CONSUMER_WITH_ID = "Consumer with id '";
    private static final String RELEASE_SESSIONS_LISTENER = "release_sessions_listener_";
    private static final Logger log = LoggerFactory.getLogger(AbstractConsumerRegistry.class);

    @Override
    public FederatingPortletInvoker getFederatingPortletInvoker() {
        return this.federatingPortletInvoker;
    }

    @Override
    public void setSessionEventBroadcaster(SessionEventBroadcaster sessionEventBroadcaster) {
        this.sessionEventBroadcaster = sessionEventBroadcaster;
    }

    @Override
    public WSRPConsumer createConsumer(String id, Integer expirationCacheSeconds) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)id, (String)"Consumer identifier", (String)"Creating a Consumer");
        if (this.getConsumer(id) != null) {
            throw new ConsumerException(CONSUMER_WITH_ID + id + "' already exists!");
        }
        ProducerInfo info = new ProducerInfo();
        info.setId(id);
        info.setRegistry(this);
        info.setExpirationCacheSeconds(expirationCacheSeconds);
        this.save(info, "Couldn't create Consumer '" + id + "'");
        log.info(CONSUMER_WITH_ID + id + "' created");
        return this.createConsumerFrom(info);
    }

    @Override
    public void destroyConsumer(String id) {
        ProducerInfo info;
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)id, (String)"Consumer identifier", (String)"Destroying a Consumer");
        WSRPConsumer consumer = this.getConsumer(id);
        if (consumer != null) {
            info = consumer.getProducerInfo();
            try {
                consumer.releaseSessions();
            }
            catch (PortletInvokerException e) {
                log.debug("releaseSessions failed when attempting to destroy Consumer with id '" + id + "'");
            }
            if (info.isRegistered()) {
                this.registerOrDeregisterConsumerWith(id, false);
            }
        } else {
            throw new ConsumerException(CONSUMER_WITH_ID + id + "' doesn't exist!");
        }
        this.deactivateConsumerWith(id);
        this.consumers.remove(id);
        this.delete(info);
        log.info(CONSUMER_WITH_ID + id + "' destroyed");
    }

    @Override
    public void persistConsumer(WSRPConsumer consumer) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)consumer, (String)"Consumer");
        ProducerInfo info = consumer.getProducerInfo();
        this.save(info, CONSUMER_WITH_ID + info.getId() + "' couldn't be persisted!");
        this.createConsumerFrom(info);
    }

    @Override
    public void setFederatingPortletInvoker(FederatingPortletInvoker federatingPortletInvoker) {
        this.federatingPortletInvoker = federatingPortletInvoker;
    }

    private WSRPConsumer createConsumerFrom(ProducerInfo producerInfo) {
        WSRPConsumerImpl consumer = new WSRPConsumerImpl(producerInfo);
        this.consumers.put(producerInfo.getId(), consumer);
        return consumer;
    }

    @Override
    public void activateConsumerWith(String id) throws ConsumerException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)id, (String)"Consumer identifier", (String)"Activating a Consumer");
        if (this.federatingPortletInvoker.getFederatedInvoker(id) == null) {
            this.startOrStopConsumer(id, true);
        } else {
            WSRPConsumer consumer = this.getConsumer(id);
            if (consumer != null && !consumer.isActive()) {
                this.federatingPortletInvoker.unregisterInvoker(id);
                this.startOrStopConsumer(id, true);
            }
        }
    }

    @Override
    public void deactivateConsumerWith(String id) throws ConsumerException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)id, (String)"Consumer identifier", (String)"Deactivating a Consumer");
        if (this.federatingPortletInvoker.getFederatedInvoker(id) != null) {
            this.startOrStopConsumer(id, false);
        } else {
            WSRPConsumer consumer = this.getConsumer(id);
            if (consumer != null && consumer.isActive()) {
                this.federatingPortletInvoker.registerInvoker(id, (PortletInvoker)consumer);
                this.startOrStopConsumer(id, false);
            }
        }
    }

    @Override
    public void updateProducerInfo(ProducerInfo producerInfo) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)producerInfo, (String)"ProducerInfo");
        String oldId = this.update(producerInfo);
        if (oldId != null) {
            WSRPConsumer consumer = (WSRPConsumer)this.consumers.remove(oldId);
            this.consumers.put(producerInfo.getId(), consumer);
        }
    }

    @Override
    public void start() throws Exception {
        this.reloadConsumers();
    }

    @Override
    public void reloadConsumers() {
        this.consumers = new TreeMap<String, WSRPConsumer>();
        Iterator producerInfos = this.getAllProducerInfos();
        while (producerInfos.hasNext()) {
            ProducerInfo producerInfo = (ProducerInfo)producerInfos.next();
            producerInfo.setRegistry(this);
            this.createConsumerFrom(producerInfo);
            try {
                if (!producerInfo.isActive()) continue;
                this.activateConsumerWith(producerInfo.getId());
            }
            catch (Exception e) {
                producerInfo.setActive(false);
                this.updateProducerInfo(producerInfo);
            }
        }
    }

    @Override
    public void stop() throws Exception {
        for (WSRPConsumer consumer : this.consumers.values()) {
            if (consumer.getProducerInfo().isActive()) {
                this.federatingPortletInvoker.unregisterInvoker(consumer.getProducerId());
            }
            try {
                consumer.stop();
            }
            catch (Exception exception) {}
        }
        this.consumers.clear();
        this.consumers = null;
    }

    @Override
    public List<WSRPConsumer> getConfiguredConsumers() {
        return new ArrayList<WSRPConsumer>(this.consumers.values());
    }

    @Override
    public WSRPConsumer getConsumer(String id) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)id, (String)"consumer id", null);
        return (WSRPConsumer)this.consumers.get(id);
    }

    @Override
    public void registerOrDeregisterConsumerWith(String id, boolean register) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)id, (String)"Consumer identifier", (String)"Registering or deregistering a Consumer");
        WSRPConsumer consumer = this.getConsumer(id);
        if (consumer == null) {
            throw new ConsumerException(CONSUMER_WITH_ID + id + "' doesn't exist!");
        }
        try {
            if (register) {
                consumer.getProducerInfo().register();
            } else {
                consumer.getProducerInfo().deregister();
            }
        }
        catch (Exception e) {
            this.deactivateConsumerWith(id);
            Throwable cause = e.getCause();
            throw new ConsumerException("Couldn't " + (register ? "register" : "deregister") + CONSUMER_WITH_ID + id + "'", cause != null ? cause : e);
        }
    }

    private void startOrStopConsumer(String id, boolean start) {
        WSRPConsumer consumer;
        block6: {
            try {
                if (start) {
                    consumer = this.getConsumer(id);
                    if (consumer == null) {
                        throw new IllegalArgumentException(CONSUMER_WITH_ID + id + "' doesn't exist!");
                    }
                    consumer.activate();
                    this.federatingPortletInvoker.registerInvoker(id, (PortletInvoker)consumer);
                    this.sessionEventBroadcaster.registerListener(this.getListenerIdFrom(id), (SessionEventListener)consumer);
                    break block6;
                }
                FederatedPortletInvoker fedInvoker = this.federatingPortletInvoker.getFederatedInvoker(id);
                if (fedInvoker != null) {
                    PortletInvoker invoker = fedInvoker.getPortletInvoker();
                    if (invoker instanceof WSRPConsumer) {
                        consumer = (WSRPConsumer)invoker;
                        consumer.deactivate();
                        this.federatingPortletInvoker.unregisterInvoker(id);
                        this.sessionEventBroadcaster.unregisterListener(this.getListenerIdFrom(id));
                        break block6;
                    }
                    throw new IllegalArgumentException("PortletInvoker with id '" + id + "' is not a WSRPConsumer!");
                }
                throw new IllegalArgumentException("There is no registered PortletInvoker with id '" + id + "'");
            }
            catch (Exception e) {
                throw new ConsumerException("Couldn't " + (start ? "start" : "stop") + " Consumer service '" + id + "'", e);
            }
        }
        this.updateProducerInfo(consumer.getProducerInfo());
    }

    private String getListenerIdFrom(String id) {
        return RELEASE_SESSIONS_LISTENER + id;
    }

    protected abstract void save(ProducerInfo var1, String var2);

    protected abstract void delete(ProducerInfo var1);

    protected abstract String update(ProducerInfo var1);

    protected abstract Iterator getAllProducerInfos();
}

