/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.registry.xml;

import java.util.SortedMap;
import java.util.TreeMap;
import org.gatein.common.util.ParameterValidation;
import org.gatein.wsrp.WSRPConsumer;
import org.gatein.wsrp.consumer.EndpointConfigurationInfo;
import org.gatein.wsrp.consumer.ProducerInfo;
import org.gatein.wsrp.consumer.RegistrationInfo;
import org.gatein.wsrp.consumer.registry.ConsumerRegistry;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.xb.binding.GenericObjectModelFactory;
import org.jboss.xb.binding.UnmarshallingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLWSRPConsumerFactory
implements GenericObjectModelFactory {
    private static final Logger log = LoggerFactory.getLogger(XMLWSRPConsumerFactory.class);
    private ConsumerRegistry consumerRegistry;
    private static final boolean DEBUG = false;
    private static final String WSRP_PRODUCER = "wsrp-producer";

    public XMLWSRPConsumerFactory(ConsumerRegistry consumerRegistry) {
        this.consumerRegistry = consumerRegistry;
    }

    public Object newRoot(Object root, UnmarshallingContext nav, String nsURI, String localName, Attributes attrs) {
        return new TreeMap();
    }

    public Object completeRoot(Object root, UnmarshallingContext nav, String nsURI, String localName) {
        return root;
    }

    public Object newChild(Object parent, UnmarshallingContext unmarshallingContext, String nsURI, String localName, Attributes attributes) {
        if (parent instanceof SortedMap) {
            return this.newChild((SortedMap)parent, unmarshallingContext, nsURI, localName, attributes);
        }
        if (parent instanceof RegistrationInfo) {
            return this.newChild((RegistrationInfo)parent, unmarshallingContext, nsURI, localName, attributes);
        }
        if (parent instanceof WSRPConsumer) {
            return this.newChild((WSRPConsumer)parent, unmarshallingContext, nsURI, localName, attributes);
        }
        return null;
    }

    public void addChild(Object parent, Object child, UnmarshallingContext unmarshallingContext, String nsURI, String localName) {
        if (parent instanceof RegistrationInfo && child instanceof Property) {
            this.addChild((RegistrationInfo)parent, (Property)child, unmarshallingContext, nsURI, localName);
        } else if (parent instanceof SortedMap && child instanceof WSRPConsumer) {
            this.addChild((SortedMap)parent, (WSRPConsumer)child, unmarshallingContext, nsURI, localName);
        }
    }

    public void setValue(Object parent, UnmarshallingContext unmarshallingContext, String nsURI, String localName, String value) {
        if (parent instanceof EndpointConfigurationInfo) {
            this.setValue((EndpointConfigurationInfo)parent, unmarshallingContext, nsURI, localName, value);
        } else if (parent instanceof Property) {
            this.setValue((Property)parent, unmarshallingContext, nsURI, localName, value);
        } else if (parent instanceof RegistrationInfo) {
            this.setValue((RegistrationInfo)parent, unmarshallingContext, nsURI, localName, value);
        }
    }

    public Object newChild(SortedMap<String, WSRPConsumer> consumers, UnmarshallingContext nav, String nsURI, String localName, Attributes attrs) {
        if (WSRP_PRODUCER.equals(localName)) {
            String id = attrs.getValue("id");
            ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)id, (String)"producer identifier", (String)"Configuring a producer");
            WSRPConsumer consumer = this.consumerRegistry.getConsumer(id);
            if (consumer != null) {
                String message = "Added consumer for producer '" + id + "' with status: ";
                if (consumer.getProducerInfo().isActive()) {
                    consumers.put(id, consumer);
                    message = message + "active";
                } else {
                    message = message + "inactive";
                }
                log.info(message + " (loaded from database).");
                return null;
            }
            String expirationCache = attrs.getValue("expiration-cache");
            Integer expirationCacheSeconds = null;
            if (expirationCache != null) {
                try {
                    expirationCacheSeconds = new Integer(expirationCache);
                }
                catch (NumberFormatException e) {
                    log.info("Ignoring bad expiration cache value " + expirationCache + " for producer '" + id + "'");
                }
            }
            consumer = this.consumerRegistry.createConsumer(id, expirationCacheSeconds);
            return consumer;
        }
        return null;
    }

    public Object newChild(WSRPConsumer consumer, UnmarshallingContext nav, String nsURI, String localName, Attributes attrs) {
        ProducerInfo prodInfo = consumer.getProducerInfo();
        if ("endpoint-config".equals(localName) || "endpoint-wsdl-url".equals(localName)) {
            return prodInfo.getEndpointConfigurationInfo();
        }
        if ("registration-data".equals(localName)) {
            return new RegistrationInfo(prodInfo);
        }
        return null;
    }

    public Object newChild(RegistrationInfo registrationInfo, UnmarshallingContext nav, String nsURI, String localName, Attributes attrs) {
        if ("property".equals(localName)) {
            return new Property();
        }
        return null;
    }

    public void setValue(EndpointConfigurationInfo endpointInfo, UnmarshallingContext nav, String nsURI, String localName, String value) {
        if ("endpoint-wsdl-url".equals(localName)) {
            value = StringPropertyReplacer.replaceProperties((String)value);
            endpointInfo.setWsdlDefinitionURL(value);
        }
    }

    public void setValue(RegistrationInfo registrationInfo, UnmarshallingContext nav, String nsURI, String localName, String value) {
        if ("consumer-name".equals(localName)) {
            value = StringPropertyReplacer.replaceProperties((String)value);
            registrationInfo.setConsumerName(value);
        }
    }

    public void setValue(Property property, UnmarshallingContext nav, String nsURI, String localName, String value) {
        if ("name".equals(localName)) {
            property.name = value = StringPropertyReplacer.replaceProperties((String)value);
        } else if ("lang".equals(localName)) {
            property.lang = value = StringPropertyReplacer.replaceProperties((String)value);
        } else if ("value".equals(localName)) {
            property.value = value = StringPropertyReplacer.replaceProperties((String)value);
        }
    }

    public void addChild(RegistrationInfo registrationInfo, Property property, UnmarshallingContext nav, String nsURI, String localName) {
        registrationInfo.setRegistrationPropertyValue(property.name, property.value).setLang(property.lang);
    }

    public void addChild(SortedMap<String, WSRPConsumer> consumers, WSRPConsumer consumer, UnmarshallingContext nav, String nsURI, String localName) {
        ProducerInfo info = consumer.getProducerInfo();
        String id = consumer.getProducerId();
        consumers.put(id, consumer);
        log.info("Added consumer for producer '" + id + "' from xml configuration.");
        try {
            this.consumerRegistry.updateProducerInfo(info);
        }
        catch (Exception e) {
            consumers.remove(id);
            log.info("Couldn't update the ProducerInfo for Consumer '" + info.getId() + "'", (Throwable)e);
        }
    }

    public static class Property {
        String name;
        String value;
        String lang;
    }
}

