/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer;

import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.InvokerUnavailableException;
import org.gatein.wsrp.services.SOAPServiceFactory;
import org.gatein.wsrp.services.ServiceFactory;
import org.oasis.wsrp.v1.WSRPV1MarkupPortType;
import org.oasis.wsrp.v1.WSRPV1PortletManagementPortType;
import org.oasis.wsrp.v1.WSRPV1RegistrationPortType;
import org.oasis.wsrp.v1.WSRPV1ServiceDescriptionPortType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointConfigurationInfo {
    private static final Logger log = LoggerFactory.getLogger(EndpointConfigurationInfo.class);
    private transient ServiceFactory serviceFactory;
    private transient String remoteHostAddress;

    public EndpointConfigurationInfo() {
        this.serviceFactory = new SOAPServiceFactory();
    }

    EndpointConfigurationInfo(ServiceFactory serviceFactory) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)serviceFactory, (String)"ServiceFactory");
        this.serviceFactory = serviceFactory;
    }

    public String getWsdlDefinitionURL() {
        return this.serviceFactory.getWsdlDefinitionURL();
    }

    public void setWsdlDefinitionURL(String wsdlDefinitionURL) {
        this.serviceFactory.setWsdlDefinitionURL(wsdlDefinitionURL);
    }

    public void start() throws Exception {
        this.serviceFactory.start();
    }

    public void stop() throws Exception {
        this.serviceFactory.stop();
    }

    ServiceFactory getServiceFactory() {
        try {
            this.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.serviceFactory;
    }

    WSRPV1ServiceDescriptionPortType getServiceDescriptionService() throws InvokerUnavailableException {
        return this.getService(WSRPV1ServiceDescriptionPortType.class);
    }

    WSRPV1MarkupPortType getMarkupService() throws InvokerUnavailableException {
        return this.getService(WSRPV1MarkupPortType.class);
    }

    WSRPV1PortletManagementPortType getPortletManagementService() throws InvokerUnavailableException {
        return this.getService(WSRPV1PortletManagementPortType.class);
    }

    WSRPV1RegistrationPortType getRegistrationService() throws InvokerUnavailableException {
        return this.getService(WSRPV1RegistrationPortType.class);
    }

    private <T> T getService(Class<T> clazz) throws InvokerUnavailableException {
        return this.getService(clazz, this.getServiceFactory());
    }

    private <T> T getService(Class<T> clazz, ServiceFactory serviceFactory) throws InvokerUnavailableException {
        try {
            return serviceFactory.getService(clazz);
        }
        catch (Exception e) {
            throw new InvokerUnavailableException("Couldn't access " + clazz.getSimpleName() + " service. Cause: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public boolean isAvailable() {
        return this.serviceFactory.isAvailable();
    }

    public boolean isRefreshNeeded() {
        boolean result;
        boolean bl = result = !this.isAvailable();
        if (result) {
            log.debug("Refresh needed");
        }
        return result;
    }

    public void refresh() throws InvokerUnavailableException {
        if (this.isRefreshNeeded()) {
            this.forceRefresh();
        }
    }

    void forceRefresh() throws InvokerUnavailableException {
        this.getService(WSRPV1ServiceDescriptionPortType.class, this.serviceFactory);
        this.getService(WSRPV1MarkupPortType.class, this.serviceFactory);
        this.getService(WSRPV1PortletManagementPortType.class, this.serviceFactory);
        this.getService(WSRPV1RegistrationPortType.class, this.serviceFactory);
    }

    public String getRemoteHostAddress() {
        if (this.remoteHostAddress == null) {
            String wsdl = this.getWsdlDefinitionURL();
            int hostBegin = wsdl.indexOf("://") + 3;
            this.remoteHostAddress = wsdl.substring(0, wsdl.indexOf(47, hostBegin));
        }
        return this.remoteHostAddress;
    }

    public void setWSOperationTimeOut(int msBeforeTimeOut) {
        this.serviceFactory.setWSOperationTimeOut(msBeforeTimeOut);
    }

    public int getWSOperationTimeOut() {
        return this.serviceFactory.getWSOperationTimeOut();
    }
}

